/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.api;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import net.wildfyre.areas.Areas;
import net.wildfyre.descriptors.Descriptor;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.Users;
import net.wildfyre.utils.InvalidCredentialsException;

public class Internal {
    private static String token;
    static ThreadPoolExecutor executor;
    private static Consumer<NoSuchEntityException> noSuchEntityHandler;
    private static Consumer<Request.CantConnectException> cantConnectHandler;

    public static void clear() {
        Users.clear();
        Areas.INSTANCE.clear();
    }

    public static void clean() {
        Users.clean();
        Areas.INSTANCE.clean();
    }

    public static void reset() {
        Internal.clear();
        token = null;
        Users.reset();
    }

    public static String token() {
        return token;
    }

    static void throwNoSuchEntity(NoSuchEntityException e) {
        if (noSuchEntityHandler == null) {
            throw new RuntimeException("Warning: no handler was specified for NoSuchEntityException, but one wasneeded. See Internal.setNoSuchEntityHandler().", e);
        }
        noSuchEntityHandler.accept(e);
    }

    public static void setNoSuchEntityHandler(Consumer<NoSuchEntityException> consumer) {
        if (noSuchEntityHandler != null) {
            System.err.println("Warning: Internal.setNoSuchEntityHandler() was called a second time. The elder consumer will be kept.");
            return;
        }
        if (consumer == null) {
            throw new NullPointerException("The consumer cannot be null.");
        }
        noSuchEntityHandler = consumer;
    }

    public static void throwCantConnect(Request.CantConnectException e) {
        if (cantConnectHandler == null) {
            throw new RuntimeException("Warning: no handler was specified for CantConnectException, but one wasneeded. See Internal.setCantConnectHandler().", e);
        }
        cantConnectHandler.accept(e);
    }

    public static void setCantConnectHandler(Consumer<Request.CantConnectException> consumer) {
        if (cantConnectHandler != null) {
            System.err.println("Warning: Internal.setCantConnectHandler() was called a second time. The elder consumer will be kept.");
            return;
        }
        if (consumer == null) {
            throw new NullPointerException("The consumer cannot be null.");
        }
        cantConnectHandler = consumer;
    }

    public static void submit(Runnable task) {
        executor.submit(task);
    }

    public static <D extends Descriptor> void submitUpdate(D descriptor) {
        executor.submit(() -> {
            try {
                descriptor.update();
            }
            catch (NoSuchEntityException e) {
                Internal.throwNoSuchEntity(e);
            }
            catch (Request.CantConnectException e) {
                Internal.throwCantConnect(e);
            }
        });
    }

    public static void requestToken(String username, String password) throws Request.CantConnectException, InvalidCredentialsException {
        block3: {
            try {
                JsonObject json = new Request(Method.POST, "/account/auth/").addJson((JsonValue)new JsonObject().add("username", username).add("password", password)).getJson().asObject();
                token = json.getString("token", null);
                if (token == null) {
                    throw new RuntimeException("Could not find the token in the request body!\n" + json.toString(WriterConfig.PRETTY_PRINT));
                }
                Internal.clear();
            }
            catch (IssueInTransferException e) {
                JsonValue j = e.getJson();
                if (j == null || !j.asObject().get("non_field_errors").asArray().get(0).asString().equals("Unable to log in with provided credentials.")) break block3;
                throw new InvalidCredentialsException("Unable to log in with provided credentials.", e);
            }
        }
    }

    public static void setToken(String token) {
        if (token == null) {
            throw new NullPointerException("The token should not be 'null'.");
        }
        if (token.isEmpty()) {
            throw new IllegalArgumentException("The token should not be empty, size:" + token.length());
        }
        Internal.token = token;
        Internal.clear();
    }

    public static void init() throws Request.CantConnectException {
        Internal.clear();
        Users.init();
        Areas.INSTANCE.init();
    }

    static {
        executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    }
}

