/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.users;

import com.eclipsesource.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.wildfyre.api.Internal;
import net.wildfyre.descriptors.Descriptor;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.LoggedUser;

public class User
extends Descriptor {
    protected final int ID;
    protected String name = "";
    protected String avatar = "";
    protected String bio = "";
    protected boolean isBanned;

    User(int id) {
        this.ID = id;
    }

    @Override
    public void update() {
        try {
            JsonObject values = new Request(Method.GET, "/users/" + this.ID + "/").get().asObject();
            this.name = values.getString("name", this.name);
            this.avatar = values.getString("avatar", this.avatar);
            this.bio = values.getString("bio", this.bio);
            this.isBanned = values.getBoolean("banned", this.isBanned);
            int user = values.getInt("user", this.ID);
            if (user != this.ID) {
                throw new RuntimeException("The ID has changed! " + this.ID + " -> " + user);
            }
            this.use();
        }
        catch (IssueInTransferException | Request.CantConnectException e) {
            e.printStackTrace();
        }
    }

    public static User query(int id) {
        User user = Internal.getCachedUser(id).orElseGet(() -> User.create(id));
        if (user.isNew()) {
            user.update();
        }
        if (!user.isValid()) {
            Internal.submit(user::update);
        }
        user.use();
        return user;
    }

    static User create(int id) {
        return Internal.isMyId(id) ? new LoggedUser(id) : new User(id);
    }

    public boolean canEdit() {
        return false;
    }

    public final LoggedUser asLogged() throws ClassCastException {
        this.use();
        return (LoggedUser)this;
    }

    public int getID() {
        this.use();
        return this.ID;
    }

    public String getAvatar() {
        this.use();
        return this.avatar;
    }

    public URL getAvatarUrl() {
        this.use();
        try {
            return new URL(this.avatar);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Since URLs are sent by the server, they shouldn't be malformed...", e);
        }
    }

    public String getBio() {
        this.use();
        return this.bio;
    }

    public boolean isBanned() {
        this.use();
        return this.isBanned;
    }

    public String getName() {
        this.use();
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("User{");
        sb.append("ID=").append(this.ID);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", avatar='").append(this.avatar).append('\'');
        sb.append(", bio='").append(this.bio).append('\'');
        sb.append(", isBanned=").append(this.isBanned);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.ID == user.ID && this.isBanned == user.isBanned && Objects.equals(this.name, user.name) && Objects.equals(this.avatar, user.avatar) && Objects.equals(this.bio, user.bio);
    }

    public int hashCode() {
        return Objects.hash(this.ID);
    }
}

