/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.users;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import net.wildfyre.api.Internal;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.User;

public class LoggedUser
extends User {
    LoggedUser(int id) {
        super(id);
    }

    @Override
    public boolean canEdit() {
        return true;
    }

    public void setBio(String bio) {
        this.set(null, bio, null);
    }

    public void setUsername(String username) {
        this.set(username, null, null);
    }

    public void setAvatar(String avatar) {
        this.set(null, null, avatar);
    }

    public void set(String username, String bio, String avatar) {
        JsonObject json = new JsonObject();
        if (username != null) {
            this.name = username;
            json.add("name", username);
        }
        if (bio != null) {
            this.bio = bio;
            json.add("bio", bio);
        }
        if (avatar != null) {
            this.avatar = avatar;
            json.add("avatar", avatar);
        }
        if (json.isEmpty()) {
            throw new NullPointerException("Every provided parameter was null, at least one should not be!");
        }
        Internal.submit(() -> {
            try {
                new Request(Method.PATCH, "/users/").addToken(Internal.getToken()).addJson((JsonValue)json).get();
            }
            catch (IssueInTransferException | Request.CantConnectException e) {
                throw new RuntimeException();
            }
            this.update();
        });
    }
}

