/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.http;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.stream.Collectors;
import net.wildfyre.http.DataType;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;

public class Request {
    private static final String API_URL = "https://api.wildfyre.net";
    private static final String API_URL_TESTING = "http://localhost:8000";
    static final boolean isTesting = !System.getProperty("org.gradle.test.worker", "default").equals("default");
    public static final String CHARSET = "UTF-8";
    final HttpURLConnection conn;

    static String getURL() {
        return isTesting ? API_URL_TESTING : API_URL;
    }

    public Request(Method method, String address) throws CantConnectException {
        try {
            URL url = new URL(Request.getURL() + address);
            this.conn = Request.connect(url);
            Request.setRequestedMethod(this.conn, method);
            this.conn.setRequestProperty("From", "lib-java");
            this.conn.setRequestProperty("Host", url.getHost());
            this.conn.setRequestProperty("Accept", DataType.JSON.toString());
        }
        catch (MalformedURLException e) {
            throw new CantConnectException("The provided address " + address + " at " + Request.getURL() + " is malformed: " + Request.getURL() + address, e);
        }
    }

    public Request addToken(String token) {
        this.conn.setRequestProperty("Authorization", "token " + token);
        return this;
    }

    public Request addJson(JsonValue params) throws CantConnectException {
        try {
            this.conn.setRequestProperty("Content-Type", DataType.JSON.toString());
            this.conn.setDoOutput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.conn.getOutputStream(), CHARSET));
            params.writeTo((Writer)bw);
            bw.close();
            return this;
        }
        catch (IOException e) {
            throw new CantConnectException("Cannot get output stream to the connection.", e);
        }
    }

    public JsonValue get() throws IssueInTransferException {
        return Request.read(Request.getInputStream(this.conn));
    }

    static HttpURLConnection connect(URL url) throws CantConnectException {
        try {
            return (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new CantConnectException("Cannot connect to the server.", e);
        }
    }

    static byte[] convertToByteArray(JsonValue params) {
        try {
            return params.toString().getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("There was a problem with the character encoding 'UTF-8'. Because it ishard-written in the class, this error should never happen.", e);
        }
    }

    static void setRequestedMethod(HttpURLConnection connection, Method method) {
        try {
            connection.setRequestMethod(method.name());
        }
        catch (ProtocolException e) {
            throw new IllegalArgumentException("Cannot set the method to " + (Object)((Object)method), e);
        }
    }

    static InputStream getInputStream(HttpURLConnection connection) throws IssueInTransferException {
        try {
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new IssueInTransferException("The server refused the request.", connection.getErrorStream());
        }
    }

    static JsonValue read(InputStream input) throws IssueInTransferException {
        try {
            return Json.parse((Reader)new InputStreamReader(input, CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("There was an encoding error. Since the encoding is hardcoded in Request.CHARSET,this error should never occur. Please report to the developers with the full stacktrace.", e);
        }
        catch (IOException e) {
            throw new IssueInTransferException("There was an I/O error while parsing the JSON data, or the server refused the request.", e);
        }
        catch (ParseException e) {
            try {
                String content = new BufferedReader(new InputStreamReader(input, CHARSET)).lines().collect(Collectors.joining("\n"));
                throw new RuntimeException("The content of the InputStream was not a JSON object:\n" + content + "\nSize: " + content.length(), e);
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException("This should never happen: Request.CHARSET is wrong.", e1);
            }
        }
    }

    public static class CantConnectException
    extends IOException {
        CantConnectException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

