/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.descriptors;

public abstract class Descriptor {
    private static long timeBeforeRemoval = 300000L;
    private long lastUsage;
    private boolean isNew;

    public Descriptor() {
        this.use();
        this.isNew = true;
    }

    public static void setTimeBeforeRemoval(long timeBeforeRemoval) {
        if (timeBeforeRemoval <= 0L) {
            throw new IllegalArgumentException("The parameter timeBeforeRemoval cannot be less than 0: " + timeBeforeRemoval);
        }
        Descriptor.timeBeforeRemoval = timeBeforeRemoval;
    }

    public boolean isValid(long currentTime) {
        return currentTime - this.lastUsage < timeBeforeRemoval;
    }

    public final boolean isValid() {
        return this.isValid(System.currentTimeMillis());
    }

    public final boolean isNew() {
        return this.isNew;
    }

    public final void use() {
        this.lastUsage = System.currentTimeMillis();
        this.isNew = false;
    }

    public abstract void update();
}

