/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.api;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.LoggedUser;
import net.wildfyre.users.User;

public class Internal {
    private static String token;
    private static int userId;
    private static Map<Integer, User> users;
    static ThreadPoolExecutor executor;

    public static void clear() {
        users.clear();
    }

    public static void clean() {
        long currentTime = System.currentTimeMillis();
        users.values().removeIf(u -> !u.isValid(currentTime));
    }

    public static void reset() {
        Internal.clear();
        token = null;
        userId = -1;
    }

    public static Optional<User> getCachedUser(int id) {
        return Optional.ofNullable(users.get(id));
    }

    public static LoggedUser getMe() {
        return User.query(Internal.getMyId()).asLogged();
    }

    public static boolean isMyId(int id) {
        if (userId == -1) {
            throw new IllegalStateException("Cannot call this method without specifying an ID. Call Internal#init.");
        }
        return userId == id;
    }

    public static int getMyId() {
        if (userId == -1) {
            throw new IllegalStateException("Cannot call this method without specifying an ID. Call Internal#init.");
        }
        return userId;
    }

    public static String getToken() {
        return token;
    }

    public static void submit(Runnable task) {
        executor.submit(task);
    }

    public static void requestToken(String username, String password) throws Request.CantConnectException {
        try {
            JsonObject json = new Request(Method.POST, "/account/auth/").addJson((JsonValue)new JsonObject().add("username", username).add("password", password)).get().asObject();
            token = json.getString("token", null);
            if (token == null) {
                throw new RuntimeException("Could not find the token in the request body!\n" + json.toString(WriterConfig.PRETTY_PRINT));
            }
            Internal.clear();
        }
        catch (IssueInTransferException e) {
            throw new IllegalArgumentException("Cannot login to the desired user.", e);
        }
    }

    public static void setToken(String token) {
        if (token == null) {
            throw new NullPointerException("The token should not be 'null'.");
        }
        if (token.isEmpty()) {
            throw new IllegalArgumentException("The token should not be empty, size:" + token.length());
        }
        Internal.token = token;
        Internal.clear();
    }

    public static void init() throws Request.CantConnectException {
        try {
            JsonObject json = new Request(Method.GET, "/users/").addToken(token).get().asObject();
            userId = json.getInt("user", -1);
            if (userId == -1) {
                throw new RuntimeException("Couldn't find the ID of the logged-in user!\n" + json.toString(WriterConfig.PRETTY_PRINT));
            }
            Internal.clear();
        }
        catch (IssueInTransferException e) {
            throw new IllegalStateException("Server denied the request.", e);
        }
    }

    static {
        userId = -1;
        users = new HashMap<Integer, User>();
        executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    }
}

