/*
 * Decompiled with CFR 0.152.
 */
package xapi.server.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import xapi.io.X_IO;
import xapi.jre.model.ModelServiceJre;
import xapi.log.X_Log;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.api.ModelModule;
import xapi.model.api.PrimitiveSerializer;
import xapi.server.model.ModelModuleLoader;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.time.X_Time;
import xapi.util.X_Properties;
import xapi.util.api.Pointer;
import xapi.util.api.RemovalHandler;
import xapi.util.api.SuccessHandler;

public class ModelPersistServlet
extends HttpServlet {
    private static final long serialVersionUID = -8873779568305155795L;
    protected ServletContext context;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
        String modules = X_Properties.getProperty((String)"gwt.modules");
        if (modules != null) {
            for (String module : modules.split("\\s+")) {
                if ((module = module.trim()).isEmpty()) continue;
                String moduleName = module;
                ModelModuleLoader.get().preloadModule(this.context, moduleName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        String type = req.getHeader("X-Model-Type");
        String moduleName = req.getHeader("X-Gwt-Module");
        ModelModule module = ModelModuleLoader.get().loadModule(this.context, moduleName);
        RemovalHandler handler = ModelServiceJre.registerModule((ModelModule)module);
        try {
            final ModelManifest manifest = module.getManifest(type);
            String encoding = req.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            String[] keySections = URLDecoder.decode(req.getRequestURI(), encoding).split("/");
            PrimitiveSerializer primitives = X_Model.getService().primitiveSerializer();
            String namespace = keySections[keySections.length - 3];
            namespace = primitives.deserializeString((CharIterator)new StringCharIterator(namespace));
            String kind = keySections[keySections.length - 2];
            StringCharIterator ident = new StringCharIterator(keySections[keySections.length - 1]);
            int keyType = primitives.deserializeInt((CharIterator)ident);
            String id = ident.consumeAll().toString();
            ModelKey key = X_Model.newKey((String)namespace, (String)kind, (String)id).setKeyType(keyType);
            final Pointer wait = new Pointer((Object)true);
            Class modelType = manifest.getModelType();
            X_Model.load((Class)modelType, (ModelKey)key, (SuccessHandler)new SuccessHandler<Model>(){

                public void onSuccess(Model m) {
                    String serialized = X_Model.serialize((ModelManifest)manifest, (Model)m);
                    try {
                        X_IO.drain((OutputStream)resp.getOutputStream(), (InputStream)X_IO.toStreamUtf8((String)serialized));
                        wait.set((Object)false);
                    }
                    catch (Exception e) {
                        X_Log.error((Object[])new Object[]{this.getClass(), "Error saving model", e});
                    }
                }
            });
            long deadline = System.currentTimeMillis() + 5000L;
            while (((Boolean)wait.get()).booleanValue()) {
                X_Time.trySleep((int)30, (int)0);
                if (!X_Time.isPast((double)deadline)) continue;
                X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Timeout while loading model", key});
                return;
            }
        }
        finally {
            handler.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        String asString = X_IO.toStringUtf8((InputStream)req.getInputStream());
        String type = req.getHeader("X-Model-Type");
        String moduleName = req.getHeader("X-Gwt-Module");
        ModelModule module = ModelModuleLoader.get().loadModule(this.context, moduleName);
        RemovalHandler handler = ModelServiceJre.registerModule((ModelModule)module);
        try {
            Model model;
            final ModelManifest manifest = module.getManifest(type);
            try {
                model = X_Model.deserialize((ModelManifest)manifest, (String)asString);
            }
            catch (Throwable e) {
                String manifestText;
                String moduleText;
                try {
                    moduleText = ModelModule.serialize((ModelModule)module);
                }
                catch (Throwable e1) {
                    moduleText = String.valueOf(module);
                }
                try {
                    manifestText = ModelManifest.serialize((ModelManifest)manifest);
                }
                catch (Throwable e1) {
                    manifestText = String.valueOf(manifest);
                }
                X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Error trying to deserialize model; ", e, "source: ", "|" + asString + "|", "\nManifest: ", "|" + manifestText + "|", "\nModule: ", "|" + moduleText + "|"});
                throw new ServletException(e);
            }
            final Pointer wait = new Pointer((Object)true);
            X_Model.persist((Model)model, (SuccessHandler)new SuccessHandler<Model>(){

                public void onSuccess(Model m) {
                    String serialized = X_Model.serialize((ModelManifest)manifest, (Model)m);
                    try {
                        X_IO.drain((OutputStream)resp.getOutputStream(), (InputStream)X_IO.toStreamUtf8((String)serialized));
                        wait.set((Object)false);
                    }
                    catch (Exception e) {
                        X_Log.error((Object[])new Object[]{this.getClass(), "Error saving model", e});
                    }
                }
            });
            long deadline = System.currentTimeMillis() + 5000L;
            while (((Boolean)wait.get()).booleanValue()) {
                X_Time.trySleep((int)30, (int)0);
                if (!X_Time.isPast((double)deadline)) continue;
                X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Timeout while saving model", model});
                return;
            }
        }
        finally {
            handler.remove();
        }
    }
}

