/*
 * Decompiled with CFR 0.152.
 */
package xapi.server.model;

import java.io.InputStream;
import javax.inject.Provider;
import javax.servlet.ServletContext;
import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.io.X_IO;
import xapi.model.X_Model;
import xapi.model.api.ModelModule;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.service.ModelService;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.time.X_Time;
import xapi.util.X_Debug;
import xapi.util.impl.LazyProvider;

public class ModelModuleLoader {
    private static final ModelModuleLoader LOADER = new ModelModuleLoader();
    private final StringTo<ModuleLoader> loaders = X_Collect.newStringMap(ModuleLoader.class);

    public static ModelModuleLoader get() {
        return LOADER;
    }

    private ModelModuleLoader() {
    }

    public void preloadModule(ServletContext context, String moduleName) {
        if (!this.loaders.containsKey((Object)moduleName)) {
            X_Time.runLater((Runnable)this.getOrMakeLoader(context, moduleName));
        }
    }

    public ModelModule loadModule(ServletContext context, String moduleName) {
        return (ModelModule)this.getOrMakeLoader(context, moduleName).get();
    }

    private synchronized ModuleLoader getOrMakeLoader(ServletContext context, String moduleName) {
        if (this.loaders.containsKey((Object)moduleName)) {
            return (ModuleLoader)this.loaders.get(moduleName);
        }
        ModuleLoader loader = new ModuleLoader(context, moduleName);
        this.loaders.put(moduleName, (Object)loader);
        return loader;
    }

    private static class ModuleLoader
    extends LazyProvider<ModelModule>
    implements Runnable {
        public ModuleLoader(final ServletContext context, final String moduleName) {
            super((Provider)new Provider<ModelModule>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ModelModule get() {
                    try (InputStream stream = context.getResourceAsStream("/WEB-INF/deploy/" + moduleName + "/XapiModelLinker/xapi.rpc");){
                        StringCharIterator policy = new StringCharIterator(X_IO.toStringUtf8((InputStream)stream));
                        ModelService modelService = X_Model.getService();
                        ModelModule modelModule = ModelModule.deserialize((CharIterator)policy, (PrimitiveSerializer)modelService.primitiveSerializer());
                        return modelModule;
                    }
                    catch (Throwable e) {
                        throw X_Debug.rethrow((Throwable)e);
                    }
                }
            });
        }

        @Override
        public void run() {
            this.get();
        }
    }
}

