/*
 * Decompiled with CFR 0.152.
 */
package xapi.jre.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import xapi.annotation.inject.SingletonDefault;
import xapi.collect.X_Collect;
import xapi.collect.api.ClassTo;
import xapi.collect.api.Dictionary;
import xapi.dev.source.CharBuffer;
import xapi.except.NotYetImplemented;
import xapi.io.X_IO;
import xapi.log.X_Log;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.api.ModelMethodType;
import xapi.model.api.ModelModule;
import xapi.model.api.ModelNotFoundException;
import xapi.model.impl.AbstractModel;
import xapi.model.impl.AbstractModelService;
import xapi.model.impl.ModelUtil;
import xapi.model.service.ModelService;
import xapi.platform.JrePlatform;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.time.X_Time;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ErrorHandler;
import xapi.util.api.ProvidesValue;
import xapi.util.api.RemovalHandler;
import xapi.util.api.SuccessHandler;
import xapi.util.impl.PairBuilder;

@JrePlatform
@SingletonDefault(implFor=ModelService.class)
public class ModelServiceJre
extends AbstractModelService {
    private static ThreadLocal<ModelModule> currentModule = new ThreadLocal();
    private final ClassTo<ProvidesValue<Object>> modelFactories = X_Collect.newClassMap((Class)((Class)Class.class.cast(ProvidesValue.class)));
    private final ClassTo<ModelManifest> modelManifests = X_Collect.newClassMap(ModelManifest.class);
    private File root;

    public static RemovalHandler registerModule(ModelModule module) {
        currentModule.set(module);
        return new RemovalHandler(){

            public void remove() {
                currentModule.remove();
            }
        };
    }

    public static ProvidesValue<RemovalHandler> captureScope() {
        final ModelModule module = currentModule.get();
        return new ProvidesValue<RemovalHandler>(){

            public RemovalHandler get() {
                final ModelModule was = (ModelModule)currentModule.get();
                currentModule.set(module);
                return new RemovalHandler(){

                    public void remove() {
                        if (module == currentModule.get()) {
                            if (was == null) {
                                currentModule.remove();
                            } else {
                                currentModule.set(was);
                            }
                        }
                    }
                };
            }
        };
    }

    protected <M extends Model> void doPersist(String type, final M model, final SuccessHandler<M> callback) {
        File f;
        ModelKey key = model.getKey();
        if (key == null) {
            key = this.newKey(null, type);
            model.setKey(key);
        }
        try {
            f = this.getFilesystemRoot();
        }
        catch (IOException e) {
            X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Unable to load filesystem root", e});
            if (callback instanceof ErrorHandler) {
                ((ErrorHandler)callback).onError((Throwable)e);
            }
            return;
        }
        if (key.getNamespace().length() > 0) {
            f = new File(f, key.getNamespace());
        }
        f = new File(f, key.getKind());
        f.mkdirs();
        if (key.getId() == null) {
            try {
                f = this.generateFile(f);
            }
            catch (IOException e) {
                X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Unable to save model " + model, e});
                if (callback instanceof ErrorHandler) {
                    ((ErrorHandler)callback).onError((Throwable)e);
                }
                return;
            }
            key.setId(f.getName());
        } else {
            f = new File(f, key.getId());
        }
        final CharBuffer serialized = this.serialize(type, model);
        final File file = f;
        X_Time.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        FileOutputStream result = new FileOutputStream(file);
                        X_IO.drain((OutputStream)result, (InputStream)X_IO.toStreamUtf8((String)serialized.toString()));
                        callback.onSuccess((Object)model);
                        X_Log.info((Object[])new Object[]{this.getClass(), "Saved model to ", file});
                    }
                    catch (IOException e) {
                        X_Log.error((Object[])new Object[]{this.getClass(), "Unable to save model " + model, e});
                        if (!(callback instanceof ErrorHandler)) break block3;
                        ((ErrorHandler)callback).onError((Throwable)e);
                    }
                }
            }
        });
    }

    public <M extends Model> void load(final Class<M> modelClass, final ModelKey modelKey, final SuccessHandler<M> callback) {
        File f;
        try {
            f = this.getFilesystemRoot();
        }
        catch (IOException e) {
            X_Log.error((Object[])new Object[]{((Object)((Object)this)).getClass(), "Unable to load filesystem root", e});
            if (callback instanceof ErrorHandler) {
                ((ErrorHandler)callback).onError((Throwable)e);
            }
            return;
        }
        if (modelKey.getNamespace().length() > 0) {
            f = new File(f, modelKey.getNamespace());
        }
        f = new File(f, modelKey.getKind());
        if (!(f = new File(f, modelKey.getId())).exists()) {
            if (callback instanceof ErrorHandler) {
                ((ErrorHandler)callback).onError((Throwable)new ModelNotFoundException(modelKey));
                return;
            }
        } else {
            final File file = f;
            final ProvidesValue<RemovalHandler> scope = ModelServiceJre.captureScope();
            X_Time.runLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RemovalHandler handler = (RemovalHandler)scope.get();
                    try {
                        String result = X_IO.toStringUtf8((InputStream)new FileInputStream(file));
                        Model model = ModelServiceJre.this.deserialize(modelClass, (CharIterator)new StringCharIterator(result));
                        callback.onSuccess((Object)model);
                    }
                    catch (Exception e) {
                        X_Log.error((Object[])new Object[]{this.getClass(), "Unable to load file for model " + modelKey});
                        if (callback instanceof ErrorHandler) {
                            ((ErrorHandler)callback).onError((Throwable)new ModelNotFoundException(modelKey));
                        }
                    }
                    finally {
                        handler.remove();
                    }
                }
            });
        }
    }

    private synchronized File generateFile(File f) throws IOException {
        int size = f.listFiles().length;
        f = new File(f, Integer.toString(size));
        f.createNewFile();
        return f;
    }

    private File getFilesystemRoot() throws IOException {
        if (this.root == null) {
            File temp = File.createTempFile("ephemeral", "models");
            this.root = new File(temp.getParentFile(), "models");
            temp.delete();
            this.root.mkdirs();
        }
        return this.root;
    }

    public <M extends Model> M create(Class<M> key) {
        ProvidesValue<M> factory = (ProvidesValue<M>)this.modelFactories.get(key);
        if (factory == null) {
            factory = this.createModelFactory(key);
            this.modelFactories.put(key, factory);
        }
        return (M)((Model)factory.get());
    }

    protected <M extends Model> ProvidesValue<M> createModelFactory(final Class<M> modelClass) {
        if (modelClass.isInterface()) {
            return new ProvidesValue<M>(){

                public M get() {
                    return (Model)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{modelClass}, ModelServiceJre.this.newInvocationHandler(modelClass));
                }
            };
        }
        throw new NotYetImplemented("Unable to generate class provider for " + modelClass + "; " + "only interface types are supported at this time");
    }

    protected InvocationHandler newInvocationHandler(Class<? extends Model> modelClass) {
        return new ModelInvocationHandler(modelClass);
    }

    protected ModelManifest getOrMakeModelManifest(Class<? extends Model> cls) {
        ModelModule module = currentModule.get();
        if (module != null) {
            String typeName = this.getTypeName(cls);
            return module.getManifest(typeName);
        }
        ModelManifest manifest = (ModelManifest)this.modelManifests.get(cls);
        if (manifest == null) {
            manifest = ModelUtil.createManifest(cls);
            this.modelManifests.put(cls, (Object)manifest);
        }
        return manifest;
    }

    private final class Itr
    implements Iterable<Map.Entry<String, Object>> {
        private final String[] keys;
        private final Dictionary<String, Object> map;
        private final ConvertsValue<String, Object> defaultValueProvider;

        private Itr(String[] keys, Dictionary<String, Object> map, ConvertsValue<String, Object> defaultValueProvider) {
            this.keys = keys;
            this.map = map;
            this.defaultValueProvider = defaultValueProvider;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < Itr.this.keys.length;
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String key = Itr.this.keys[this.pos];
                    Object value = Itr.this.map.getValue((Object)key);
                    if (value == null) {
                        value = Itr.this.defaultValueProvider.convert((Object)key);
                    }
                    return PairBuilder.entryOf((Object)key, (Object)value);
                }
            };
        }
    }

    public class ModelInvocationHandler
    implements InvocationHandler {
        final ModelManifest manifest;
        final Dictionary<String, Object> values;
        ModelKey key;

        public ModelInvocationHandler(Class<? extends Model> modelClass) {
            this(modelClass, (Dictionary<String, Object>)X_Collect.newDictionary());
        }

        public ModelInvocationHandler(Class<? extends Model> modelClass, Dictionary<String, Object> values) {
            this(this$0.getOrMakeModelManifest(modelClass), values);
        }

        public ModelInvocationHandler(ModelManifest manifest, Dictionary<String, Object> values) {
            this.manifest = manifest;
            this.values = values;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "setProperty": {
                    if (method.getParameterTypes().length == 2) {
                        this.values.setValue((Object)((String)args[0]), args[1]);
                        return proxy;
                    }
                }
                case "setKey": {
                    this.key = (ModelKey)args[0];
                    return proxy;
                }
                case "removeProperty": {
                    if (method.getParameterTypes().length == 1) {
                        this.values.removeValue((Object)((String)args[0]));
                        return this;
                    }
                }
                case "getType": {
                    return this.manifest.getType();
                }
                case "getPropertyType": {
                    String name = (String)args[0];
                    return this.manifest.getMethodData(name).getType();
                }
                case "getPropertyNames": {
                    return this.manifest.getPropertyNames();
                }
                case "getProperties": {
                    String[] properties = this.manifest.getPropertyNames();
                    return new Itr(properties, this.values, (ConvertsValue)new ConvertsValue<String, Object>(){

                        public Object convert(String from) {
                            ModelManifest.MethodData typeData = ModelInvocationHandler.this.manifest.getMethodData(from);
                            if (typeData.getType().isPrimitive()) {
                                return AbstractModel.getPrimitiveValue((Class)typeData.getType());
                            }
                            return null;
                        }
                    });
                }
                case "getKey": {
                    return this.key;
                }
                case "clear": {
                    this.values.clearValues();
                    return proxy;
                }
                case "getProperty": {
                    Object result = null;
                    if (method.getParameterTypes().length == 1) {
                        result = this.values.getValue((Object)((String)args[0]));
                    } else if (method.getParameterTypes().length == 2 && (result = this.values.getValue((Object)((String)args[0]))) == null) {
                        result = args[1];
                    }
                    if (result == null) {
                        ModelManifest.MethodData typeData = this.manifest.getMethodData((String)args[0]);
                        return AbstractModel.getPrimitiveValue((Class)typeData.getType());
                    }
                    return result;
                }
                case "hashCode": {
                    return AbstractModel.hashCodeForModel((Model)((Model)proxy));
                }
                case "equals": {
                    return AbstractModel.equalsForModel((Model)((Model)proxy), (Object)args[0]);
                }
                case "toString": {
                    return AbstractModel.toStringForModel((Model)((Model)proxy));
                }
            }
            if (method.getDeclaringClass() == Model.class) {
                throw new UnsupportedOperationException("Unhandled xapi.model.api.Model method: " + method.toGenericString());
            }
            ModelManifest.MethodData property = this.manifest.getMethodData(method.getName());
            ModelMethodType methodType = property.getMethodType(method.getName());
            if (methodType == null) {
                throw new UnsupportedOperationException("Unhandled model method: " + method.toGenericString());
            }
            switch (methodType) {
                case GET: {
                    Object result = this.values.getValue((Object)property.getName());
                    if (result == null && method.getParameterTypes().length > 1) {
                        return args[1];
                    }
                    return result;
                }
                case SET: {
                    boolean isFluent = ModelUtil.isFluent((Method)method);
                    Object result = null;
                    if (method.getParameters().length == 2) {
                        boolean returnsBoolean;
                        Object previous = this.values.getValue((Object)property.getName());
                        boolean bl = returnsBoolean = method.getReturnType() == Boolean.TYPE;
                        if (Objects.equals(previous, args[0])) {
                            result = this.values.setValue((Object)property.getName(), args[1]);
                            if (returnsBoolean) {
                                return true;
                            }
                        }
                        if (returnsBoolean) {
                            return false;
                        }
                    } else {
                        result = this.values.setValue((Object)property.getName(), args[0]);
                    }
                    if (isFluent) {
                        return proxy;
                    }
                    if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                        return null;
                    }
                    return result;
                }
                case ADD: 
                case ADD_ALL: 
                case CLEAR: {
                    throw new NotYetImplemented("Method " + method.toGenericString() + " of " + method.getDeclaringClass() + " is not yet implemented");
                }
                case REMOVE: {
                    Object result = null;
                    boolean isFluent = ModelUtil.isFluent((Method)method);
                    if (method.getParameters().length == 2) {
                        boolean returnsBoolean;
                        Object previous = this.values.getValue((Object)property.getName());
                        boolean bl = returnsBoolean = method.getReturnType() == Boolean.TYPE;
                        if (Objects.equals(previous, args[0])) {
                            result = this.values.removeValue((Object)property.getName());
                            if (returnsBoolean) {
                                return true;
                            }
                        }
                        if (returnsBoolean) {
                            return false;
                        }
                    } else {
                        result = this.values.removeValue((Object)property.getName());
                    }
                    if (isFluent) {
                        return proxy;
                    }
                    if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                        return null;
                    }
                    return result;
                }
            }
            return null;
        }
    }
}

