/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.test;

import org.junit.Assert;
import org.junit.Test;
import xapi.jre.model.ModelServiceJre;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.api.ModelModule;
import xapi.model.content.ModelContent;
import xapi.model.content.ModelRating;
import xapi.model.content.ModelText;
import xapi.model.impl.ModelUtil;
import xapi.time.X_Time;
import xapi.util.api.Pointer;
import xapi.util.api.RemovalHandler;
import xapi.util.api.SuccessHandler;

public class ModelServiceTestJre {
    @Test
    public void testKeySerialization_Empty() {
        ModelKey key = X_Model.newKey((String)"testkind");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
    }

    @Test
    public void testKeySerialization_Simple() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getKind());
        Assert.assertEquals(null, (Object)key.getId());
    }

    @Test
    public void testKeySerialization_Full() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind", (String)"id");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getKind());
        Assert.assertEquals((Object)"id", (Object)key.getId());
    }

    @Test
    public void testKeySerialization_WithParent() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind", (String)"id");
        key = key.getChild("child", "123");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"child", (Object)key.getKind());
        Assert.assertEquals((Object)"123", (Object)key.getId());
        Assert.assertEquals((Object)"ns", (Object)key.getParent().getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getParent().getKind());
        Assert.assertEquals((Object)"id", (Object)key.getParent().getId());
    }

    @Test
    public void testSimpleSerialization() {
        ModelText text = (ModelText)X_Model.create(ModelText.class);
        long time = System.currentTimeMillis();
        text.setText("Hello World");
        text.setTime((double)time);
        String serialized = X_Model.serialize(ModelText.class, (Model)text);
        ModelText asModel = (ModelText)X_Model.deserialize(ModelText.class, (String)serialized);
        Assert.assertEquals((Object)text, (Object)asModel);
    }

    @Test
    public void testSimpleSerialization_WithKey() {
        ModelText text = (ModelText)X_Model.create(ModelText.class);
        text.setKey(X_Model.newKey((String)"ns", (String)"text", (String)"id"));
        long time = System.currentTimeMillis();
        text.setText("Hello World");
        text.setTime((double)time);
        String serialized = X_Model.serialize(ModelText.class, (Model)text);
        ModelText asModel = (ModelText)X_Model.deserialize(ModelText.class, (String)serialized);
        Assert.assertEquals((Object)text, (Object)asModel);
        Assert.assertNotNull((String)"Deserialized model must have a key!", (Object)asModel.getKey());
        text.setText("different");
        Assert.assertEquals((Object)text, (Object)asModel);
    }

    @Test
    public void testComplexSerialization() {
        ModelContent content = (ModelContent)X_Model.create(ModelContent.class);
        long time = System.currentTimeMillis();
        content.setText("Hello World");
        content.setTime((double)time);
        content.setRelated(new ModelContent[]{(ModelContent)X_Model.create(ModelContent.class)});
        String serialized = X_Model.serialize(ModelContent.class, (Model)content);
        ModelContent asModel = (ModelContent)X_Model.deserialize(ModelContent.class, (String)serialized);
        Assert.assertEquals((Object)content, (Object)asModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveExample() {
        ModelModule module = ModelModule.deserialize((String)"G3gmqkyvrvshfl7tdTeTDFD444A63B7C8030BDB6EDBB406508FEMWeTheInternetZHcontent\\xapi.model.content.ModelContentHrelatedItextItimeHupvotesDdownvotesaT[Lxapi.model.content.ModelContent;Gjava.lang.StringSdoubletT[Lxapi.model.content.ModelRating;[xapi.model.content.ModelTextSrating>xapi.model.content.ModelRatingSauthorZxapi.model.user.ModelUserIuserAidNemailDfirstNameRlastNameNvaliddTxapi.util.validators.ChecksStringNotEmptyHbooleanHisValidIETNAOINSAHNOTEE EAE T ORNOTEE EAE T IDNOTEE EAT E NLNOTEE EAT E SLNOTEE EAE T OCAOIORNOTEE EAE T IDNOTEE EAT E UMAUWUDNOTEE EAT E WFNOTEE EAT E GFNYPBVKYRNOTEE TJAEYT PRNOTEE TJAT E BRNOTEE TJAT E VRNOTEE TJAT E KXNOTEE ETEQ");
        RemovalHandler handler = ModelServiceJre.registerModule((ModelModule)module);
        try {
            ModelManifest manifest = module.getManifest("content");
            Model model = X_Model.deserialize((ModelManifest)manifest, (String)"U EHcontentTETnT EHcontentEZqes6dvg09t023fa2h5fwxko6r UTest Me Out!E   E  ");
        }
        finally {
            handler.remove();
        }
    }

    @Test
    public void testModelPersistence() {
        ModelContent content = (ModelContent)X_Model.create(ModelContent.class);
        long time = System.currentTimeMillis();
        content.setText("Hello World");
        content.setTime((double)time);
        content.setRelated(new ModelContent[]{(ModelContent)X_Model.create(ModelContent.class)});
        content.setKey(X_Model.newKey((String)content.getType()));
        final Pointer waiting = new Pointer((Object)true);
        X_Model.persist((Model)content, (SuccessHandler)new SuccessHandler<ModelContent>(){

            public void onSuccess(final ModelContent m) {
                X_Model.load(ModelContent.class, (ModelKey)m.getKey(), (SuccessHandler)new SuccessHandler<ModelContent>(){

                    public void onSuccess(ModelContent loaded) {
                        Assert.assertFalse((loaded == m ? 1 : 0) != 0);
                        Assert.assertTrue((boolean)loaded.equals(m));
                        waiting.set((Object)false);
                    }
                });
            }
        });
        long deadline = System.currentTimeMillis() + 3000L;
        while (((Boolean)waiting.get()).booleanValue()) {
            X_Time.trySleep((int)10, (int)0);
            Assert.assertTrue((boolean)X_Time.isFuture((double)deadline));
        }
    }

    @Test
    public void testModuleSerializationRoundTrip() {
        ModelModule module = new ModelModule();
        module.addManifest(ModelUtil.createManifest(ModelContent.class));
        module.addManifest(ModelUtil.createManifest(ModelText.class));
        module.addManifest(ModelUtil.createManifest(ModelRating.class));
        String serialized = ModelModule.serialize((ModelModule)module);
        System.out.println(serialized);
        ModelModule deserialized = ModelModule.deserialize((String)serialized);
        Assert.assertEquals((Object)module, (Object)deserialized);
    }
}

