/*
 * Decompiled with CFR 0.152.
 */
package xapi.jre.inject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.InstanceOverride;
import xapi.annotation.inject.SingletonDefault;
import xapi.annotation.inject.SingletonOverride;
import xapi.bytecode.ClassFile;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.ArrayMemberValue;
import xapi.bytecode.annotation.ClassMemberValue;
import xapi.bytecode.annotation.IntegerMemberValue;
import xapi.bytecode.annotation.MemberValue;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.scanner.api.ClasspathScanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.dev.scanner.impl.ClasspathScannerDefault;
import xapi.except.NotConfiguredCorrectly;
import xapi.inject.X_Inject;
import xapi.inject.impl.JavaInjector;
import xapi.log.X_Log;
import xapi.platform.Platform;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.time.impl.ImmutableMoment;
import xapi.util.X_Properties;
import xapi.util.X_Runtime;
import xapi.util.api.ReceivesValue;

public class RuntimeInjector
implements ReceivesValue<String> {
    private final double init = System.nanoTime();

    public void set(String targetDir) {
        String prefix = "META-INF" + File.separator;
        this.writeMetaInfo(targetDir, prefix + "singletons", prefix + "instances");
    }

    public void writeMetaInfo(String targetDir, String singletonDir, String instanceDir) {
        ClassMemberValue value;
        Annotation impl;
        ClassMemberValue value2;
        ClasspathScanner scanner;
        File target;
        if (!targetDir.endsWith(File.separator)) {
            targetDir = targetDir + File.separator;
        }
        if (!(target = new File(targetDir).getAbsoluteFile()).isDirectory() && !target.mkdirs()) {
            throw new RuntimeException("Unable to get or make jre injection generator output directory: " + target.getAbsolutePath());
        }
        try {
            scanner = (ClasspathScanner)X_Inject.instance(ClasspathScanner.class);
        }
        catch (Exception e) {
            scanner = new ClasspathScannerDefault();
        }
        Moment start = this.now();
        ClasspathResourceMap resources = scanner.scanAnnotations(new Class[]{Platform.class, SingletonDefault.class, SingletonOverride.class, InstanceDefault.class, InstanceOverride.class}).matchResource("META[-]INF/(instances|singletons)").matchClassFile(".*").scan(Thread.currentThread().getContextClassLoader());
        String[] runtime = ((String)X_Properties.platform.get()).split(",");
        SimpleFifo defaultSingletons = new SimpleFifo();
        SimpleFifo defaultInstances = new SimpleFifo();
        SimpleFifo singletonImpls = new SimpleFifo();
        SimpleFifo instanceImpls = new SimpleFifo();
        ClassFile bestMatch = null;
        HashMap<String, ClassFile> platformMap = new HashMap<String, ClassFile>();
        String shortName = null;
        LinkedHashSet<String> scopes = new LinkedHashSet<String>();
        ArrayList<ClassFile> platforms = new ArrayList<ClassFile>();
        Moment prepped = this.now();
        for (ClassFile file : resources.findClassAnnotatedWith(new Class[]{Platform.class})) {
            platforms.add(file);
            for (String platform : runtime) {
                scopes.add(platform);
                shortName = platform.substring(platform.lastIndexOf(46) + 1);
                platformMap.put(file.getName(), file);
                if (file.getName().equals(runtime)) {
                    bestMatch = file;
                }
                if (bestMatch != null || !file.getName().endsWith(shortName)) continue;
                bestMatch = file;
            }
        }
        Moment scanned = this.now();
        if (bestMatch == null) {
            throw this.platformMisconfigured(shortName);
        }
        LinkedHashSet<ClassFile> remainder = new LinkedHashSet<ClassFile>();
        remainder.add(bestMatch);
        while (remainder.size() > 0) {
            ClassFile next = (ClassFile)remainder.iterator().next();
            Annotation anno = next.getAnnotation("xapi.platform.Platform");
            if (anno == null) {
                throw this.platformMisconfigured(next.getName());
            }
            MemberValue fallbacks = anno.getMemberValue("fallback");
            if (fallbacks != null) {
                ArrayMemberValue arr = (ArrayMemberValue)fallbacks;
                for (MemberValue v : arr.getValue()) {
                    String name = ((ClassMemberValue)v).getValue();
                    ClassFile fallback = (ClassFile)platformMap.get(name);
                    if (fallback == null || !scopes.add(fallback.getName())) continue;
                    remainder.add(fallback);
                }
            }
            remainder.remove(next);
        }
        Moment checked = this.now();
        for (ClassFile cls : resources.findClassAnnotatedWith(new Class[]{SingletonDefault.class, SingletonOverride.class, InstanceDefault.class, InstanceOverride.class})) {
            Annotation anno = cls.getAnnotation(SingletonDefault.class.getName());
            if (anno != null && this.allowedPlatform(cls, scopes, platforms)) {
                defaultSingletons.give((Object)cls);
            }
            if ((anno = cls.getAnnotation(SingletonOverride.class.getName())) != null && this.allowedPlatform(cls, scopes, platforms)) {
                singletonImpls.give((Object)cls);
            }
            if ((anno = cls.getAnnotation(InstanceDefault.class.getName())) != null && this.allowedPlatform(cls, scopes, platforms)) {
                defaultInstances.give((Object)cls);
            }
            if ((anno = cls.getAnnotation(InstanceOverride.class.getName())) == null || !this.allowedPlatform(cls, scopes, platforms)) continue;
            instanceImpls.give((Object)cls);
        }
        Moment mapped = this.now();
        HashMap<String, ClassFile> injectionTargets = new HashMap<String, ClassFile>();
        for (ClassFile cls : defaultSingletons.forEach()) {
            Annotation impl2 = cls.getAnnotation(SingletonDefault.class.getName());
            value2 = (ClassMemberValue)impl2.getMemberValue("implFor");
            injectionTargets.put(value2.getValue(), cls);
        }
        for (ClassFile cls : singletonImpls.forEach()) {
            Annotation impl3 = cls.getAnnotation(SingletonOverride.class.getName());
            value2 = (ClassMemberValue)impl3.getMemberValue("implFor");
            String clsName = value2.getValue();
            ClassFile existing = (ClassFile)injectionTargets.get(value2.getValue());
            if (existing == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            ClassFile previous = (ClassFile)injectionTargets.get(clsName);
            if (previous == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            Annotation oldOverride = previous.getAnnotation(SingletonOverride.class.getName());
            if (oldOverride == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            IntegerMemberValue oldPriority = (IntegerMemberValue)oldOverride.getMemberValue("priority");
            IntegerMemberValue newPriority = (IntegerMemberValue)impl3.getMemberValue("priority");
            if (newPriority == null || oldPriority != null && newPriority.getValue() <= oldPriority.getValue()) continue;
            injectionTargets.put(clsName, cls);
        }
        Moment startInject = this.now();
        for (String iface : injectionTargets.keySet()) {
            JavaInjector.registerSingletonProvider((String)iface, (String)((ClassFile)injectionTargets.get(iface)).getName());
        }
        try {
            this.writeMeta(injectionTargets, new File(target, singletonDir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        injectionTargets.clear();
        for (ClassFile cls : defaultInstances.forEach()) {
            impl = cls.getAnnotation(InstanceDefault.class.getName());
            value = (ClassMemberValue)impl.getMemberValue("implFor");
            injectionTargets.put(value.getValue(), cls);
        }
        for (ClassFile cls : instanceImpls.forEach()) {
            impl = cls.getAnnotation(InstanceOverride.class.getName());
            value = (ClassMemberValue)impl.getMemberValue("implFor");
            String clsName = value.getValue();
            ClassFile existing = (ClassFile)injectionTargets.get(value.getValue());
            if (existing == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            ClassFile previous = (ClassFile)injectionTargets.get(clsName);
            if (previous == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            Annotation oldOverride = previous.getAnnotation(InstanceOverride.class.getName());
            if (oldOverride == null) {
                injectionTargets.put(clsName, cls);
                continue;
            }
            IntegerMemberValue oldPriority = (IntegerMemberValue)oldOverride.getMemberValue("priority");
            IntegerMemberValue newPriority = (IntegerMemberValue)impl.getMemberValue("priority");
            if (newPriority.getValue() <= oldPriority.getValue()) continue;
            injectionTargets.put(clsName, cls);
        }
        for (String iface : injectionTargets.keySet()) {
            JavaInjector.registerInstanceProvider((String)iface, (String)((ClassFile)injectionTargets.get(iface)).getName());
        }
        try {
            this.writeMeta(injectionTargets, new File(target, instanceDir));
        }
        catch (Throwable e) {
            X_Log.warn((Object[])new Object[]{"Trouble encountered writing instance meta to ", new File(target, instanceDir), e});
        }
        Moment finished = this.now();
        if (X_Runtime.isDebug()) {
            X_Log.info((Object[])new Object[]{"Multithreaded? ", X_Runtime.isMultithreaded()});
            X_Log.info((Object[])new Object[]{"Prepped: ", X_Time.difference((Moment)start, (Moment)prepped)});
            X_Log.info((Object[])new Object[]{"Scanned: ", X_Time.difference((Moment)prepped, (Moment)scanned)});
            X_Log.info((Object[])new Object[]{"Checked: ", X_Time.difference((Moment)scanned, (Moment)checked)});
            X_Log.info((Object[])new Object[]{"Mapped: ", X_Time.difference((Moment)checked, (Moment)mapped)});
            X_Log.info((Object[])new Object[]{"Analyzed: ", X_Time.difference((Moment)mapped, (Moment)startInject)});
            X_Log.info((Object[])new Object[]{"Injected: ", X_Time.difference((Moment)startInject, (Moment)finished)});
            X_Log.info((Object[])new Object[]{"Total: ", X_Time.difference((Moment)start, (Moment)finished)});
        }
    }

    private Moment now() {
        return new ImmutableMoment((double)System.currentTimeMillis() + Math.abs((double)System.nanoTime() - this.init) / 1.0E8);
    }

    private boolean allowedPlatform(ClassFile cls, Set<String> scopes, Iterable<ClassFile> platforms) {
        for (String allowed : scopes) {
            if (cls.getAnnotation(allowed) == null) continue;
            return true;
        }
        for (ClassFile platform : platforms) {
            if (cls.getAnnotation(platform.getName()) == null) continue;
            System.out.println("Skipping " + cls.getName() + " for having a platform " + "the does not match the current runtime.");
            return false;
        }
        return true;
    }

    private NotConfiguredCorrectly platformMisconfigured(String platform) {
        return new NotConfiguredCorrectly("Could not find platform annotation for current runtime " + platform + "; please ensure this class is on the " + "classpath, and that it is annotated with @Platform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMeta(Map<String, ClassFile> injectables, File target) {
        X_Log.info((Object[])new Object[]{"Writing meta to ", target.getAbsoluteFile()});
        if (!target.exists() && !target.mkdirs()) {
            throw new RuntimeException("Unable to create meta info directory for " + target.getAbsolutePath());
        }
        block11: for (String iface : injectables.keySet()) {
            File metaInf = new File(target, iface);
            String impl = injectables.get(iface).getName();
            X_Log.debug((Object[])new Object[]{"Injecting ", iface, " -> ", impl});
            try {
                if (metaInf.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(metaInf));
                    ArrayList lines = new ArrayList();
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.equals(impl)) continue;
                            continue block11;
                        }
                    }
                    finally {
                        reader.close();
                        continue;
                    }
                    BufferedWriter writer = new BufferedWriter(new FileWriter(metaInf));
                    try {
                        writer.append(impl);
                        writer.append("\n");
                        for (String line : lines) {
                            writer.append(line);
                            writer.append("\n");
                        }
                        writer.flush();
                        continue;
                    }
                    finally {
                        writer.close();
                        continue;
                    }
                }
                if (!metaInf.createNewFile()) {
                    throw new RuntimeException("Unable to create meta info for " + metaInf.getAbsolutePath() + ".  " + "Please ensure java has write permissions for " + metaInf.getParent());
                }
                try (FileWriter writer = new FileWriter(metaInf);){
                    writer.append(impl);
                    writer.flush();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create meta info for " + metaInf.getAbsolutePath(), e);
            }
        }
    }
}

