/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.inject;

import org.junit.Assert;
import org.junit.Test;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.SingletonDefault;
import xapi.inject.X_Inject;
import xapi.test.AbstractInjectionTest;

@SingletonDefault(implFor=JreInjectionTest.class)
public class JreInjectionTest
extends AbstractInjectionTest {
    @Test
    public void testSingletonInjection() {
        ImportSingleton service = (ImportSingleton)X_Inject.singleton(ImportSingleton.class);
        Assert.assertNotNull((String)"Injector did not provide a singleton service", (Object)service);
        service.test();
    }

    @Test
    public void testInstanceInjection() {
        ImportInstance instance = (ImportInstance)X_Inject.instance(ImportInstance.class);
        Assert.assertNotNull((String)"Injector did not provide an instance object", (Object)instance);
        instance.test();
    }

    @InstanceDefault(implFor=ImportTestInstance.class)
    public static class ImportInstance
    implements ImportTestInstance {
        @Override
        public void test() {
        }
    }

    @SingletonDefault(implFor=ImportSingleton.class)
    public static class ImportSingleton
    implements ImportTestSingleton {
        @Override
        public void test() {
        }
    }

    private static interface ImportTestInstance {
        public void test();
    }

    private static interface ImportTestSingleton {
        public void test();
    }
}

