/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.bytecode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.InstanceOverride;
import xapi.annotation.inject.SingletonDefault;
import xapi.annotation.inject.SingletonOverride;
import xapi.bytecode.ClassFile;
import xapi.bytecode.ClassPool;
import xapi.bytecode.annotation.Annotation;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.dev.scanner.impl.ClasspathScannerDefault;
import xapi.platform.JrePlatform;
import xapi.platform.Platform;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_String;

@JrePlatform
@SingletonDefault(implFor=ByteCodeReaderTest.class)
@SingletonOverride(implFor=ByteCodeReaderTest.class)
public class ByteCodeReaderTest {
    @Test
    public void testReadClass() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/" + this.getClass().getName().replace('.', '/') + ".class");
        ClassFile file = new ClassFile((DataInput)new DataInputStream(in));
        Annotation singleton = file.getRuntimeAnnotation(SingletonOverride.class.getName());
        Assert.assertNotNull((String)"Did not load SingletonOverride", (Object)singleton);
    }

    @Test
    public void testClasspathScanner() throws Exception {
        System.gc();
        long mem = Runtime.getRuntime().freeMemory();
        X_Time.tick();
        Moment start = X_Time.now();
        ClasspathResourceMap resources = new ClasspathScannerDefault().scanAnnotations(new Class[]{Platform.class, SingletonDefault.class, SingletonOverride.class, InstanceDefault.class, InstanceOverride.class}).matchResource(".*").matchClassFile(".*").scan(Thread.currentThread().getContextClassLoader());
        ClassPool cp = new ClassPool();
        for (ClassFile cls : resources.findClassAnnotatedWith(new Class[]{SingletonDefault.class, SingletonOverride.class, InstanceDefault.class, InstanceOverride.class})) {
            Annotation anno = cls.getAnnotation(SingletonDefault.class.getName());
            if (anno == null) continue;
            SingletonDefault a = (SingletonDefault)anno.toAnnotationType(Thread.currentThread().getContextClassLoader(), cp);
            System.out.println(a);
        }
        X_Time.tick();
        System.gc();
        long memDone = Runtime.getRuntime().freeMemory();
        System.out.println("Scanned annotations in " + X_Time.difference((Moment)start));
        System.out.println("Used memory: " + X_String.toBinarySuffix((double)(mem - memDone)));
    }

    @InstanceDefault(implFor=InnerInterface.class)
    static class InnerClass
    implements InnerInterface {
        InnerClass() {
        }
    }

    private static interface InnerInterface {
    }
}

