/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.test;

import org.junit.Assert;
import org.junit.Test;
import xapi.bytecode.ClassFile;
import xapi.dev.scanner.X_Scanner;
import xapi.log.X_Log;
import xapi.time.X_Time;
import xapi.time.api.Moment;

public class ScannerTest {
    @Test
    public void testFindTestClasses() {
        Moment start = X_Time.now();
        for (ClassFile cls : X_Scanner.findMethodsWithAnnotations((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{Test.class})) {
            if (!cls.getName().equals(ScannerTest.class.getName())) continue;
            X_Log.trace((Object[])new Object[]{"Found self class in " + X_Time.difference((Moment)start)});
            return;
        }
        Assert.fail((String)("Could not find " + ScannerTest.class.getName() + " using X_Scanner.findMethodWithAnnotations()"));
    }

    @Test
    public void testFindDirectSubclasses() {
        Moment start = X_Time.now();
        for (ClassFile cls : X_Scanner.findDirectSubclasses((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{ScannerTest.class})) {
            if (!cls.hasSuperClass(this.getClass().getName())) continue;
            X_Log.info((Object[])new Object[]{"Found private subclass in " + X_Time.difference((Moment)start), cls});
            return;
        }
        Assert.fail((String)("Could not find " + PrivateSubclass.class.getName() + " using X_Scanner.findDirectSubclasses()"));
    }

    @Test
    public void testFindImplementationsOf() {
        Moment start = X_Time.now();
        for (ClassFile cls : X_Scanner.findImplementationsOf((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{ScannerTest.class})) {
            if (!cls.hasSuperClass(PrivateSubclass.class.getName())) continue;
            X_Log.info((Object[])new Object[]{"Found class ancestor in " + X_Time.difference((Moment)start), cls});
            return;
        }
        Assert.fail((String)("Could not find " + SecondSubclass.class.getName() + " using X_Scanner.findImplementationsOf()"));
    }

    @Test
    public void testFindInPackage() {
        Moment start = X_Time.now();
        for (ClassFile cls : X_Scanner.findClassesInPackage((ClassLoader)this.getClass().getClassLoader(), (String)ScannerTest.class.getPackage().getName())) {
            X_Log.info((Object[])new Object[]{this.getClass(), cls});
            if (!cls.getName().equals(ScannerTest.class.getName())) continue;
            X_Log.trace((Object[])new Object[]{"Found self class in " + X_Time.difference((Moment)start)});
            return;
        }
        Assert.fail((String)("Could not find " + ScannerTest.class + " using X_Scanner.findClassesInPackages()"));
    }

    private static class SecondSubclass
    extends PrivateSubclass {
        private SecondSubclass() {
        }
    }

    private static class PrivateSubclass
    extends ScannerTest {
        private PrivateSubclass() {
        }
    }
}

