/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.read;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import xapi.collect.impl.SimpleStack;
import xapi.dev.source.TypeDefinitionException;
import xapi.source.read.JavaModel;
import xapi.source.read.JavaVisitor;

public class JavaLexer {
    private static final JavaVisitor.ModifierVisitor NO_OP_MOD_VISITOR = new JavaVisitor.ModifierVisitor(){

        public void visitModifier(int modifier, Object receiver) {
        }
    };
    private static final JavaVisitor.GenericVisitor NO_OP_GENERIC_VISITOR = new JavaVisitor.GenericVisitor(){

        public void visitGeneric(String generic, Object receiver) {
        }
    };
    private static final JavaVisitor.ClassVisitor NP_OP_CLASS_VISITOR = new JavaVisitor.ClassVisitor(){

        @Override
        public JavaVisitor.AnnotationMemberVisitor visitAnnotation(String annoName, String annoBody, Object receiver) {
            return null;
        }

        @Override
        public void visitGeneric(String generic, Object receiver) {
        }

        @Override
        public void visitJavadoc(String javadoc, Object receiver) {
        }

        @Override
        public void visitModifier(int modifier, Object receiver) {
        }

        @Override
        public void visitImport(String name, boolean isStatic, Object receiver) {
        }

        public void visitCopyright(String copyright, Object receiver) {
        }

        public void visitPackage(String pkg, Object receiver) {
        }

        public void visitName(String name, Object receiver) {
        }

        public void visitType(String type, Object receiver) {
        }

        public void visitSuperclass(String superClass, Object receiver) {
        }

        public void visitInterface(String iface, Object receiver) {
        }

        public JavaVisitor.ClassBodyVisitor visitBody(String body, Object receiver) {
            return null;
        }
    };
    protected static final JavaVisitor.AnnotationMemberVisitor NO_OP_ANNOTATION_MEMBER_VISITOR = new JavaVisitor.AnnotationMemberVisitor(){

        public void visitMember(String name, String value, Object receiver) {
        }
    };
    private static final JavaVisitor.AnnotationVisitor NO_OP_ANNOTATION_VISITOR = new JavaVisitor.AnnotationVisitor(){

        public JavaVisitor.AnnotationMemberVisitor visitAnnotation(String annoName, String annoBody, Object receiver) {
            return NO_OP_ANNOTATION_MEMBER_VISITOR;
        }
    };
    private final int modifier;
    private final boolean isClass;
    private final boolean isAnnotation;
    private final boolean isEnum;
    private final boolean isGenerics;
    private final Set<String> interfaces;
    private final Set<String> generics;
    private final Set<String> imports;
    private final String superClass;
    private final String className;

    public static <R> int visitJavadoc(JavaVisitor.JavadocVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        if ((pos = JavaLexer.eatWhitespace(chars, pos)) == chars.length()) {
            return pos;
        }
        try {
            if ('/' == chars.charAt(pos) && chars.charAt(++pos) == '*') {
                int start = pos + (chars.charAt(pos) == '*' ? 1 : 0);
                while (chars.charAt(++pos) != '*' || chars.charAt(++pos) != '/') {
                }
                chars.subSequence(start, pos - 2);
                visitor.visitJavadoc(chars.toString().replaceAll("\n\\s*[*]", ""), receiver);
            }
        }
        catch (IndexOutOfBoundsException e) {
            JavaLexer.error(e, "Error parsing javadoc on: " + chars.toString());
        }
        return pos;
    }

    public static <R> int visitAnnotation(JavaVisitor.AnnotationVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        if ((pos = JavaLexer.eatWhitespace(chars, pos)) == chars.length()) {
            return pos;
        }
        int start = pos;
        try {
            while (chars.charAt(pos) == '@') {
                JavaVisitor.AnnotationMemberVisitor<R> bodyVisitor;
                pos = JavaLexer.eatJavaname(chars, pos + 1);
                String annoName = chars.subSequence(start + 1, pos).toString();
                String annoBody = "";
                if ((pos = JavaLexer.eatWhitespace(chars, pos)) < chars.length() && chars.charAt(pos) == '(') {
                    int bodyStart = pos + 1;
                    pos = JavaLexer.eatAnnotationBody(visitor, receiver, chars, pos);
                    annoBody = chars.subSequence(bodyStart, pos).toString();
                    ++pos;
                }
                if ((bodyVisitor = visitor.visitAnnotation(annoName, annoBody, receiver)) != null && annoBody.length() > 0) {
                    JavaLexer.visitAnnotationMembers(bodyVisitor, receiver, annoBody, 0);
                }
                start = pos = JavaLexer.eatWhitespace(chars, pos);
                if (pos != chars.length()) continue;
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            JavaLexer.error(e, "Error parsing annotation on: " + chars.subSequence(start, chars.length()));
        }
        return pos;
    }

    public static <R> int visitAnnotationMembers(JavaVisitor.AnnotationMemberVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        String name = "value";
        boolean nameNext = true;
        block16: while (pos != chars.length()) {
            int start;
            pos = JavaLexer.eatWhitespace(chars, pos);
            switch (chars.charAt(pos)) {
                case ',': {
                    nameNext = true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block16;
                }
                case ')': {
                    return pos;
                }
                case '\"': 
                case '@': 
                case '{': {
                    name = "value";
                    nameNext = false;
                }
            }
            if (nameNext) {
                nameNext = false;
                start = pos;
                while (Character.isJavaIdentifierPart(chars.charAt(pos))) {
                    ++pos;
                }
                String maybeName = chars.subSequence(start, pos).toString().trim();
                name = maybeName.length() == 0 ? "value" : maybeName;
                pos = JavaLexer.eatWhitespace(chars, pos);
                switch (chars.charAt(pos)) {
                    case '=': {
                        nameNext = false;
                        continue block16;
                    }
                    case ',': {
                        visitor.visitMember("value", maybeName, receiver);
                        nameNext = true;
                        continue block16;
                    }
                    case ')': {
                        visitor.visitMember("value", maybeName, receiver);
                        nameNext = true;
                        return pos;
                    }
                }
                if (pos == chars.length()) {
                    visitor.visitMember("value", maybeName, receiver);
                    return pos;
                }
                --pos;
                continue;
            }
            start = pos;
            switch (chars.charAt(pos)) {
                case '{': {
                    pos = JavaLexer.eatArrayInitializer(chars, pos);
                    break;
                }
                case '\"': {
                    pos = JavaLexer.eatStringValue(chars, pos);
                    if (chars.charAt(pos) != '\"') break;
                    ++pos;
                    break;
                }
                case '@': {
                    AnnotationExtractor extractor = new AnnotationExtractor();
                    pos = JavaLexer.visitAnnotation(extractor, null, chars, pos);
                    break;
                }
                default: {
                    char c = chars.charAt(pos);
                    while (!Character.isWhitespace(c)) {
                        c = chars.charAt(++pos);
                    }
                    break block11;
                }
            }
            visitor.visitMember(name, chars.subSequence(start, pos).toString(), receiver);
        }
        return pos;
    }

    public static <R> int visitModifier(JavaVisitor.ModifierVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        pos = JavaLexer.eatWhitespace(chars, pos);
        block10: while (true) {
            char c = chars.charAt(pos);
            switch (c) {
                case 'p': {
                    if (chars.subSequence(pos, pos + 7).equals("public ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 7);
                        visitor.visitModifier(1, receiver);
                        continue block10;
                    }
                    if (chars.subSequence(pos, pos + 8).equals("private ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 8);
                        visitor.visitModifier(2, receiver);
                        continue block10;
                    }
                    if (chars.subSequence(pos, pos + 10).equals("protected ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 10);
                        visitor.visitModifier(4, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 'f': {
                    if (chars.subSequence(pos, pos + 6).equals("final ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 6);
                        visitor.visitModifier(16, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 'a': {
                    if (chars.subSequence(pos, pos + 9).equals("abstract ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 9);
                        visitor.visitModifier(1024, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 'd': {
                    if (chars.subSequence(pos, pos + 8).equals("default ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 8);
                        visitor.visitModifier(65536, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 's': {
                    if (chars.subSequence(pos, pos + 7).equals("static ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 7);
                        visitor.visitModifier(8, receiver);
                        continue block10;
                    }
                    if (chars.subSequence(pos, pos + 13).equals("synchronized ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 13);
                        visitor.visitModifier(32, receiver);
                        continue block10;
                    }
                    if (chars.subSequence(pos, pos + 9).equals("strictfp ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 9);
                        visitor.visitModifier(2048, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 'n': {
                    if (chars.subSequence(pos, pos + 7).equals("native ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 7);
                        visitor.visitModifier(256, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 't': {
                    if (chars.subSequence(pos, pos + 10).equals("transient ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 10);
                        visitor.visitModifier(128, receiver);
                        continue block10;
                    }
                    return pos;
                }
                case 'v': {
                    if (chars.subSequence(pos, pos + 9).equals("volatile ")) {
                        pos = JavaLexer.eatWhitespace(chars, pos + 9);
                        visitor.visitModifier(64, receiver);
                        continue block10;
                    }
                    return pos;
                }
            }
            break;
        }
        return pos;
    }

    public static <R> int visitGeneric(JavaVisitor.GenericVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        if (chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos)) == '<') {
            int start = pos;
            pos = JavaLexer.eatGeneric(chars, pos) + 1;
            visitor.visitGeneric(chars.subSequence(start, pos).toString(), receiver);
        }
        return JavaLexer.eatWhitespace(chars, pos);
    }

    public static <R> int visitMethodSignature(JavaVisitor.MethodVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        if ((pos = JavaLexer.eatWhitespace(chars, pos)) == chars.length()) {
            return pos;
        }
        pos = JavaLexer.visitAnnotation(visitor, receiver, chars, pos);
        pos = JavaLexer.visitModifier(visitor, receiver, chars, pos);
        pos = JavaLexer.visitGeneric(visitor, receiver, chars, pos);
        TypeDef returnType = JavaLexer.extractType(chars, pos);
        visitor.visitReturnType(returnType, receiver);
        int start = pos = JavaLexer.eatWhitespace(chars, returnType.index);
        if (chars.charAt(pos) == '.' && chars.charAt(pos + 1) == '.') {
            pos = JavaLexer.eatWhitespace(chars, pos + 3);
            ++returnType.arrayDepth;
        }
        pos = JavaLexer.eatJavaname(chars, pos);
        visitor.visitName(chars.subSequence(start, pos).toString(), receiver);
        pos = JavaLexer.eatWhitespace(chars, pos);
        if (pos == chars.length()) {
            return pos;
        }
        if (chars.charAt(pos) == '(') {
            pos = JavaLexer.eatWhitespace(chars, pos + 1);
            while (chars.charAt(pos) != ')') {
                JavaVisitor.ParameterVisitor<R> param = visitor.visitParameter();
                pos = JavaLexer.visitAnnotation(param, receiver, chars, pos);
                pos = JavaLexer.visitModifier(param, receiver, chars, pos);
                TypeDef def = JavaLexer.extractType(chars, pos);
                start = pos = JavaLexer.eatWhitespace(chars, def.index);
                boolean varargs = false;
                if (chars.charAt(pos) == '.') {
                    assert (chars.charAt(pos + 1) == '.');
                    assert (chars.charAt(pos + 2) == '.');
                    ++def.arrayDepth;
                    start = pos = JavaLexer.eatWhitespace(chars, pos + 3);
                    pos = JavaLexer.eatJavaname(chars, start);
                    varargs = true;
                } else {
                    pos = JavaLexer.eatJavaname(chars, start);
                }
                param.visitType(def, chars.subSequence(start, pos).toString(), varargs, receiver);
                if (chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos)) != ',') continue;
                ++pos;
            }
        }
        if (pos == chars.length()) {
            return pos;
        }
        if ((pos = JavaLexer.eatWhitespace(chars, pos + 1)) == chars.length()) {
            return pos;
        }
        if (chars.charAt(pos) == 't' && chars.subSequence(pos, pos + 6).equals("throws")) {
            pos = JavaLexer.eatWhitespace(chars, pos + 7);
            while (pos < chars.length()) {
                if (chars.charAt(pos) == '{' || chars.charAt(pos) == ';') {
                    return pos;
                }
                start = pos;
                pos = JavaLexer.eatJavaname(chars, pos);
                visitor.visitException(chars.subSequence(start, pos).toString(), receiver);
                pos = JavaLexer.eatWhitespace(chars, pos);
                if (pos == chars.length()) {
                    return pos;
                }
                if (chars.charAt(pos) != ',') continue;
                pos = JavaLexer.eatWhitespace(chars, pos + 1);
            }
        }
        return JavaLexer.eatWhitespace(chars, pos);
    }

    public static TypeDef extractType(CharSequence chars, int pos) {
        TypeDef def;
        StringBuilder pkg;
        boolean doneParsing;
        int max;
        int lastPeriod;
        int start;
        block28: {
            start = pos = JavaLexer.eatWhitespace(chars, pos);
            lastPeriod = -1;
            max = chars.length() - 1;
            doneParsing = false;
            pkg = new StringBuilder();
            if (Character.isLowerCase(chars.charAt(pos))) {
                while (true) {
                    pos = JavaLexer.eatWhitespace(chars, pos);
                    while (Character.isJavaIdentifierPart(chars.charAt(++pos))) {
                        if (pos != max) continue;
                        if (lastPeriod == -1) {
                            doneParsing = true;
                        } else {
                            start = pos = lastPeriod + 1;
                        }
                        break block28;
                    }
                    int whitespace = JavaLexer.eatWhitespace(chars, pos);
                    char next = chars.charAt(whitespace);
                    if (next == '.') {
                        if (whitespace <= pos || chars.charAt(whitespace + 1) != '.') {
                            if (lastPeriod != -1) {
                                pkg.append('.');
                            }
                            lastPeriod = pos = whitespace;
                            pkg.append(chars.subSequence(start, pos).toString().trim());
                            pos = start = JavaLexer.eatWhitespace(chars, pos + 1);
                            if (!Character.isUpperCase(chars.charAt(start))) continue;
                        }
                        break block28;
                    }
                    if (whitespace > pos || next == '[' || next == '<') break;
                }
                doneParsing = true;
            }
        }
        if (doneParsing) {
            if (pos == max) {
                return new TypeDef(chars.subSequence(start, pos + 1).toString(), pos);
            }
            def = new TypeDef(chars.subSequence(start, pos).toString());
        } else {
            StringBuilder typeName;
            block29: {
                typeName = new StringBuilder();
                lastPeriod = -1;
                while (true) {
                    if (!Character.isJavaIdentifierStart(chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos)))) {
                        if (pos > start) {
                            if (lastPeriod != -1) {
                                typeName.append('.');
                            }
                            typeName.append(chars.subSequence(start, pos).toString().trim());
                        }
                        break block29;
                    }
                    while (Character.isJavaIdentifierPart(chars.charAt(++pos))) {
                        if (pos != max) continue;
                        if (lastPeriod != -1) {
                            typeName.append('.');
                        }
                        typeName.append(chars.subSequence(start, pos + 1).toString().trim());
                        break block29;
                    }
                    int whitespace = JavaLexer.eatWhitespace(chars, pos);
                    if (chars.charAt(whitespace) == '.') {
                        if (lastPeriod != -1) {
                            typeName.append('.');
                        }
                        if (pos != whitespace && chars.charAt(whitespace + 1) == '.') {
                            typeName.append(chars.subSequence(start, pos).toString().trim());
                            break block29;
                        }
                        lastPeriod = pos = whitespace;
                        typeName.append(chars.subSequence(start, pos).toString());
                        start = pos = JavaLexer.eatWhitespace(chars, pos + 1);
                        continue;
                    }
                    if (whitespace > pos) break;
                }
                if (lastPeriod != -1) {
                    typeName.append('.');
                }
                typeName.append(chars.subSequence(start, pos).toString().trim());
            }
            def = new TypeDef(typeName.toString());
            if (pos == max) {
                ++pos;
            }
        }
        def.pkgName = pkg.toString();
        start = pos = JavaLexer.eatWhitespace(chars, pos);
        if (pos < chars.length() && (pos = JavaLexer.eatGeneric(chars, pos)) != start) {
            def.generics = chars.subSequence(start, ++pos).toString();
        }
        pos = JavaLexer.eatWhitespace(chars, pos);
        while (pos < max && chars.charAt(pos) == '[') {
            ++def.arrayDepth;
            while (chars.charAt(++pos) != ']') {
            }
            pos = JavaLexer.eatWhitespace(chars, pos + 1);
        }
        if (pos < chars.length() && chars.charAt(pos) == '.') {
            assert (chars.charAt(pos + 1) == '.');
            assert (chars.charAt(pos + 2) == '.');
            ++def.arrayDepth;
            def.varargs = true;
            pos = JavaLexer.eatWhitespace(chars, pos + 3);
        }
        def.index = pos;
        return def;
    }

    public static SimpleStack<JavaModel.IsGeneric> extractGenerics(CharSequence chars, int pos) {
        SimpleStack<JavaModel.IsGeneric> stack = new SimpleStack<JavaModel.IsGeneric>();
        JavaLexer.visitGeneric(new GenericsExtractor(), stack, chars, pos);
        return stack;
    }

    /*
     * Unable to fully structure code
     */
    protected static <R> int eatAnnotationBody(JavaVisitor.AnnotationVisitor<R> visitor, R receiver, CharSequence chars, int pos) {
        pos = JavaLexer.eatWhitespace(chars, pos);
        nameNext = true;
        block16: while (true) {
            ++pos;
            pos = JavaLexer.eatWhitespace(chars, pos);
            switch (chars.charAt(pos)) {
                case ',': {
                    nameNext = true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block16;
                }
                case ')': {
                    return pos;
                }
                case '{': {
                    nameNext = false;
                }
            }
            if (nameNext) {
                nameNext = false;
                while (Character.isJavaIdentifierPart(chars.charAt(pos))) {
                    ++pos;
                }
                pos = JavaLexer.eatWhitespace(chars, pos);
                switch (chars.charAt(pos)) {
                    case '=': {
                        nameNext = false;
                        continue block16;
                    }
                    case ',': {
                        nameNext = true;
                        continue block16;
                    }
                    case ')': {
                        return pos;
                    }
                }
                --pos;
                continue;
            }
            switch (chars.charAt(pos)) {
                case '{': {
                    pos = JavaLexer.eatArrayInitializer(chars, pos);
                    continue block16;
                }
                case '\"': {
                    pos = JavaLexer.eatStringValue(chars, pos);
                    continue block16;
                }
                case '@': {
                    pos = JavaLexer.visitAnnotation(visitor, receiver, chars, pos);
                    continue block16;
                }
            }
            c = chars.charAt(pos);
            while (true) {
                if (!Character.isWhitespace(c)) ** break;
                continue block16;
                c = chars.charAt(++pos);
            }
            break;
        }
    }

    protected static <R> int eatWhitespaceAndComments(CharSequence chars, int pos) {
        int next = JavaLexer.eatWhitespace(chars, pos);
        int comment = JavaLexer.eatComments(chars, next);
        if (comment == pos) {
            return pos;
        }
        return JavaLexer.eatWhitespaceAndComments(chars, comment);
    }

    protected static int eatComments(CharSequence chars, int pos) {
        if (chars.charAt(pos) == '/') {
            if (chars.charAt(pos + 1) == '/') {
                while (chars.charAt(++pos) != '\n') {
                }
                ++pos;
            } else if (chars.charAt(pos + 1) == '*') {
                boolean done = false;
                while (!done) {
                    while (chars.charAt(++pos) != '*') {
                    }
                    done = chars.charAt(++pos) == '/';
                }
                ++pos;
            }
        }
        return pos;
    }

    protected static <R> int eatWhitespace(CharSequence chars, int pos) {
        try {
            while (Character.isWhitespace(chars.charAt(pos))) {
                ++pos;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return pos;
    }

    protected static int eatJavaname(CharSequence chars, int pos) {
        try {
            while (Character.isJavaIdentifierPart(chars.charAt(pos))) {
                ++pos;
            }
            if (chars.charAt(pos) == '.') {
                return JavaLexer.eatJavaname(chars, pos + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return pos;
    }

    protected static <R> int eatGeneric(CharSequence chars, int pos) {
        if ((pos = JavaLexer.eatWhitespace(chars, pos)) == chars.length()) {
            return pos;
        }
        if (chars.charAt(pos) == '<') {
            int genericDepth = 1;
            while (genericDepth > 0) {
                switch (chars.charAt(++pos)) {
                    case '>': {
                        --genericDepth;
                        break;
                    }
                    case '<': {
                        ++genericDepth;
                    }
                }
            }
        }
        return JavaLexer.eatWhitespace(chars, pos);
    }

    protected static int eatStringValue(CharSequence chars, int pos) {
        pos = JavaLexer.eatWhitespace(chars, pos);
        try {
            switch (chars.charAt(pos)) {
                case 'n': {
                    assert (chars.charAt(pos + 1) == 'u');
                    assert (chars.charAt(pos + 2) == 'l');
                    assert (chars.charAt(pos + 3) == 'l');
                    return pos + 4;
                }
                case '\"': {
                    char c;
                    boolean escaped = false;
                    while ((c = chars.charAt(++pos)) != '\"' || escaped) {
                        escaped = c == '\\' && !escaped;
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return pos;
    }

    protected static int eatArrayValue(CharSequence chars, int pos) {
        int arrayDepth = 1;
        while (arrayDepth > 0) {
            char c = chars.charAt(++pos);
            switch (c) {
                case '\"': {
                    pos = JavaLexer.eatStringValue(chars, pos);
                    break;
                }
                case '[': {
                    ++arrayDepth;
                    break;
                }
                case ']': {
                    --arrayDepth;
                }
            }
        }
        return pos + 1;
    }

    protected static int eatArrayInitializer(CharSequence chars, int pos) {
        while (true) {
            char c;
            if ((c = chars.charAt(++pos)) == '\"') {
                pos = JavaLexer.eatStringValue(chars, pos);
                continue;
            }
            if (c == '}') break;
        }
        return pos;
    }

    protected static boolean isQualified(String typeName) {
        return Character.isLowerCase(typeName.charAt(0)) && typeName.indexOf(46) != -1;
    }

    protected static void error(Throwable e, String string) {
        if (string != null) {
            System.err.println(string);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public JavaLexer(String definition) {
        int index;
        definition = definition.replace('\t', ' ');
        this.interfaces = new TreeSet<String>();
        this.generics = new TreeSet<String>();
        this.imports = new TreeSet<String>();
        String original = definition;
        int modifier = 0;
        if (definition.contains("public ")) {
            definition = definition.replace("public ", "");
            modifier = 1;
        } else if (definition.contains("protected ")) {
            definition = definition.replace("protected ", "");
            modifier = 4;
        } else if (definition.contains("private ")) {
            definition = definition.replace("private ", "");
            modifier = 2;
        } else {
            modifier = 0;
        }
        definition = definition.replace("{", "");
        if (definition.contains("static ")) {
            modifier |= 8;
            definition = definition.replace("static ", "");
        }
        if (definition.contains("final ")) {
            modifier |= 0x10;
            definition = definition.replace("final ", "");
        }
        if (definition.contains("native ")) {
            modifier |= 0x100;
            definition = definition.replace("native ", "");
        }
        if (definition.contains("synchronized ")) {
            modifier |= 0x20;
            definition = definition.replace("synchronized ", "");
        }
        if (definition.contains("abstract ")) {
            if (Modifier.isFinal(modifier |= 0x400)) {
                throw new TypeDefinitionException("A class or method cannot be both abstract and final!");
            }
            if (Modifier.isNative(modifier)) {
                throw new TypeDefinitionException("A method cannot be both abstract and native!");
            }
            definition = definition.replace("abstract ", "");
        }
        this.modifier = modifier;
        if (definition.contains("interface ")) {
            this.isEnum = false;
            this.isAnnotation = definition.contains("@interface");
            definition = this.isAnnotation ? definition.replace("@interface ", "") : definition.replace("interface ", "");
            this.isClass = false;
            this.superClass = null;
            index = definition.indexOf("extends ");
            if (index > 0) {
                for (String string : definition.substring(index + 8).split(",")) {
                    void var8_12;
                    String string2 = string.trim();
                    index = string2.lastIndexOf(46);
                    if (index > 0) {
                        this.imports.add(string2);
                        String string3 = string2.substring(index + 1);
                    }
                    this.interfaces.add((String)var8_12);
                }
                definition = definition.substring(0, index);
            }
        } else {
            this.isClass = definition.contains("class ");
            if (this.isClass) {
                definition = definition.replace("class ", "");
                this.isEnum = false;
            } else {
                this.isEnum = definition.contains("enum ");
                definition = definition.replace("enum ", "");
            }
            this.isAnnotation = false;
            if (this.isClass) {
                index = definition.indexOf("extends ");
                if (index > 0) {
                    int endIndex = definition.indexOf(32, index + 8);
                    if (endIndex == -1) {
                        this.superClass = definition.substring(index + 8);
                        definition = definition.replace("extends " + this.superClass, "");
                    } else {
                        this.superClass = definition.substring(index + 8, endIndex);
                        definition = definition.replace("extends " + this.superClass + " ", "");
                    }
                } else {
                    this.superClass = null;
                }
                index = definition.indexOf("implements ");
                if (index > 0) {
                    for (String string : definition.substring(index + 11).split(",")) {
                        void var8_16;
                        String string4 = string.trim();
                        int period = string4.lastIndexOf(46);
                        if (period > 0) {
                            int generic = string4.indexOf(60);
                            if (generic == -1) {
                                this.imports.add(string4);
                            } else {
                                this.imports.add(string4.substring(0, generic));
                            }
                            String string5 = string4.substring(period + 1);
                        }
                        this.interfaces.add((String)var8_16);
                    }
                    definition = definition.substring(0, index);
                }
            } else {
                this.superClass = null;
            }
        }
        if ((index = definition.indexOf(60)) > -1) {
            int methodLim = definition.indexOf(40);
            if (methodLim < 0 || methodLim > index) {
                this.isGenerics = true;
                int end = this.findEnd(definition, index);
                String generic = definition.substring(index + 1, end);
                for (String string : generic.split(",")) {
                    void var11_25;
                    String string6 = string.trim();
                    boolean noImport = string6.contains("!");
                    if (noImport) {
                        String string7 = string6.replaceAll("[!]", "");
                    } else {
                        for (String part : string6.split(" ")) {
                            void var11_29;
                            int period = part.lastIndexOf(46);
                            if (period < 0) continue;
                            this.imports.add(part);
                            String string8 = var11_29.replace(part.substring(0, period + 1), "");
                        }
                    }
                    this.generics.add((String)var11_25);
                }
                String string = definition.substring(0, index);
                definition = end < definition.length() - 1 ? string + definition.substring(end + 1) : string;
            } else {
                this.isGenerics = false;
            }
        } else {
            this.isGenerics = false;
        }
        definition = definition.trim();
        if (definition.contains(" ") && this.isClass) {
            throw new TypeDefinitionException("Found ambiguous class definition in " + original + "; leftover: " + definition);
        }
        if (definition.length() == 0) {
            throw new TypeDefinitionException("Did not have a class name in class definition " + original);
        }
        if (Modifier.isStatic(modifier) && Modifier.isAbstract(modifier) && !this.isClass) {
            throw new TypeDefinitionException("A method cannot be both abstract and static!");
        }
        this.className = definition;
    }

    private int findEnd(String definition, int index) {
        int opened = 1;
        while (index < definition.length()) {
            switch (definition.charAt(++index)) {
                case '<': {
                    ++opened;
                    break;
                }
                case '>': {
                    if (--opened != 0) break;
                    return index;
                }
            }
        }
        return -1;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPrivacy() {
        return this.modifier & 7;
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getGenerics() {
        return this.generics.toArray(new String[this.generics.size()]);
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public String[] getInterfaces() {
        return this.interfaces.toArray(new String[this.interfaces.size()]);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifier);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifier);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifier);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifier);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifier);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifier);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifier);
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean hasGenerics() {
        return this.isGenerics;
    }

    public static Iterable<String> findImportsInGeneric(final String generic) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Itr();
            }

            class Itr
            implements Iterator<String> {
                int pos = 0;
                int max;
                String qualifiedName;

                Itr() {
                    this.max = generic.length();
                }

                @Override
                public boolean hasNext() {
                    while (this.pos < this.max) {
                        if (Character.isJavaIdentifierStart(generic.charAt(this.pos))) {
                            int start = this.pos;
                            while (Character.isJavaIdentifierPart(generic.charAt(this.pos))) {
                                if (++this.pos != this.max) continue;
                                return false;
                            }
                            int whitespace = JavaLexer.eatWhitespace(generic, this.pos);
                            if (generic.charAt(whitespace) != '.') continue;
                            StringBuilder b = new StringBuilder(generic.substring(start, this.pos));
                            this.pos = whitespace;
                            do {
                                start = this.pos = JavaLexer.eatWhitespace(generic, this.pos + 1);
                                while (Character.isJavaIdentifierPart(generic.charAt(this.pos)) && ++this.pos != this.max) {
                                }
                                b.append('.').append(generic.substring(start, this.pos));
                                this.pos = JavaLexer.eatWhitespace(generic, this.pos);
                            } while (this.pos != this.max && generic.charAt(this.pos) == '.');
                            this.qualifiedName = b.toString();
                            return true;
                        }
                        ++this.pos;
                    }
                    return false;
                }

                @Override
                public String next() {
                    return this.qualifiedName;
                }

                @Override
                public void remove() {
                }
            }
        };
    }

    protected static String stripTypeMods(String type) {
        int end = type.indexOf(60);
        if (end != -1) {
            type = type.substring(0, end);
        }
        if ((end = type.indexOf(91)) != -1) {
            type = type.substring(0, end);
        }
        return type;
    }

    protected static int lexType(JavaModel.IsType into, CharSequence chars, int pos) {
        StringBuilder pkg;
        boolean doneParsing;
        int max;
        int lastPeriod;
        int start;
        block30: {
            start = pos = JavaLexer.eatWhitespace(chars, pos);
            lastPeriod = -1;
            max = chars.length() - 1;
            doneParsing = false;
            pkg = new StringBuilder();
            if (Character.isLowerCase(chars.charAt(pos))) {
                while (true) {
                    pos = JavaLexer.eatWhitespace(chars, pos);
                    while (Character.isJavaIdentifierPart(chars.charAt(++pos))) {
                        if (pos != max) continue;
                        if (lastPeriod == -1) {
                            doneParsing = true;
                        } else {
                            start = pos = lastPeriod + 1;
                        }
                        break block30;
                    }
                    int whitespace = JavaLexer.eatWhitespace(chars, pos);
                    if (chars.charAt(whitespace) == '.') {
                        if (whitespace <= pos || chars.charAt(whitespace + 1) != '.') {
                            if (lastPeriod != -1) {
                                pkg.append('.');
                            }
                            lastPeriod = pos = whitespace;
                            pkg.append(chars.subSequence(start, pos).toString().trim());
                            pos = start = JavaLexer.eatWhitespace(chars, pos + 1);
                            if (!Character.isUpperCase(chars.charAt(start))) continue;
                        }
                        break block30;
                    }
                    if (whitespace > pos) break;
                }
                doneParsing = true;
            }
        }
        if (doneParsing) {
            if (pos == max) {
                into.setType(pkg.toString(), chars.subSequence(start, pos + 1).toString());
                return pos;
            }
            into.setType(pkg.toString(), chars.subSequence(start, pos).toString());
        } else {
            StringBuilder typeName;
            block31: {
                typeName = new StringBuilder();
                lastPeriod = -1;
                while (true) {
                    if (!Character.isJavaIdentifierStart(chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos)))) {
                        if (pos > start) {
                            if (lastPeriod != -1) {
                                typeName.append('.');
                            }
                            typeName.append(chars.subSequence(start, pos).toString().trim());
                        }
                        break block31;
                    }
                    while (Character.isJavaIdentifierPart(chars.charAt(++pos))) {
                        if (pos != max) continue;
                        if (lastPeriod != -1) {
                            typeName.append('.');
                        }
                        typeName.append(chars.subSequence(start, pos + 1).toString().trim());
                        break block31;
                    }
                    int whitespace = JavaLexer.eatWhitespace(chars, pos);
                    if (chars.charAt(whitespace) == '.') {
                        if (lastPeriod != -1) {
                            typeName.append('.');
                        }
                        if (pos != whitespace && chars.charAt(whitespace + 1) == '.') {
                            typeName.append(chars.subSequence(start, pos).toString().trim());
                            break block31;
                        }
                        lastPeriod = pos = whitespace;
                        typeName.append(chars.subSequence(start, pos).toString());
                        start = pos = JavaLexer.eatWhitespace(chars, pos + 1);
                        continue;
                    }
                    if (whitespace > pos) break;
                }
                if (lastPeriod != -1) {
                    typeName.append('.');
                }
                typeName.append(chars.subSequence(start, pos).toString().trim());
            }
            into.setType(pkg.toString(), typeName.toString());
            if (pos == max) {
                ++pos;
            }
        }
        into.packageName = pkg.toString();
        start = pos = JavaLexer.eatWhitespace(chars, pos);
        if (pos < chars.length() && (pos = JavaLexer.eatGeneric(chars, pos)) != start) {
            JavaLexer.lexGenerics(into.generics, chars.subSequence(start, ++pos), 0);
        }
        pos = JavaLexer.eatWhitespace(chars, pos);
        try {
            while (chars.charAt(pos) == '[') {
                ++into.arrayDepth;
                while (chars.charAt(++pos) != ']') {
                }
                pos = JavaLexer.eatWhitespace(chars, pos + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (pos < chars.length() && chars.charAt(pos) == '.') {
            assert (chars.charAt(pos + 1) == '.');
            assert (chars.charAt(pos + 2) == '.');
            ++into.arrayDepth;
            pos = JavaLexer.eatWhitespace(chars, pos + 3);
        }
        return pos;
    }

    private static void lexGenerics(SimpleStack<JavaModel.IsGeneric> into, CharSequence chars, int pos) {
    }

    public static JavaModel.IsParameter lexParam(CharSequence chars) {
        int pos = JavaLexer.eatWhitespace(chars, 0);
        JavaModel.HasModifier mods = new JavaModel.HasModifier();
        JavaModel.HasAnnotations annos = new JavaModel.HasAnnotations();
        pos = JavaLexer.visitModifier(new ModifierExtractor(), mods, chars, pos);
        pos = JavaLexer.visitAnnotation(new AnnotationExtractor(), annos, chars, pos);
        TypeDef type = JavaLexer.extractType(chars, pos);
        int start = JavaLexer.eatWhitespace(chars, type.index);
        pos = JavaLexer.eatJavaname(chars, start);
        JavaModel.IsParameter param = new JavaModel.IsParameter(type.toString(), chars.subSequence(start, pos).toString());
        param.annotations = annos;
        param.modifier = mods.modifier;
        return param;
    }

    public static <Param> int visitClassFile(JavaVisitor.ClassVisitor<Param> extractor, Param receiver, CharSequence chars, int pos) {
        String typeName;
        if (chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos)) == '/') {
            StringBuilder b = new StringBuilder();
            pos = JavaLexer.visitJavadoc(new JavadocExtractor(), b, chars, pos);
            extractor.visitCopyright(b.toString(), receiver);
            pos = JavaLexer.eatWhitespace(chars, pos);
        }
        if (chars.charAt(pos) == 'p' && chars.charAt(pos + 1) == 'a') {
            assert (chars.subSequence(pos, pos + 7).toString().equals("package"));
            int start = pos = JavaLexer.eatWhitespace(chars, pos + 7);
            pos = JavaLexer.eatJavaname(chars, pos);
            extractor.visitPackage(chars.subSequence(start, pos).toString(), receiver);
            pos = JavaLexer.eatWhitespace(chars, pos);
            assert (chars.charAt(pos) == ';');
            pos = JavaLexer.eatWhitespace(chars, pos + 1);
        }
        while (chars.charAt(pos) == 'i' && chars.charAt(pos + 1) != 'n') {
            assert (chars.subSequence(pos, pos + 6).toString().endsWith("import"));
            int start = pos = JavaLexer.eatWhitespace(chars, pos + 6);
            boolean isStatic = false;
            String value = chars.subSequence(start, pos = JavaLexer.eatJavaname(chars, pos)).toString();
            if ("static".equals(value)) {
                isStatic = true;
                start = pos = JavaLexer.eatWhitespace(chars, pos);
                pos = JavaLexer.eatJavaname(chars, pos);
            }
            if (chars.charAt(pos) == '*') {
                ++pos;
            }
            extractor.visitImport(chars.subSequence(start, pos).toString(), isStatic, receiver);
            pos = JavaLexer.eatWhitespace(chars, pos);
            assert (chars.charAt(pos) == ';');
            pos = JavaLexer.eatWhitespace(chars, pos + 1);
        }
        pos = JavaLexer.visitModifier(extractor, receiver, chars, pos);
        pos = JavaLexer.eatWhitespace(chars, pos);
        boolean isEnum = false;
        boolean isInterface = false;
        switch (chars.charAt(pos)) {
            case 'c': {
                assert (chars.subSequence(pos, pos + 5).toString().equals("class"));
                extractor.visitType(chars.subSequence(pos, pos + 5).toString(), receiver);
                pos += 5;
                break;
            }
            case 'i': {
                isInterface = true;
                assert (chars.subSequence(pos, pos + 9).toString().equals("interface"));
                extractor.visitType(chars.subSequence(pos, pos + 9).toString(), receiver);
                pos += 9;
                break;
            }
            case '@': {
                isInterface = true;
                assert (chars.subSequence(pos, pos + 10).toString().equals("@interface"));
                extractor.visitType(chars.subSequence(pos, pos + 10).toString(), receiver);
                pos += 10;
                break;
            }
            case 'e': {
                isEnum = true;
                assert (chars.subSequence(pos, pos + 4).toString().equals("enum"));
                extractor.visitType(chars.subSequence(pos, pos + 4).toString(), receiver);
                pos += 4;
            }
        }
        pos = JavaLexer.eatWhitespace(chars, pos);
        int name = JavaLexer.eatJavaname(chars, pos);
        extractor.visitName(chars.subSequence(pos, name).toString(), receiver);
        pos = JavaLexer.eatWhitespace(chars, name);
        if (chars.charAt(pos) == 'e') {
            assert (chars.subSequence(pos, pos + 7).toString().equals("extends"));
            pos += 7;
            pos = JavaLexer.eatWhitespace(chars, pos);
            name = JavaLexer.eatJavaname(chars, pos);
            name = JavaLexer.eatGeneric(chars, name);
            typeName = chars.subSequence(pos, name).toString();
            if (isInterface) {
                extractor.visitInterface(typeName, receiver);
                pos = JavaLexer.eatWhitespace(chars, name + 1);
                while (chars.charAt(pos) == ',') {
                    pos = JavaLexer.eatWhitespace(chars, pos + 1);
                    name = JavaLexer.eatJavaname(chars, pos);
                    name = JavaLexer.eatGeneric(chars, pos);
                    typeName = chars.subSequence(pos, name).toString();
                    extractor.visitInterface(typeName, receiver);
                    pos = JavaLexer.eatWhitespace(chars, name + 1);
                }
            } else {
                extractor.visitSuperclass(typeName, receiver);
                pos = JavaLexer.eatWhitespace(chars, name + 1);
            }
        }
        if (chars.charAt(pos = JavaLexer.eatWhitespaceAndComments(chars, pos)) == 'i') {
            assert (chars.subSequence(pos, pos + 10).toString().equals("implements"));
            name = JavaLexer.eatJavaname(chars, pos += 10);
            name = JavaLexer.eatGeneric(chars, name);
            typeName = chars.subSequence(pos, name).toString();
            extractor.visitInterface(typeName, receiver);
            pos = JavaLexer.eatWhitespace(chars, name + 1);
            while (chars.charAt(pos) == ',') {
                pos = JavaLexer.eatWhitespace(chars, pos + 1);
                name = JavaLexer.eatJavaname(chars, pos);
                name = JavaLexer.eatGeneric(chars, pos);
                typeName = chars.subSequence(pos, name).toString();
                extractor.visitInterface(typeName, receiver);
                pos = JavaLexer.eatWhitespace(chars, name + 1);
            }
        }
        pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
        assert (chars.charAt(pos) == '{');
        ++pos;
        if (isEnum) {
            pos = JavaLexer.eatJavaname(chars, pos);
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
            while (chars.charAt(pos) != ';' && chars.charAt(pos) != '}') {
                if (chars.charAt(pos) == ',') {
                    ++pos;
                }
                pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
                pos = JavaLexer.eatJavaname(chars, pos);
                if (chars.charAt(pos = JavaLexer.eatWhitespaceAndComments(chars, pos)) == '(') {
                    int depth = 1;
                    while (depth > 0) {
                        pos = JavaLexer.eatWhitespace(chars, pos);
                        switch (chars.charAt(pos)) {
                            case '(': {
                                ++depth;
                                break;
                            }
                            case ')': {
                                --depth;
                                break;
                            }
                            case '\"': {
                                pos = JavaLexer.eatStringValue(chars, pos);
                                break;
                            }
                            case '{': {
                                pos = JavaLexer.shortcircuitClassBody(chars, pos);
                            }
                        }
                        ++pos;
                    }
                }
                if (chars.charAt(pos) == '{') {
                    pos = JavaLexer.shortcircuitClassBody(chars, pos + 1);
                }
                if (chars.charAt(pos = JavaLexer.eatWhitespaceAndComments(chars, pos)) != ',') continue;
            }
            if (chars.charAt(pos) == '}') {
                return pos + 1;
            }
        }
        pos = JavaLexer.eatWhitespaceAndComments(chars, pos + 1);
        return JavaLexer.shortcircuitClassBody(chars, pos);
    }

    protected static int shortcircuitClassBody(CharSequence chars, int pos) {
        block8: while (chars.charAt(pos) != '}') {
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
            while (chars.charAt(pos) == '@') {
                System.out.println(chars.charAt(pos) + "\n" + chars.subSequence(pos, pos + 10));
                pos = JavaLexer.eatJavaname(chars, pos + 1);
                if (chars.charAt(pos) == '(') {
                    pos = JavaLexer.eatAnnotationBody(NO_OP_ANNOTATION_VISITOR, null, chars, pos);
                }
                pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
                System.out.println(chars.charAt(pos) + "\n" + chars.subSequence(pos, pos + 10) + "\n\n\n");
            }
            pos = JavaLexer.visitModifier(NO_OP_MOD_VISITOR, null, chars, pos);
            pos = JavaLexer.eatJavaname(chars, pos);
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos + 1);
            pos = JavaLexer.visitGeneric(NO_OP_GENERIC_VISITOR, null, chars, pos);
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos + 1);
            pos = JavaLexer.eatJavaname(chars, pos);
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
            char c = chars.charAt(pos);
            switch (c) {
                case ';': {
                    pos = JavaLexer.eatWhitespaceAndComments(chars, pos + 1);
                    continue block8;
                }
                case '=': {
                    pos = JavaLexer.eatStatement(chars, pos + 1);
                    pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
                    break;
                }
                case '(': {
                    while (chars.charAt(++pos) != ')') {
                    }
                    if (chars.charAt(pos = JavaLexer.eatWhitespace(chars, pos + 1)) == ';') continue block8;
                }
                case 's': {
                    if (chars.charAt(pos) == 's') {
                        assert (chars.subSequence(pos, pos + 6).toString().equals("static"));
                        pos += 7;
                    }
                    pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
                    assert (chars.charAt(pos) == '{');
                    while (chars.charAt(pos) != '}') {
                        pos = JavaLexer.eatStatement(chars, pos + 1);
                        pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
                    }
                    ++pos;
                    break;
                }
                case 'e': 
                case 'i': {
                    while (chars.charAt(++pos) != '{') {
                    }
                }
                case '{': {
                    pos = JavaLexer.visitClassFile(NP_OP_CLASS_VISITOR, null, chars, pos);
                    break;
                }
                default: {
                    System.err.println("Unhandled char: " + c + " @ " + chars.subSequence(pos, Math.min(pos + 30, chars.length())));
                }
            }
            pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
        }
        return pos + 1;
    }

    protected static int eatStatement(CharSequence chars, int pos) {
        pos = JavaLexer.eatWhitespaceAndComments(chars, pos);
        while (chars.charAt(pos) != ';') {
            if (chars.charAt(pos) == '\"') {
                pos = JavaLexer.eatStringValue(chars, pos);
            } else if (chars.charAt(pos) == '/') {
                pos = JavaLexer.eatComments(chars, pos);
            } else if (chars.charAt(pos) == '{') {
                pos = JavaLexer.shortcircuitClassBody(chars, pos);
            }
            ++pos;
        }
        return pos + 1;
    }

    protected static class MemberData {
        protected final int modifier;
        protected final String simpleName;
        protected final String typeName;
        protected final String javaDoc;
        protected final Set<String> generics;
        protected final Set<String> imports;
        protected final Set<String> annotations;

        protected MemberData(int modifier, String simpleName, String typeName, String javaDoc) {
            this.modifier = modifier;
            this.simpleName = simpleName;
            this.typeName = typeName;
            this.javaDoc = javaDoc;
            this.generics = new TreeSet<String>();
            this.imports = new TreeSet<String>();
            this.annotations = new TreeSet<String>();
        }
    }

    public static class TypeDef
    extends JavaVisitor.TypeData {
        int index;
        public boolean varargs;

        public TypeDef(String name) {
            super(name);
        }

        public TypeDef(String name, int index) {
            super(name);
            this.index = index;
        }

        public boolean isArray() {
            return this.arrayDepth > 0;
        }
    }

    public static class GenericsExtractor
    implements JavaVisitor.GenericVisitor<SimpleStack<JavaModel.IsGeneric>> {
        @Override
        public void visitGeneric(String generic, SimpleStack<JavaModel.IsGeneric> receiver) {
            if (generic.charAt(0) == '<') {
                generic = generic.substring(1, generic.length() - 1);
            }
            receiver.add(new JavaModel.IsGeneric("", generic));
        }
    }

    public static class AnnotationMemberExtractor
    implements JavaVisitor.AnnotationMemberVisitor<JavaModel.HasAnnotations> {
        @Override
        public void visitMember(String name, String value, JavaModel.HasAnnotations receiver) {
            assert (!receiver.annotations.isEmpty()) : "You must visit an annotation before visiting an annotation member";
            ((JavaModel.IsAnnotation)receiver.annotations.tail()).members.add(new JavaModel.AnnotationMember(name, value));
        }
    }

    public static class JavadocExtractor
    implements JavaVisitor.JavadocVisitor<StringBuilder> {
        @Override
        public void visitJavadoc(String javadoc, StringBuilder receiver) {
            receiver.append(javadoc);
        }
    }

    public static class AnnotationExtractor
    implements JavaVisitor.AnnotationVisitor<JavaModel.HasAnnotations> {
        @Override
        public JavaVisitor.AnnotationMemberVisitor<JavaModel.HasAnnotations> visitAnnotation(String annoName, String annoBody, JavaModel.HasAnnotations receiver) {
            JavaModel.IsAnnotation anno = new JavaModel.IsAnnotation(annoName);
            if (receiver != null) {
                receiver.addAnnotation(anno);
            }
            return new AnnotationMemberExtractor();
        }
    }

    public static class ModifierExtractor
    implements JavaVisitor.ModifierVisitor<JavaModel.HasModifier> {
        @Override
        public void visitModifier(int modifier, JavaModel.HasModifier receiver) {
            receiver.modifier |= modifier;
        }
    }
}

