/*
 * Decompiled with CFR 0.152.
 */
package xapi.source;

import java.io.IOException;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;

public class X_Base64 {
    private static final int MIN = 43;
    private static final int MAX = 122;
    private static final int[] charToIntMap = new int[123];
    private static final char[] intToCharMap = new char[64];
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;

    private X_Base64() {
    }

    public static char toBase64(int number) {
        assert (0 < number) : "Base64 number " + number + " cannot be negative";
        assert (64 > number) : "Base64 number " + number + " must be between 0 and 63 (inclusive)";
        return intToCharMap[number];
    }

    public static int fromBase64(char number) {
        assert ('+' <= number) : "Base64 char " + number + " must be above minimum value, " + '+';
        assert ('z' >= number) : "Base64 char " + number + " must be below maximum value, " + 'z';
        assert ('A' == number || charToIntMap[number] > 0) : "Base64 char " + number + " (" + number + ") is not a valid Base64 value.";
        return charToIntMap[number];
    }

    private static int toVLQSigned(int value) {
        if (value < 0) {
            return (-value << 1) + 1;
        }
        return (value << 1) + 0;
    }

    private static int fromVLQSigned(int value) {
        boolean negate = (value & 1) == 1;
        return negate ? -value : (value >>= 1);
    }

    public static void encodeVLQ(Appendable out, int value) throws IOException {
        value = X_Base64.toVLQSigned(value);
        do {
            int digit = value & 0x1F;
            if ((value >>>= 5) > 0) {
                digit |= 0x20;
            }
            out.append(X_Base64.toBase64(digit));
        } while (value > 0);
    }

    public static int decode(CharIterator in) {
        boolean continuation;
        int result = 0;
        int shift = 0;
        do {
            char c;
            int digit;
            continuation = ((digit = X_Base64.fromBase64(c = in.next())) & 0x20) != 0;
            result += (digit &= 0x1F) << shift;
            shift += 5;
        } while (continuation);
        return X_Base64.fromVLQSigned(result);
    }

    public static CharIterator toCharIterator(String value) {
        return new StringCharIterator(value);
    }

    static {
        char[] chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        int i = chars.length;
        while (i-- > 0) {
            char ch;
            X_Base64.intToCharMap[i] = ch = chars[i];
            X_Base64.charToIntMap[ch] = i;
        }
    }
}

