/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ImportSection {
    private final Map<String, String> imports = new HashMap<String, String>();
    private final Map<String, String> importStatic = new HashMap<String, String>();

    public ImportSection addImports(String ... imports) {
        for (String iport : imports) {
            this.addImport(iport);
        }
        return this;
    }

    public String addImport(String importName) {
        return this.tryImport(importName, importName.contains("static "));
    }

    public String addStatic(Class<?> cls, String importName) {
        boolean hasStatic = importName != null && importName.length() > 0;
        return this.tryImport(cls.getCanonicalName() + (hasStatic ? "." + importName : ""), hasStatic, false);
    }

    public String addStatic(String importName) {
        return this.tryImport(importName, true);
    }

    public ImportSection addStatics(String ... imports) {
        for (String iport : imports) {
            this.addStatic(iport);
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Object[] values = this.importStatic.values().toArray(new String[this.importStatic.size()]);
        Arrays.sort(values);
        this.printImports(b, (String[])values, "import static ");
        if (values.length > 0) {
            b.append('\n');
        }
        values = this.imports.values().toArray(new String[this.imports.size()]);
        Arrays.sort(values);
        this.printImports(b, (String[])values, "import ");
        return b.toString();
    }

    private void printImports(StringBuilder b, String[] values, String importType) {
        if (values.length == 0) {
            return;
        }
        String prefix = this.prefixOf(values[0]);
        for (String importName : values) {
            if (importName.length() <= 0) continue;
            String newPrefix = this.prefixOf(importName);
            if (!newPrefix.equals(prefix)) {
                b.append('\n');
                prefix = newPrefix;
            }
            b.append(importType).append(importName).append(';').append('\n');
        }
    }

    private String prefixOf(String string) {
        int ind = string.indexOf(46);
        return ind == -1 ? string : string.substring(0, ind);
    }

    public ImportSection reserveSimpleName(String cls) {
        if (!this.imports.containsKey(cls)) {
            this.imports.put(cls, "");
        }
        return this;
    }

    public ImportSection reserveMethodName(String name) {
        if (!this.imports.containsKey(name)) {
            this.imports.put(name, "");
        }
        return this;
    }

    public String addImport(Class<?> cls) {
        if (cls.isPrimitive() || "java.lang".equals(cls.getPackage().getName())) {
            return cls.getSimpleName();
        }
        String existing = this.imports.get(cls.getSimpleName());
        if (existing != null) {
            if (existing.equals(cls.getCanonicalName())) {
                return cls.getSimpleName();
            }
            return cls.getCanonicalName();
        }
        this.imports.put(cls.getSimpleName(), cls.getCanonicalName());
        return cls.getSimpleName();
    }

    public ImportSection addImports(Class<?> ... imports) {
        for (Class<?> cls : imports) {
            this.addImport(cls);
        }
        return this;
    }

    protected boolean canMinimize(String importName) {
        String simpleName = importName.substring(importName.lastIndexOf(46) + 1);
        String existing = this.imports.get(simpleName);
        return existing == null || "".equals(existing) || existing.equals(importName);
    }

    protected String tryImport(String importName, boolean staticImport) {
        return this.tryImport(importName, staticImport, true);
    }

    protected String tryImport(String importName, boolean staticImport, boolean replaceDollarSigns) {
        String shortname;
        String suffix;
        Map<String, String> map = staticImport ? this.importStatic : this.imports;
        int arrayDepth = 0;
        int index = importName.indexOf(".");
        if (index == -1) {
            return importName;
        }
        index = importName.indexOf("[]");
        while (index != -1) {
            importName = importName.substring(0, index) + (index < importName.length() - 2 ? importName.substring(index + 2) : "");
            index = importName.indexOf("[]", index);
            ++arrayDepth;
        }
        index = (importName = this.trim(importName)).indexOf(60);
        if (index == -1) {
            suffix = "";
        } else {
            suffix = importName.substring(index);
            importName = importName.substring(0, index);
        }
        while (arrayDepth-- > 0) {
            suffix = suffix + "[]";
        }
        if (!staticImport && this.skipImports(importName)) {
            return importName.replace("java.lang.", "") + suffix;
        }
        if (replaceDollarSigns) {
            importName = importName.replace('$', '.');
        }
        if ("*".equals(shortname = importName.substring(1 + importName.lastIndexOf(46)))) {
            map.put(importName, importName);
            return importName + suffix;
        }
        String existing = map.get(shortname);
        if (existing == null) {
            map.put(shortname, importName);
            return shortname + suffix;
        }
        if (existing.equals(importName)) {
            return shortname + suffix;
        }
        return importName + suffix;
    }

    private boolean skipImports(String importName) {
        return importName.matches("((java[.]lang.[^.]*)|((void)|(boolean)|(short)|(char)|(int)|(long)|(float)|(double)|(String)|(Object)|(Void)|(Boolean)|(Short)|(Character)|(Integer)|(Long)|(Float)|(Double)))[;]*");
    }

    private String trim(String importName) {
        return importName.replaceAll("(\\[\\])|(\\s*import\\s+)|(static\\s+)|(\\s*;\\s*)", "");
    }
}

