/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.collect;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import xapi.collect.impl.AbstractLinkedList;

public abstract class AbstractLinkedListTest<L extends AbstractLinkedList<String, ?, L>> {
    final L stack = this.newList();

    @Before
    public void before() {
        this.stack.clear();
        this.stack.add((Object)"one").add((Object)"two");
    }

    @Test
    public void testClear() {
        Assert.assertFalse((boolean)this.stack.isEmpty());
        this.stack.clear();
        Assert.assertTrue((boolean)this.stack.isEmpty());
        Iterator iter = this.stack.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        for (String v : this.stack) {
            junit.framework.Assert.fail();
        }
    }

    @Test
    public void testConsume() {
        L stack2 = this.newList();
        stack2.add((Object)"three");
        this.stack.consume(stack2);
        Assert.assertEquals((Object)this.stack.head(), (Object)"one");
        Assert.assertEquals((Object)this.stack.tail(), (Object)"three");
        Assert.assertTrue((boolean)stack2.isEmpty());
        Assert.assertNull((Object)stack2.head());
        Assert.assertNull((Object)stack2.tail());
        this.assertIteratorContents(this.stack.iterator(), "one", "two", "three");
    }

    @Test
    public void testForEach() {
        String[] expected = new String[]{"one"};
        for (String s : this.stack) {
            Assert.assertEquals((Object)expected[0], (Object)s);
            expected[0] = "two";
        }
    }

    @Test
    public void testHeadAndTail() {
        Assert.assertEquals((Object)"one", (Object)this.stack.head());
        Assert.assertEquals((Object)"two", (Object)this.stack.tail());
        this.stack.add((Object)"three");
        Assert.assertEquals((Object)"three", (Object)this.stack.tail());
    }

    @Test
    public void testIterate() {
        this.assertIteratorContents(this.stack.iterator(), "one", "two");
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"one, two", (Object)this.stack.join(", "));
    }

    protected abstract L newList();

    void assertIteratorContents(Iterator<String> iter, String ... expecteds) {
        for (String expected : expecteds) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)expected, (Object)iter.next());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

