/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.read;

import org.junit.Assert;
import org.junit.Test;
import xapi.source.read.JavaLexer;
import xapi.source.read.JavaVisitor;

public class JavaLexerTest {
    @Test
    public void testAnnotationLexer() {
        final short[] success = new short[1];
        String annoBody = "name=\"one \\\"\\\"two\\\"\\\" three\\\\\", {1, 2.0, false}, values={1, \"string\", com.test.Class.class}";
        JavaLexer.visitAnnotation((JavaVisitor.AnnotationVisitor)new JavaVisitor.AnnotationVisitor<Void>(){

            public JavaVisitor.AnnotationMemberVisitor<Void> visitAnnotation(String annoName, String annoContent, Void receiver) {
                success[0] = 1;
                Assert.assertEquals((Object)annoName, (Object)"java.lang.Annotation");
                Assert.assertEquals((Object)annoContent, (Object)"name=\"one \\\"\\\"two\\\"\\\" three\\\\\", {1, 2.0, false}, values={1, \"string\", com.test.Class.class}");
                return null;
            }
        }, null, (CharSequence)"@java.lang.Annotation(name=\"one \\\"\\\"two\\\"\\\" three\\\\\", {1, 2.0, false}, values={1, \"string\", com.test.Class.class})", (int)0);
        Assert.assertEquals((long)success[0], (long)1L);
    }

    @Test
    public void testTypeLexer() {
        String type = "java.lang.Class";
        JavaLexer.TypeDef data = JavaLexer.extractType((CharSequence)type, (int)0);
        Assert.assertEquals((Object)"java.lang", (Object)data.pkgName);
        Assert.assertEquals((Object)"Class", (Object)data.clsName);
        Assert.assertEquals((Object)"Class", (Object)data.simpleName);
        Assert.assertEquals((Object)type, (Object)data.toString());
        String generics = "<SomeGenerics<With, Generics, In<Them>>>";
        type = "com.foo.Outer.Inner" + generics + " [] [][ ]";
        data = JavaLexer.extractType((CharSequence)type, (int)0);
        Assert.assertEquals((Object)"com.foo", (Object)data.pkgName);
        Assert.assertEquals((Object)"Outer.Inner", (Object)data.clsName);
        Assert.assertEquals((Object)"Inner", (Object)data.simpleName);
        Assert.assertEquals((long)3L, (long)data.arrayDepth);
        Assert.assertEquals((Object)generics, (Object)data.generics);
    }

    @Test
    public void testMethodLexer() {
        String methodGeneric = "<Complex, Generic extends Signature & More<Stuff>>";
        String modifiers = "public static final";
        String returnType = "Type";
        String returnGeneric = "<With<Generics>>";
        String methodName = "methodName";
        String paramGeneric = "<? extends Generic<int[]>>";
        String params = "String[] i, java . lang . Class<? extends Generic<int[]>> cls";
        String exceptions = "java.lang.RuntimeException, ClassCastException  ";
        String method = "public static final <Complex, Generic extends Signature & More<Stuff>> Type<With<Generics>>[][] methodName(" + params + ") throws " + exceptions;
        final int[] success = new int[8];
        JavaLexer.visitMethodSignature((JavaVisitor.MethodVisitor)new JavaVisitor.MethodVisitor<Void>(){

            public JavaVisitor.AnnotationMemberVisitor<Void> visitAnnotation(String annoName, String annoBody, Void receiver) {
                Assert.fail((String)"No annotations");
                return null;
            }

            public void visitJavadoc(String javadoc, Void receiver) {
                Assert.fail((String)"No javadoc");
            }

            public void visitModifier(int modifier, Void receiver) {
                switch (modifier) {
                    case 1: 
                    case 8: 
                    case 16: {
                        success[0] = success[0] | modifier;
                        break;
                    }
                    default: {
                        Assert.fail((String)("Illegal modifier: " + Integer.toHexString(modifier)));
                    }
                }
            }

            public void visitGeneric(String generic, Void receiver) {
                Assert.assertEquals((Object)generic, (Object)"<Complex, Generic extends Signature & More<Stuff>>");
                success[1] = 1;
            }

            public void visitReturnType(JavaVisitor.TypeData returnedType, Void receiver) {
                Assert.assertEquals((Object)returnedType.clsName, (Object)"Type");
                Assert.assertEquals((Object)returnedType.generics, (Object)"<With<Generics>>");
                Assert.assertEquals((long)returnedType.arrayDepth, (long)2L);
                success[2] = 1;
            }

            public void visitName(String name, Void receiver) {
                Assert.assertEquals((Object)name, (Object)"methodName");
                success[3] = 1;
            }

            public JavaVisitor.ParameterVisitor<Void> visitParameter() {
                return new JavaVisitor.ParameterVisitor<Void>(){

                    public JavaVisitor.AnnotationMemberVisitor<Void> visitAnnotation(String annoName, String annoBody, Void receiver) {
                        return null;
                    }

                    public void visitModifier(int modifier, Void receiver) {
                    }

                    public void visitType(JavaVisitor.TypeData type, String name, boolean varargs, Void receiver) {
                        if ("i".equals(name)) {
                            success[4] = 1;
                            Assert.assertEquals((Object)"String", (Object)type.clsName);
                            Assert.assertEquals((long)1L, (long)type.arrayDepth);
                        } else if ("cls".equals(name)) {
                            success[5] = 1;
                            Assert.assertEquals((Object)"java.lang", (Object)type.pkgName);
                            Assert.assertEquals((Object)"Class", (Object)type.clsName);
                            Assert.assertEquals((long)0L, (long)type.arrayDepth);
                            Assert.assertEquals((Object)"<? extends Generic<int[]>>", (Object)type.generics);
                        } else {
                            Assert.fail((String)("Unrecognized name: " + name + "; type: " + type));
                        }
                    }
                };
            }

            public void visitException(String type, Void receiver) {
                if ("java.lang.RuntimeException".equals(type)) {
                    success[6] = 1;
                } else if ("ClassCastException".equals(type)) {
                    success[7] = 1;
                } else {
                    Assert.fail((String)("Unrecognized exception type: " + type));
                }
            }
        }, null, (CharSequence)method, (int)0);
        Assert.assertArrayEquals((int[])success, (int[])new int[]{25, 1, 1, 1, 1, 1, 1, 1});
    }
}

