/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import org.junit.Assert;
import org.junit.Test;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.FieldBuffer;
import xapi.dev.source.MethodBuffer;
import xapi.dev.source.SourceBuilder;

public class TestCodegen {
    @Test
    public void testGenericImports() {
        SourceBuilder b = new SourceBuilder("public static abstract class xapi.Test");
        b.setPackage("xapi.test");
        ((ClassBuffer)b.getClassBuffer().addGenerics(new String[]{"K", "V extends java.util.Date"})).addInterfaces(new String[]{"java.util.Iterator"});
        Assert.assertTrue((boolean)b.toString().contains("import java.util.Date;"));
        Assert.assertTrue((boolean)b.toString().contains("import java.util.Iterator;"));
    }

    @Test
    public void testMethodWriter() {
        SourceBuilder b = new SourceBuilder("public static abstract class Test");
        b.setPackage("xapi.test");
        ((MethodBuffer)b.getClassBuffer().createMethod("public <T extends java.util.Date> void Test(java.lang.String t) {").println("System.out.println(\"Hellow World\");")).createLocalClass("class InnerClass ").createMethod("java.sql.Date innerMethod()").returnValue("null");
        Assert.assertFalse((boolean)b.toString().contains("import java.lang.String;"));
        Assert.assertTrue((boolean)b.toString().contains("import java.util.Date;"));
        Assert.assertTrue((boolean)b.toString().contains("<T extends Date>"));
        Assert.assertFalse((boolean)b.toString().contains("import java.sql.Date;"));
    }

    @Test
    public void testMethodWithSimpleGeneric() {
        SourceBuilder b = new SourceBuilder("public static abstract class Test");
        b.getClassBuffer().createMethod("public native <T> Class<T> magicClass(Class<T> ... cls)");
    }

    @Test
    public void testFieldWriter() {
        SourceBuilder b = new SourceBuilder("public static abstract class Test");
        b.setPackage("xapi.test");
        FieldBuffer f = b.getClassBuffer().createField("int", "theInt");
        f.addGetter(0);
        f.addSetter(0);
    }
}

