/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import xapi.source.write.Template;

public class TemplateTest {
    @Test
    public void testSimpleTemplate() {
        Template generator = new Template("(<>[])$.toArray()", new String[]{"<>", "$"});
        String result = generator.apply(new Object[]{"String", "this.value"});
        Assert.assertEquals((Object)result, (Object)"(String[])this.value.toArray()");
    }

    @Test
    public void testComplexTemplate() {
        Template generator = new Template("Hello $2!\n$1.$3($4, $5);\n$4.$1($2, $3, $1, $5);", new String[]{"$1", "$2", "$3", "$4", "$5"});
        String result = generator.apply(new Object[]{"hello", "world", "three", "four", "5"});
        Assert.assertEquals((Object)result, (Object)"Hello world!\nhello.three(four, 5);\nfour.hello(world, three, hello, 5);");
    }

    @Test
    public void testRandomTemplates() {
        if (Boolean.getBoolean("xapi.benchmark")) {
            for (int i = 0; i < 14; ++i) {
                this.testRandomTemplates((int)Math.pow(2.0, i));
            }
        } else {
            this.testRandomTemplates(1000);
        }
    }

    private void testRandomTemplates(final int iters) {
        int loops = 50;
        int numItems = 32;
        final String[] templates = new String[loops];
        Object[] manualCases = new Object[loops];
        Object[] templateCases = new Object[loops];
        while (loops-- > 0) {
            final int loop = loops;
            numItems = 8 + numItems % 23 % 28;
            final String[] replacers = new String[numItems];
            Object[] values = new String[numItems];
            while (numItems-- > 0) {
                int c = Character.forDigit(numItems, 36);
                values[numItems] = "_" + (char)c + "_";
                replacers[numItems] = String.valueOf((char)c);
            }
            templates[loop] = this.randomChars(16 + (int)(Math.random() * 128.0));
            templateCases[loop] = new Runnable((String[])values, templateCases){
                final /* synthetic */ String[] val$values;
                final /* synthetic */ Object[] val$templateCases;
                {
                    this.val$values = stringArray3;
                    this.val$templateCases = objectArray;
                }

                @Override
                public void run() {
                    int iterations = iters;
                    Template t = new Template(templates[loop], replacers);
                    String templateResult = null;
                    while (iterations-- > 0) {
                        templateResult = t.apply((Object[])this.val$values);
                    }
                    this.val$templateCases[loop] = templateResult;
                }
            };
            manualCases[loop] = new Runnable((String[])values, replacers, templates, loop, manualCases){
                final /* synthetic */ String[] val$values;
                final /* synthetic */ String[] val$replacers;
                final /* synthetic */ String[] val$templates;
                final /* synthetic */ int val$loop;
                final /* synthetic */ Object[] val$manualCases;
                {
                    this.val$values = stringArray;
                    this.val$replacers = stringArray2;
                    this.val$templates = stringArray3;
                    this.val$loop = n2;
                    this.val$manualCases = objectArray;
                }

                @Override
                public void run() {
                    int iterations = iters;
                    Pattern[] patterns = new Pattern[this.val$values.length];
                    int i = this.val$values.length;
                    while (i-- > 0) {
                        patterns[i] = Pattern.compile(this.val$replacers[i]);
                    }
                    while (iterations-- > 0) {
                        String manualResult = this.val$templates[this.val$loop];
                        for (int i2 = 0; i2 < this.val$values.length; ++i2) {
                            manualResult = patterns[i2].matcher(manualResult).replaceAll(this.val$values[i2]);
                        }
                        this.val$manualCases[this.val$loop] = manualResult;
                    }
                }
            };
        }
        System.gc();
        long start = System.nanoTime();
        for (Object o : manualCases) {
            ((Runnable)o).run();
        }
        float manualTime = System.nanoTime() - start;
        start = System.nanoTime();
        for (Object o : templateCases) {
            ((Runnable)o).run();
        }
        float templateTime = System.nanoTime() - start;
        System.out.println("Template is " + manualTime / templateTime + " faster than runtime " + "string operations for " + iters + " iterations.");
        int i = templateCases.length;
        while (i-- > 0) {
            Assert.assertEquals((String)("Original: " + templates[i] + "\n" + "Manual: " + manualCases[i] + "\n" + "Template: " + templateCases[i] + "\n"), (Object)((String)manualCases[i]), (Object)((String)templateCases[i]));
        }
    }

    private String randomChars(int numChars) {
        StringBuilder b = new StringBuilder();
        int m = (int)(Math.random() * (double)numChars);
        for (int i = 0; i < m; ++i) {
            b.append(Character.forDigit((int)(Math.random() * 36.0), 36));
        }
        return b.toString();
    }
}

