/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import xapi.dev.source.ClassBuffer;
import xapi.dev.source.ImportSection;
import xapi.dev.source.PrintBuffer;
import xapi.except.NotConfiguredCorrectly;

public class SourceBuilder<Payload> {
    private final PrintBuffer head;
    private PrintBuffer buffer;
    private ImportSection imports;
    private ClassBuffer classDef;
    private Payload payload;
    private String repackage;
    private int skip;

    public SourceBuilder() {
        this.head = this.buffer = new PrintBuffer();
    }

    public SourceBuilder(String classDef) {
        this();
        this.setClassDefinition(classDef, classDef.trim().endsWith("{"));
    }

    public PrintBuffer getBuffer() {
        return this.buffer;
    }

    public ClassBuffer getClassBuffer() {
        if (this.classDef == null) {
            throw new NotConfiguredCorrectly("setClassDefinition() has not been called yet.\nIf you are running the template generator, your template does include a //@classDefinition()// declaration,\nor your generator is attempting to access the class definition before it is parsed.");
        }
        return this.classDef;
    }

    public SourceBuilder<Payload> setClassDefinition(String definition, boolean wellFormatted) {
        if (this.classDef == null) {
            this.getImports();
            this.classDef = new ClassBuffer(this);
            this.head.addToEnd(this.classDef);
            this.addBuffer(new PrintBuffer());
        }
        this.classDef.setDefinition(definition, wellFormatted);
        return this;
    }

    public ImportSection getImports() {
        if (this.imports == null) {
            this.imports = new ImportSection();
        }
        return this.imports;
    }

    public Payload getPayload() {
        return this.payload;
    }

    protected SourceBuilder<Payload> addBuffer(PrintBuffer newBuffer) {
        if (newBuffer == this.buffer) {
            return this;
        }
        this.head.addToEnd(newBuffer);
        this.buffer = newBuffer;
        return this;
    }

    public SourceBuilder<Payload> setPayload(Payload payload) {
        this.payload = payload;
        return this;
    }

    public String getRepackage() {
        return this.repackage;
    }

    public SourceBuilder<Payload> setPackage(String repackage) {
        if (repackage.endsWith(";")) {
            repackage = repackage.substring(0, repackage.length() - 1);
        }
        if (repackage.startsWith("package ")) {
            repackage = repackage.substring(8);
        }
        this.repackage = repackage;
        return this;
    }

    public SourceBuilder<Payload> setLinesToSkip(int i) {
        this.skip = i;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLinesToSkip() {
        try {
            int n = this.skip;
            return n;
        }
        finally {
            this.skip = 0;
        }
    }

    public String toString() {
        StringBuilder source = new StringBuilder();
        String body = this.head.toString();
        if (this.repackage != null) {
            if (body.trim().startsWith("package")) {
                int ind = body.indexOf(59, body.indexOf("package"));
                body = body.substring(ind + 1);
            }
            source.append("package " + this.repackage + ";\n\n");
        }
        if (this.imports != null) {
            source.append(this.imports.toString());
        }
        source.append(body);
        return source.toString();
    }
}

