/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.JavaMetadata;
import xapi.dev.source.PrintBuffer;
import xapi.dev.source.SourceBuilder;
import xapi.source.except.TypeDefinitionException;
import xapi.util.X_String;

public class MethodBuffer
extends PrintBuffer {
    private int modifier;
    protected SourceBuilder<?> context;
    private boolean once;
    private boolean useJsni = true;
    private String methodName;
    private final Set<String> annotations;
    private final Set<String> generics;
    private final Set<String> parameters;
    private final Set<String> exceptions;
    private String returnType;
    final String origIndent;

    public MethodBuffer(SourceBuilder<?> context) {
        this(context, "  ");
    }

    public MethodBuffer(SourceBuilder<?> context, String indent) {
        this.context = context;
        this.origIndent = indent;
        this.indent = indent + "  ";
        this.generics = new LinkedHashSet<String>();
        this.parameters = new LinkedHashSet<String>();
        this.annotations = new LinkedHashSet<String>();
        this.exceptions = new LinkedHashSet<String>();
    }

    @Override
    public String toString() {
        String suffix;
        String prefix;
        StringBuilder b = new StringBuilder('\n' + this.origIndent);
        if (this.annotations.size() > 0) {
            for (String anno : this.annotations) {
                b.append('@').append(anno).append('\n' + this.origIndent);
            }
        }
        b.append(Modifier.toString(this.modifier));
        b.append(" ");
        if (this.generics.size() > 0) {
            b.append("<");
            prefix = "";
            for (String generic : this.generics) {
                b.append(prefix);
                b.append(generic);
                prefix = ", ";
            }
            b.append("> ");
        }
        b.append(this.returnType).append(" ");
        b.append(this.methodName);
        b.append(" (");
        prefix = "";
        for (String parameter : this.parameters) {
            b.append(prefix).append(parameter);
            prefix = ", ";
        }
        b.append(") ");
        if (!this.exceptions.isEmpty()) {
            b.append("\n" + this.indent + "  throws ");
            prefix = "";
            for (String exception : this.exceptions) {
                b.append(prefix).append(exception);
                prefix = ", ";
            }
        }
        if (Modifier.isAbstract(this.modifier)) {
            prefix = ";\n";
            suffix = "";
        } else if (Modifier.isNative(this.modifier)) {
            if (this.useJsni) {
                prefix = "/*-{\n";
                suffix = (this.once ? Character.valueOf('\n') : "") + this.origIndent + "}-*/;\n";
            } else {
                prefix = ";\n";
                suffix = "";
            }
        } else {
            prefix = "{\n";
            suffix = (this.once ? Character.valueOf('\n') : "") + this.origIndent + "}\n";
        }
        return b.toString() + prefix + super.toString() + suffix;
    }

    public void setDefinition(String definition) {
        JavaMetadata metadata = new JavaMetadata(definition);
        int genericPos = definition.indexOf(62);
        this.modifier = metadata.getModifier();
        genericPos -= Modifier.toString(Modifier.methodModifiers() & this.modifier).length();
        definition = metadata.getClassName().trim();
        this.context.getImports().addImports(metadata.getImports());
        boolean usedGenerics = false;
        int ind = definition.indexOf(32);
        if (ind == -1) {
            this.returnType = "";
        } else {
            this.returnType = definition.substring(0, ind);
            if (ind < genericPos) {
                usedGenerics = true;
            }
            definition = definition.substring(ind + 1);
            ind = this.returnType.lastIndexOf(46);
            if (ind > 0) {
                this.context.getImports().addImport(this.returnType);
                this.returnType = this.returnType.substring(ind + 1);
            }
            if (usedGenerics && metadata.hasGenerics()) {
                this.returnType = this.returnType + "<" + X_String.join((String)", ", (String[])metadata.getGenerics()) + "> ";
            }
        }
        if (!usedGenerics && metadata.hasGenerics()) {
            String[] generic;
            this.generics.clear();
            for (String s : generic = metadata.getGenerics()) {
                this.generics.add(s);
            }
        }
        ind = definition.indexOf(40);
        assert (ind > 0);
        this.methodName = definition.substring(0, ind).trim();
        definition = definition.substring(ind + 1, definition.lastIndexOf(41)).trim();
        for (String param : definition.split(",")) {
            ind = (param = param.trim()).lastIndexOf("...");
            ind = ind == -1 ? param.lastIndexOf(46) : param.lastIndexOf(46, ind - 1);
            if (ind > 0) {
                String importable = param.substring(0, param.indexOf(32));
                int end = importable.indexOf(60);
                if (end < 0) {
                    this.context.getImports().addImport(importable);
                } else {
                    this.context.getImports().addImport(importable.substring(0, end));
                }
                param = param.substring(ind + 1);
            }
            this.parameters.add(param);
        }
        if (this.methodName.contains(" ")) {
            throw new TypeDefinitionException("Found ambiguous method definition in " + definition);
        }
        if (this.methodName.length() == 0) {
            throw new TypeDefinitionException("Did not have a class name in class definition " + definition);
        }
    }

    public void addParameters(String ... parameters) {
        for (String parameter0 : parameters) {
            for (String parameter : parameter0.split(",")) {
                int index = (parameter = parameter.trim()).lastIndexOf(46);
                if (index > 0) {
                    int end = parameter.lastIndexOf(32);
                    assert (end > 0);
                    String fqcn = parameter.substring(0, end);
                    this.context.getImports().addImport(fqcn);
                    this.parameters.add(parameter.substring(index + 1));
                    continue;
                }
                this.parameters.add(parameter);
            }
        }
    }

    public void addGenerics(String ... generics) {
        for (String generic : generics) {
            boolean noImport = (generic = generic.trim()).contains("!");
            if (noImport) {
                this.generics.add(generic.replace("!", ""));
                continue;
            }
            for (String part : generic.split(" ")) {
                int index = generic.lastIndexOf(".");
                if (index <= 0) continue;
                this.context.getImports().addImport(part);
                generic = generic.replace(part.substring(0, index + 1), "");
            }
            this.generics.add(generic);
        }
    }

    public MethodBuffer addAnnotation(Class<?> anno) {
        this.context.getImports().addImports(anno);
        this.annotations.add(anno.getSimpleName());
        return this;
    }

    public MethodBuffer addAnnotation(String anno) {
        int hasPeriod;
        if (anno.charAt(0) == '@') {
            anno = anno.substring(1);
        }
        if ((hasPeriod = (anno = anno.trim()).indexOf(46)) != -1) {
            int openParen = anno.indexOf(40);
            if (openParen == -1) {
                hasPeriod = anno.lastIndexOf(46);
                this.context.getImports().addImport(anno);
            } else {
                hasPeriod = anno.lastIndexOf(46, openParen);
                this.context.getImports().addImport(anno.substring(0, openParen).trim());
            }
            anno = anno.substring(hasPeriod + 1);
        }
        this.annotations.add(anno);
        return this;
    }

    public ClassBuffer createInnerClass(String classDef) {
        ClassBuffer cls = new ClassBuffer(this.context);
        cls.setDefinition(classDef, classDef.trim().endsWith("{"));
        cls.indent = this.indent + "  ";
        assert (cls.privacy == 0) : "A local class cannot be " + Modifier.toString(cls.privacy);
        this.addToEnd(cls);
        return cls;
    }

    @Override
    protected void onAppend() {
        if (this.once) {
            this.once = false;
            this.onFirstAppend();
        }
        super.onAppend();
    }

    protected void onFirstAppend() {
    }

    public MethodBuffer setUseJsni(boolean useJsni) {
        this.useJsni = useJsni;
        this.modifier |= 0x100;
        return this;
    }

    @Override
    public MethodBuffer append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public MethodBuffer append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public MethodBuffer append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public MethodBuffer append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public MethodBuffer append(CharSequence s) {
        super.append(s);
        return this;
    }

    @Override
    public MethodBuffer append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public MethodBuffer append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public MethodBuffer append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public MethodBuffer append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public MethodBuffer append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public MethodBuffer append(Object obj) {
        super.append(obj);
        return this;
    }

    @Override
    public MethodBuffer append(String str) {
        super.append(str);
        return this;
    }

    @Override
    public MethodBuffer indent() {
        super.indent();
        return this;
    }

    @Override
    public MethodBuffer indentln(char[] str) {
        super.indentln(str);
        return this;
    }

    @Override
    public MethodBuffer indentln(CharSequence s) {
        super.indentln(s);
        return this;
    }

    @Override
    public MethodBuffer indentln(Object obj) {
        super.indentln(obj);
        return this;
    }

    @Override
    public MethodBuffer indentln(String str) {
        super.indentln(str);
        return this;
    }

    @Override
    public MethodBuffer outdent() {
        super.outdent();
        return this;
    }

    @Override
    public MethodBuffer println() {
        super.println();
        return this;
    }

    @Override
    public MethodBuffer println(char[] str) {
        super.println(str);
        return this;
    }

    @Override
    public MethodBuffer println(CharSequence s) {
        super.println(s);
        return this;
    }

    @Override
    public MethodBuffer println(Object obj) {
        super.println(obj);
        return this;
    }

    @Override
    public MethodBuffer println(String str) {
        super.println(str);
        return this;
    }

    public MethodBuffer makeJsni() {
        this.setUseJsni(true).makeFinal();
        return this;
    }

    public MethodBuffer makeNative() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 0x100;
        return this;
    }

    public MethodBuffer makeFinal() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 0x10;
        return this;
    }

    public MethodBuffer makeStatic() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 8;
        return this;
    }

    public MethodBuffer makeAbstract() {
        if ((this.modifier & 8) > 0) {
            this.modifier &= 0xFFFFFFF7;
        }
        if ((this.modifier & 0x100) > 0) {
            this.modifier &= 0xFFFFFEFF;
        }
        this.modifier |= 0x400;
        return this;
    }

    public MethodBuffer makeConcrete() {
        this.modifier &= 0xFFFFFBFF;
        return this;
    }

    public MethodBuffer makePublic() {
        this.modifier &= 0xFFF9;
        return this;
    }

    public MethodBuffer makeProtected() {
        this.modifier &= 0xFFFC;
        return this;
    }

    public MethodBuffer makePrivate() {
        this.modifier &= 0xFFFA;
        return this;
    }

    public MethodBuffer makePackageProtected() {
        this.modifier &= 0xFFF8;
        return this;
    }

    public MethodBuffer addThrowsClause(Class<?> ... throwables) {
        this.context.getImports().addImports(throwables);
        for (Class<?> cls : throwables) {
            this.exceptions.add(cls.getSimpleName());
        }
        return this;
    }

    public MethodBuffer addThrowsClause(String ... throwables) {
        for (String cls : throwables) {
            int ind = cls.lastIndexOf(46);
            if (ind == -1) {
                this.exceptions.add(cls);
                continue;
            }
            this.context.getImports().addImport(cls);
            this.exceptions.add(cls.substring(ind + 1));
        }
        return this;
    }
}

