/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.TreeSet;
import java.util.regex.Pattern;

public class ImportSection {
    private TreeSet<String> imports = new TreeSet();
    private TreeSet<String> importStatic = new TreeSet();
    private static final Pattern skipImports = Pattern.compile("(import )*(static )*((java[.]lang.[^.]*)|((void)(boolean)(short)(char)(int)(long)(float)(double)))[;]*");
    private static final Pattern trimArrays = Pattern.compile("\\[\\]");

    public ImportSection addImports(String ... imports) {
        for (String iport : imports) {
            this.addImport(iport);
        }
        return this;
    }

    public ImportSection addImport(String importName) {
        if (skipImports.matcher(importName).matches()) {
            return this;
        }
        if ((importName = trimArrays.matcher(importName.trim()).replaceAll("")).startsWith("import ")) {
            this.imports.add(importName);
        } else {
            this.imports.add("import " + importName + ";");
        }
        return this;
    }

    public void addStatics(String ... imports) {
        for (String iport : imports) {
            this.addStatic(iport);
        }
    }

    public void addStatic(String importName) {
        if (importName.startsWith("import static ")) {
            this.importStatic.add(importName.trim());
        } else {
            this.importStatic.add("import static " + importName + ";");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(10);
        for (String importName : this.imports) {
            b.append(importName);
            b.append('\n');
        }
        for (String importName : this.importStatic) {
            b.append(importName);
            b.append('\n');
        }
        return b.toString() + '\n';
    }

    public ImportSection addImport(Class<?> importName) {
        this.imports.add("import " + importName.getCanonicalName() + ";");
        return this;
    }

    public ImportSection addImports(Class<?> ... imports) {
        for (Class<?> cls : imports) {
            this.imports.add("import " + cls.getCanonicalName() + ";");
        }
        return this;
    }
}

