/*
 * Decompiled with CFR 0.152.
 */
package xapi.shell.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.io.X_IO;
import xapi.io.api.HasLiveness;
import xapi.io.api.LineReader;
import xapi.io.api.StringReader;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.process.X_Process;
import xapi.shell.api.ArgumentProcessor;
import xapi.shell.api.ShellCommand;
import xapi.shell.api.ShellSession;
import xapi.shell.impl.ShellCommandDefault;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.time.impl.RunOnce;
import xapi.util.X_Debug;
import xapi.util.api.ErrorHandler;
import xapi.util.api.Pointer;
import xapi.util.api.RemovalHandler;
import xapi.util.api.SuccessHandler;

class ShellSessionDefault
implements ShellSession,
Runnable {
    Process process;
    public boolean finished;
    private final ShellCommandDefault command;
    private final StringReader onStdErr = new StringReader();
    private final StringReader onStdOut = new StringReader();
    private final Fifo<String> stdIns = X_Collect.newFifo();
    private final Fifo<RemovalHandler> clears = X_Collect.newFifo();
    private final SuccessHandler<ShellSession> callback;
    private final ErrorHandler<Throwable> err;
    private final ArgumentProcessor processor;
    private final Moment birth = X_Time.now();
    private final RunOnce once = new RunOnce();
    private boolean normalCompletion;
    PipeOut out;
    private Integer status;

    public ShellSessionDefault(ShellCommandDefault cmd, ArgumentProcessor argProcessor, SuccessHandler<ShellSession> onSuccess, ErrorHandler<Throwable> onError) {
        this.command = cmd;
        this.callback = onSuccess;
        this.err = onError;
        this.processor = argProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream stdErr;
        InputStream stdOut;
        ShellSessionDefault shellSessionDefault = this;
        synchronized (shellSessionDefault) {
            if (this.process == null) {
                InputStream o = null;
                InputStream e = null;
                try {
                    this.process = this.command.doRun(this.processor);
                    o = this.process.getInputStream();
                    e = this.process.getErrorStream();
                }
                catch (Throwable ex) {
                    X_Log.error((Object[])new Object[]{this.getClass(), "Could not start command " + this.command.commands(), ex});
                    this.err.onError(ex);
                }
                stdOut = o;
                stdErr = e;
            } else {
                stdOut = null;
                stdErr = null;
                X_Log.warn((Object[])new Object[]{this.getClass(), "Shell command " + this.command.commands() + " has already been started."});
            }
            this.notifyAll();
        }
        if (stdOut != null) {
            this.onStdOut.onStart();
            this.onStdErr.onStart();
            HasLiveness check = new HasLiveness(){

                public boolean isAlive() {
                    return !ShellSessionDefault.this.finished;
                }
            };
            X_IO.drain((LogLevel)LogLevel.TRACE, (InputStream)stdOut, (StringReader)this.onStdOut, (HasLiveness)check);
            X_IO.drain((LogLevel)LogLevel.ERROR, (InputStream)stdErr, (StringReader)this.onStdErr, (HasLiveness)check);
        }
        this.join();
        this.drainStreams();
        if (this.status != 0) {
            if (this.callback instanceof ErrorHandler) {
                ((ErrorHandler)this.callback).onError((Throwable)new RuntimeException("Exit status " + this.status + " for " + this.command.commands));
            }
            X_Log.error((Object[])new Object[]{"Exit status", this.status, "for ", this.command.commands});
        }
        this.destroy();
        shellSessionDefault = this;
        synchronized (shellSessionDefault) {
            this.notifyAll();
        }
    }

    @Override
    public double birth() {
        return this.birth.millis();
    }

    @Override
    public ShellCommand parent() {
        return this.command;
    }

    @Override
    public int pid() {
        return 0;
    }

    @Override
    public int block(final int i, final TimeUnit seconds) {
        final Thread waiting = Thread.currentThread();
        X_Process.newThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ShellSessionDefault shellSessionDefault = ShellSessionDefault.this;
                synchronized (shellSessionDefault) {
                    try {
                        ShellSessionDefault.this.wait(seconds.toMillis(i), 0);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        waiting.interrupt();
                        return;
                    }
                }
                if (ShellSessionDefault.this.status == null) {
                    waiting.interrupt();
                }
            }
        }).start();
        return this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int join() {
        block38: {
            block35: {
                int n;
                block34: {
                    if (this.status != null) {
                        return this.status;
                    }
                    if (this.process != null) break block34;
                    ShellSessionDefault shellSessionDefault = this;
                    synchronized (shellSessionDefault) {
                        if (this.process == null) {
                            this.wait(10000L);
                        }
                    }
                    if (this.status == null) break block34;
                    int n2 = this.status;
                    X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
                    if (this.status == null) {
                        this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                        X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
                    }
                    if (this.status == 126) {
                        X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                        X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                        for (String command : this.command.commands.forEach()) {
                            File f = new File(command);
                            if (!f.exists() || f.canExecute()) continue;
                            X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                        }
                    }
                    this.finished = true;
                    this.drainStreams();
                    return n2;
                }
                try {
                    if (this.process == null) {
                        X_Log.warn((Object[])new Object[]{this.getClass(), "Process failed to start after " + X_Time.difference((Moment)this.birth)});
                        break block35;
                    }
                    X_Log.trace((Object[])new Object[]{this.getClass(), "Joining process", this.process, "after", X_Time.difference((Moment)this.birth), "uptime"});
                    X_Log.debug((Object[])new Object[]{this.getClass(), "Joining from", new Throwable()});
                    this.status = this.process.waitFor();
                    n = this.status;
                }
                catch (InterruptedException e) {
                    block36: {
                        X_Log.info((Object[])new Object[]{this.getClass(), "Interrupted while joining process", this.process});
                        this.finished = true;
                        if (!this.normalCompletion) break block36;
                        this.status = 0;
                        int command = this.status;
                        this.destroy();
                        X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
                        if (this.status == null) {
                            this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                            X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
                        }
                        if (this.status == 126) {
                            X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                            X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                            for (String command2 : this.command.commands.forEach()) {
                                File f = new File(command2);
                                if (!f.exists() || f.canExecute()) continue;
                                X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                            }
                        }
                        this.finished = true;
                        this.drainStreams();
                        return command;
                    }
                    try {
                        block37: {
                            this.status = -1;
                            break block37;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            finally {
                                this.destroy();
                            }
                        }
                        this.err.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
                        if (this.status == null) {
                            this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                            X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
                        }
                        if (this.status == 126) {
                            X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                            X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                            for (String command : this.command.commands.forEach()) {
                                File f = new File(command);
                                if (!f.exists() || f.canExecute()) continue;
                                X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                            }
                        }
                        this.finished = true;
                        this.drainStreams();
                        throw throwable;
                    }
                    X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
                    if (this.status == null) {
                        this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                        X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
                    }
                    if (this.status == 126) {
                        X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                        X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                        for (String command : this.command.commands.forEach()) {
                            File f = new File(command);
                            if (!f.exists() || f.canExecute()) continue;
                            X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                        }
                    }
                    this.finished = true;
                    this.drainStreams();
                    break block38;
                }
                X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
                if (this.status == null) {
                    this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                    X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
                }
                if (this.status == 126) {
                    X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                    X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                    for (String command : this.command.commands.forEach()) {
                        File f = new File(command);
                        if (!f.exists() || f.canExecute()) continue;
                        X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                    }
                }
                this.finished = true;
                this.drainStreams();
                return n;
            }
            X_Log.trace((Object[])new Object[]{this.getClass(), "Joined process", this.process, "after", X_Time.difference((Moment)this.birth), " uptime"});
            if (this.status == null) {
                this.status = this.process == null ? ShellCommand.STATUS_FAILED : Integer.valueOf(this.process.exitValue());
                X_Log.warn((Object[])new Object[]{this.getClass(), "Process did not exit normally; status:", this.status});
            }
            if (this.status == 126) {
                X_Log.warn((Object[])new Object[]{this.getClass(), "The script you are trying to run requires chmod +x\n", this.command.commands});
                X_Log.info((Object[])new Object[]{this.getClass(), "Attempting to make files executable"});
                for (String command : this.command.commands.forEach()) {
                    File f = new File(command);
                    if (!f.exists() || f.canExecute()) continue;
                    X_Log.info((Object[])new Object[]{this.getClass(), "Setting file", f, "to be executable.  Result: ", f.setExecutable(true, false)});
                }
            }
            this.finished = true;
            this.drainStreams();
        }
        return this.status;
    }

    @Override
    public void destroy() {
        if (this.status == null) {
            this.status = ShellCommandDefault.STATUS_DESTROYED;
        }
        this.finished = true;
        X_Time.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ShellSessionDefault.this.onStdOut.onEnd();
                ShellSessionDefault.this.onStdErr.onEnd();
            }
        });
        this.finish();
    }

    protected void drainStreams() {
        try {
            X_Log.trace((Object[])new Object[]{this.getClass(), "Process ended; Waiting for stdErr"});
            this.onStdErr.waitToEnd();
            X_Log.trace((Object[])new Object[]{this.getClass(), "Blocking on stdOut"});
            this.onStdOut.waitToEnd();
            X_Log.trace((Object[])new Object[]{this.getClass(), "Done"});
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish() {
        boolean shouldRun = false;
        RunOnce runOnce = this.once;
        synchronized (runOnce) {
            for (RemovalHandler clear : this.clears.forEach()) {
                clear.remove();
            }
            this.clears.clear();
            shouldRun = this.status == 0 && this.once.shouldRun(false);
        }
        if (shouldRun && this.callback != null) {
            this.callback.onSuccess((Object)this);
        }
    }

    @Override
    public boolean isRunning() {
        return this.command == null ? false : this.status == null;
    }

    @Override
    public Future<Integer> exitStatus() {
        return new FutureCommand<Integer>(){

            @Override
            protected Integer getValue() {
                return ShellSessionDefault.this.join();
            }
        };
    }

    @Override
    public ShellSessionDefault stdOut(LineReader stdReader) {
        this.onStdOut.forwardTo(stdReader);
        return this;
    }

    @Override
    public ShellSessionDefault stdErr(LineReader errReader) {
        this.onStdErr.forwardTo(errReader);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stdIn(String string) {
        if (!this.isRunning()) {
            throw new IllegalStateException("The command " + this.command.commands() + " is not running to receive " + "your input of " + string);
        }
        boolean immediate = this.stdIns.isEmpty();
        this.stdIns.give((Object)string);
        if (immediate) {
            Fifo<String> fifo = this.stdIns;
            synchronized (fifo) {
                if (this.out == null) {
                    this.out = new PipeOut();
                    X_Process.newThread((Runnable)this.out).start();
                } else {
                    this.out.ping();
                }
            }
        } else if (this.out == null) {
            X_Log.error((Object[])new Object[]{this.getClass(), "Attempting to send message to closed process, ", string, "will be ignored"});
        } else {
            this.out.ping();
        }
        return immediate;
    }

    abstract class FutureCommand<T>
    implements Future<T>,
    RemovalHandler {
        Thread waiting;

        FutureCommand() {
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            ShellSessionDefault.this.join();
            return this.getValue();
        }

        public void remove() {
            if (this.waiting != null && ShellSessionDefault.this.isRunning()) {
                this.waiting.interrupt();
                this.waiting = null;
                ShellSessionDefault.this.clears.remove((Object)this);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            assert (this.waiting == null || this.waiting == Thread.currentThread()) : "Should not make more than one thread wait on a process at once.";
            this.waiting = Thread.currentThread();
            ShellSessionDefault.this.clears.give((Object)this);
            X_Process.runTimeout((Runnable)new Runnable(){

                @Override
                public void run() {
                    FutureCommand.this.remove();
                }
            }, (int)((int)unit.toMillis(timeout)));
            ShellSessionDefault.this.join();
            return this.getValue();
        }

        protected abstract T getValue();

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                ShellSessionDefault.this.destroy();
            }
            finally {
                if (this.waiting != null) {
                    this.waiting.interrupt();
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            return ShellCommandDefault.STATUS_DESTROYED.equals(ShellSessionDefault.this.status);
        }

        @Override
        public boolean isDone() {
            return !ShellSessionDefault.this.isRunning();
        }
    }

    class PipeOut
    implements Runnable {
        private final Pointer<Boolean> blocking = new Pointer((Object)false);
        private long timeout = 50L;
        OutputStream os;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ping() {
            if (((Boolean)this.blocking.get()).booleanValue()) {
                return;
            }
            Pointer<Boolean> pointer = this.blocking;
            synchronized (pointer) {
                this.blocking.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            X_Log.info((Object[])new Object[]{this.getClass(), "Running process", ((ShellSessionDefault)ShellSessionDefault.this).command.commands});
            try {
                while (ShellSessionDefault.this.isRunning()) {
                    if (ShellSessionDefault.this.stdIns.isEmpty() || ShellSessionDefault.this.process == null) {
                        X_Log.debug((Object[])new Object[]{this.getClass(), "Waiting until process finishes"});
                        Pointer<Boolean> pointer = this.blocking;
                        synchronized (pointer) {
                            if ((this.timeout += 50L) > 5000L) {
                                this.timeout = 2000L;
                            }
                            this.blocking.set((Object)false);
                            try {
                                this.blocking.wait(this.timeout);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                X_Log.error((Object[])new Object[]{this.getClass(), "Shell command $" + ShellSessionDefault.this.command.commands() + " thread interrupted; bailing now."});
                                // MONITOREXIT @DISABLED, blocks:[0, 18, 7, 8, 13] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                                ShellSessionDefault.this.out = null;
                                X_Log.info((Object[])new Object[]{this.getClass(), "Finished process", ((ShellSessionDefault)ShellSessionDefault.this).command.commands});
                                return;
                            }
                        }
                    }
                    this.timeout = 50L;
                    try {
                        this.blocking.set((Object)true);
                        String line = (String)ShellSessionDefault.this.stdIns.take();
                        X_Log.trace((Object[])new Object[]{this.getClass(), "Sending command to process stdIn", line});
                        try {
                            if (this.os == null) {
                                this.os = ShellSessionDefault.this.process.getOutputStream();
                            }
                            if (this.os == null) {
                                X_Log.warn((Object[])new Object[]{this.getClass(), "Null output stream  for " + ((ShellSessionDefault)ShellSessionDefault.this).command.commands});
                                continue;
                            }
                            this.os.write((line + "\n").getBytes());
                            this.os.flush();
                        }
                        catch (IOException e) {
                            X_Log.warn((Object[])new Object[]{this.getClass(), "Command ", ShellSessionDefault.this.command.commands(), " received IO error sending ", line, "\n", e});
                        }
                    }
                    finally {
                        this.blocking.set((Object)false);
                    }
                }
                if (!ShellSessionDefault.this.stdIns.isEmpty()) {
                    X_Log.warn((Object[])new Object[]{this.getClass(), "Ended command " + ShellSessionDefault.this.command.commands() + " while stdIn still had data in the buffer:"});
                    X_Log.warn((Object[])new Object[]{ShellSessionDefault.this.stdIns.join(" -- ")});
                    ShellSessionDefault.this.destroy();
                }
                ShellSessionDefault.this.out = null;
            }
            catch (Throwable throwable) {
                ShellSessionDefault.this.out = null;
                X_Log.info((Object[])new Object[]{this.getClass(), "Finished process", ((ShellSessionDefault)ShellSessionDefault.this).command.commands});
                throw throwable;
            }
            X_Log.info((Object[])new Object[]{this.getClass(), "Finished process", ((ShellSessionDefault)ShellSessionDefault.this).command.commands});
            ShellSessionDefault.this.status = ShellSessionDefault.this.process.exitValue();
        }
    }
}

