/*
 * Decompiled with CFR 0.152.
 */
package xapi.shell.impl;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.SingletonDefault;
import xapi.file.X_File;
import xapi.inject.X_Inject;
import xapi.io.api.LineReader;
import xapi.log.X_Log;
import xapi.shell.api.ShellCommand;
import xapi.shell.api.ShellSession;
import xapi.shell.service.ShellService;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_GC;
import xapi.util.api.SuccessHandler;

@InstanceDefault(implFor=ShellService.class)
@SingletonDefault(implFor=ShellService.class)
public class ShellServiceDefault
implements ShellService {
    private static final Queue<ShellSession> runningShells;

    @Override
    public ShellCommand newCommand(String ... cmds) {
        return ((ShellCommand)X_Inject.instance(ShellCommand.class)).commands(cmds);
    }

    @Override
    public ShellSession runInShell(final boolean keepAlive, LineReader stdOut, LineReader stdErr, final String ... cmds) {
        String[] commands;
        final Moment start = X_Time.now();
        if (keepAlive) {
            String sh = X_File.unzippedResourcePath((String)"xapi/sh.sh", null);
            commands = new String[]{"sh", "-ac", sh};
        } else {
            commands = cmds;
        }
        final ShellSession runningShell = ((ShellCommand)X_Inject.instance(ShellCommand.class)).commands(commands).run(new SuccessHandler<ShellSession>(){

            public void onSuccess(ShellSession t) {
                X_Log.trace((Object[])new Object[]{this.getClass(), "Shell still running?", t.isRunning()});
            }
        }, null);
        X_Log.debug((Object[])new Object[]{this.getClass(), "Time create shell command", X_Time.difference((Moment)start)});
        if (stdOut != null) {
            runningShell.stdOut(stdOut);
        }
        if (stdErr != null) {
            runningShell.stdErr(stdErr);
        }
        X_Time.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (keepAlive) {
                    for (String cmd : cmds) {
                        runningShell.stdIn(cmd);
                    }
                }
                X_Log.debug((Object[])new Object[]{this.getClass(), "Time to send shell command", X_Time.difference((Moment)start)});
                X_Time.trySleep((int)0, (int)1000);
                ShellServiceDefault.this.runCleanup();
            }
        });
        return runningShell;
    }

    protected void runCleanup() {
        Iterator iter = runningShells.iterator();
        while (iter.hasNext()) {
            ShellSession next = (ShellSession)iter.next();
            if (next.isRunning()) continue;
            X_Log.trace((Object[])new Object[]{this.getClass(), "Recycle shell that is no longer running", next});
            X_GC.destroy(ShellSession.class, (Object)next);
            iter.remove();
        }
    }

    static {
        new Thread(){
            {
                Runtime.getRuntime().addShutdownHook(this);
            }

            @Override
            public void run() {
                while (!runningShells.isEmpty()) {
                    ((ShellSession)runningShells.remove()).destroy();
                }
            }
        };
        runningShells = new ConcurrentLinkedQueue<ShellSession>();
    }
}

