/*
 * Decompiled with CFR 0.152.
 */
package xapi.shell.impl;

import java.io.File;
import java.io.IOException;
import xapi.annotation.inject.InstanceDefault;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.file.X_File;
import xapi.log.X_Log;
import xapi.process.X_Process;
import xapi.shell.api.ArgumentProcessor;
import xapi.shell.api.ShellCommand;
import xapi.shell.api.ShellSession;
import xapi.shell.impl.ShellSessionDefault;
import xapi.util.X_Debug;
import xapi.util.api.ErrorHandler;
import xapi.util.api.SuccessHandler;

@InstanceDefault(implFor=ShellCommand.class)
public class ShellCommandDefault
implements ShellCommand {
    final Fifo<String> commands = X_Collect.newFifo();
    private String owner = "User";
    private String directory;

    public ShellCommandDefault() {
    }

    public ShellCommandDefault(String owner, String ... cmds) {
        this();
        this.owner = owner;
        for (String cmd : cmds) {
            this.commands.give((Object)cmd);
        }
    }

    @Override
    public String owner() {
        return this.owner;
    }

    @Override
    public String directory() {
        if (this.directory == null) {
            File dir = X_File.createTempDir((String)("exeFor" + this.owner), (boolean)true);
            this.directory = dir == null ? "." : (dir.exists() || dir.mkdirs() ? dir.getPath() : ".");
        }
        return this.directory;
    }

    @Override
    public Fifo<String> commands() {
        return this.commands;
    }

    @Override
    public ShellCommand directory(String directory) {
        this.directory = directory;
        return this;
    }

    @Override
    public ShellCommand owner(String owner) {
        if (owner != null) {
            return this;
        }
        this.owner = owner;
        return this;
    }

    @Override
    public ShellCommand commands(String ... cmds) {
        for (String cmd : cmds) {
            this.commands.give((Object)cmd);
        }
        return this;
    }

    @Override
    public ShellSession run(SuccessHandler<ShellSession> callback, ArgumentProcessor processor) {
        ErrorHandler err = callback instanceof ErrorHandler ? (ErrorHandler)callback : X_Debug.defaultHandler();
        ShellSessionDefault result = new ShellSessionDefault(this, processor, callback, (ErrorHandler<Throwable>)err);
        X_Process.newThread((Runnable)result).start();
        return result;
    }

    protected Process doRun(ArgumentProcessor processor) throws IOException {
        if (processor == null) {
            processor = ArgumentProcessor.NO_OP;
        }
        ProcessBuilder pb = new ProcessBuilder((String[])(processor == null ? ArgumentProcessor.NO_OP : processor).convert(this.commands.forEach()));
        File dir = new File(this.directory()).getCanonicalFile();
        if (dir.exists()) {
            pb.directory(dir);
        } else {
            X_Log.error((Object[])new Object[]{this.getClass(), "Process run directory " + dir.getCanonicalPath() + " does not exist " + "for "});
        }
        return pb.start();
    }
}

