/*
 * Decompiled with CFR 0.152.
 */
package xapi.shell;

import java.io.File;
import java.net.URL;
import xapi.inject.X_Inject;
import xapi.io.api.HasLiveness;
import xapi.io.api.LineReader;
import xapi.io.api.StringReader;
import xapi.log.X_Log;
import xapi.shell.api.ShellSession;
import xapi.shell.service.ShellService;
import xapi.util.X_Properties;
import xapi.util.X_String;

public class X_Shell {
    private static String[] args;
    private static Class<?> main;

    private X_Shell() {
    }

    public static ShellService newService() {
        return (ShellService)X_Inject.instance(ShellService.class);
    }

    public static ShellService globalService() {
        return (ShellService)X_Inject.singleton(ShellService.class);
    }

    public static HasLiveness liveChecker(final Process process) {
        return new HasLiveness(){

            public boolean isAlive() {
                try {
                    int exit = process.exitValue();
                    X_Log.debug((Object[])new Object[]{"Process ended with exit code " + exit});
                    return false;
                }
                catch (IllegalThreadStateException e) {
                    return true;
                }
            }
        };
    }

    public static void rememberArgs(Class<?> mainClass, String ... args) {
        X_Shell.args = args;
        main = mainClass;
    }

    public static ShellSession launchJava(Class<?> mainClass, String[] classpath) {
        return X_Shell.launchJava(mainClass, classpath, new String[0], new String[0]);
    }

    public static ShellSession launchJava(Class<?> mainClass, String[] classpath, String[] vmFlags, String[] args) {
        block6: {
            try {
                boolean isJar;
                URL loc = mainClass.getProtectionDomain().getCodeSource().getLocation();
                boolean bl = isJar = loc.getProtocol().equals("jar") || loc.toExternalForm().contains("jar!");
                if (!isJar) break block6;
                String jar = loc.toExternalForm().replace("jar:", "").split("jar!")[0] + ".jar";
                for (String item : classpath) {
                    if (!item.equals(jar)) {
                        continue;
                    }
                    break block6;
                }
                String[] newClasspath = new String[classpath.length + 1];
                System.arraycopy(classpath, 0, newClasspath, 0, classpath.length);
                newClasspath[classpath.length] = jar;
                classpath = newClasspath;
            }
            catch (Exception e) {
                X_Log.warn((Object[])new Object[]{ShellSession.class, "Error appending location of ", mainClass, "to classpath", classpath, e});
            }
        }
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String[] javaArgs = new String[4 + vmFlags.length + args.length];
        javaArgs[0] = javaBin;
        int pos = 1;
        if (vmFlags != null && vmFlags.length > 0) {
            System.arraycopy(vmFlags, 0, javaArgs, pos, vmFlags.length);
            pos += vmFlags.length;
        }
        javaArgs[pos] = "-classpath";
        javaArgs[++pos] = X_String.join((String)File.pathSeparator, (String[])classpath).trim();
        javaArgs[++pos] = mainClass.getCanonicalName();
        X_Log.info((Object[])new Object[]{X_Shell.class, "Running java command", mainClass, args});
        if (args != null && args.length > 0) {
            System.arraycopy(args, 0, javaArgs, ++pos, args.length);
        }
        X_Log.info((Object[])new Object[]{X_Shell.class, "Java command", X_String.join((String)" ", (String[])javaArgs)});
        return X_Shell.globalService().runInShell(false, (LineReader)new StringReader(), (LineReader)new StringReader(), javaArgs);
    }

    public static ShellSession launchInShell(String cmd, LineReader stdOut, LineReader stdErr) {
        X_Log.trace((Object[])new Object[]{X_Shell.class, "Running in shell\n", cmd});
        return X_Shell.globalService().runInShell(false, stdOut, stdErr, cmd);
    }

    public static void restartSelf() {
        if (main == null) {
            X_Log.error((Object[])new Object[]{"Cannot use restartSelf until calling rememberArgs(Class<?> mainClass, String[] args)"});
            return;
        }
        String[] arguments = args == null ? new String[]{} : args;
        String cp = X_Properties.getProperty((String)"java.class.path");
        if (cp == null) {
            X_Log.error((Object[])new Object[]{"Unable to detect X_Property 'java.class.path'; unable to restart application"});
            return;
        }
        X_Shell.launchJava(main, cp.split("[" + File.pathSeparator + "]"), new String[0], arguments);
    }
}

