/*
 * Decompiled with CFR 0.152.
 */
package xapi.mvn.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import xapi.annotation.inject.SingletonDefault;
import xapi.collect.impl.AbstractMultiInitMap;
import xapi.dev.resource.impl.StringDataResource;
import xapi.dev.scanner.X_Scanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.inject.impl.SingletonInitializer;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.mvn.service.MvnService;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_Debug;
import xapi.util.X_String;
import xapi.util.X_Util;

@SingletonDefault(implFor=MvnService.class)
public class MvnServiceDefault
implements MvnService {
    private static final Pattern POM_PATTERN = Pattern.compile(".*pom.*xml");
    protected final DefaultServiceLocator maven = MavenRepositorySystemUtils.newServiceLocator();
    protected final SingletonInitializer<RepositorySystem> repoSystem = new SingletonInitializer<RepositorySystem>(){

        protected RepositorySystem initialValue() {
            MvnServiceDefault.this.maven.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            MvnServiceDefault.this.maven.addService(TransporterFactory.class, FileTransporterFactory.class);
            MvnServiceDefault.this.maven.addService(TransporterFactory.class, HttpTransporterFactory.class);
            return (RepositorySystem)MvnServiceDefault.this.maven.getService(RepositorySystem.class);
        }
    };
    protected final SingletonInitializer<RepositorySystemSession> session = new SingletonInitializer<RepositorySystemSession>(){

        protected RepositorySystemSession initialValue() {
            return MvnServiceDefault.this.initLocalRepo();
        }
    };
    private LogLevel logLevel = LogLevel.INFO;
    private final ResourceMap loaded = new ResourceMap();

    @Override
    public RepositorySystemSession getRepoSession() {
        return (RepositorySystemSession)this.session.get();
    }

    @Override
    public ArtifactResult loadArtifact(String groupId, String artifactId, String version) {
        return this.loadArtifact(groupId, artifactId, "", "jar", version);
    }

    @Override
    public ArtifactResult loadArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        ArtifactResult artifactResult;
        Moment before = X_Time.now();
        RepositorySystem repoSystem = (RepositorySystem)this.repoSystem.get();
        RepositorySystemSession session = (RepositorySystemSession)this.session.get();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, X_String.isEmpty((String)extension) ? "jar" : extension, version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.remoteRepos(), null);
            artifactResult = repoSystem.resolveArtifact(session, request);
        }
        catch (ArtifactResolutionException e) {
            try {
                X_Log.log(this.getClass(), (LogLevel)this.getLogLevel(), (Object[])new Object[]{"Resolved? ", e.getResult().isResolved(), e.getResult().getExceptions()});
                X_Log.log(this.getClass(), (LogLevel)this.getLogLevel(), (Object[])new Object[]{"Could not download " + artifact, e});
                throw X_Debug.rethrow((Throwable)e);
            }
            catch (Throwable throwable) {
                if (X_Log.loggable((LogLevel)LogLevel.DEBUG)) {
                    X_Log.debug((Object[])new Object[]{"Resolved: " + artifact.toString() + " in " + X_Time.difference((Moment)before)});
                }
                throw throwable;
            }
        }
        if (X_Log.loggable((LogLevel)LogLevel.DEBUG)) {
            X_Log.debug((Object[])new Object[]{"Resolved: " + artifact.toString() + " in " + X_Time.difference((Moment)before)});
        }
        return artifactResult;
    }

    @Override
    public LocalArtifactResult loadLocalArtifact(String groupId, String artifactId, String version) {
        return this.loadLocalArtifact(groupId, artifactId, "", "jar", version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalArtifactResult loadLocalArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        LocalArtifactResult localArtifactResult;
        Moment before = X_Time.now();
        RepositorySystemSession session = (RepositorySystemSession)this.session.get();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, X_String.isEmpty((String)extension) ? "jar" : extension, version);
        try {
            LocalArtifactRequest request = new LocalArtifactRequest((Artifact)artifact, null, null);
            localArtifactResult = session.getLocalRepositoryManager().find(session, request);
        }
        catch (Throwable throwable) {
            if (X_Log.loggable((LogLevel)LogLevel.DEBUG)) {
                X_Log.debug((Object[])new Object[]{"Resolved: " + artifact.toString() + " in " + X_Time.difference((Moment)before)});
            }
            throw throwable;
        }
        if (X_Log.loggable((LogLevel)LogLevel.DEBUG)) {
            X_Log.debug((Object[])new Object[]{"Resolved: " + artifact.toString() + " in " + X_Time.difference((Moment)before)});
        }
        return localArtifactResult;
    }

    protected LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    protected RepositorySystemSession initLocalRepo() {
        File maybeUse;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        String userHome = System.getProperty("user.home");
        String path = "target/local-repo";
        if (userHome != null && (maybeUse = new File(userHome, ".m2/repository")).exists()) {
            path = maybeUse.getAbsolutePath();
        }
        LocalRepository localRepo = new LocalRepository(path);
        localRepo.getBasedir().mkdirs();
        session.setLocalRepositoryManager(((RepositorySystem)this.repoSystem.get()).newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    @Override
    public Model loadPomFile(String pomLocation) throws IOException, XmlPullParserException {
        File pomfile = new File(pomLocation);
        FileReader reader = null;
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        reader = new FileReader(pomfile);
        Model model = mavenreader.read((Reader)reader);
        model.setPomFile(pomfile);
        return model;
    }

    @Override
    public Model loadPomString(String pomString) throws XmlPullParserException {
        try {
            return new MavenXpp3Reader().read((Reader)new StringReader(pomString));
        }
        catch (IOException ignored) {
            throw X_Util.rethrow((Throwable)ignored);
        }
    }

    @Override
    public String mvnHome() {
        return System.getenv("M2_HOME");
    }

    @Override
    public String localRepo() {
        return ((RepositorySystemSession)this.session.get()).getLocalRepository().getBasedir().getAbsolutePath();
    }

    @Override
    public List<RemoteRepository> remoteRepos() {
        return Arrays.asList(new RemoteRepository.Builder("maven-central", "default", "http://repo1.maven.org/maven2/").build());
    }

    @Override
    public Iterable<Model> findPoms(ClassLoader loader) {
        final Iterable poms = ((ClasspathResourceMap)this.loaded.get(loader.hashCode(), loader)).findResources("", new Pattern[]{POM_PATTERN});
        return new Iterable<Model>(){

            @Override
            public Iterator<Model> iterator() {
                class Itr
                implements Iterator<Model> {
                    Iterator<StringDataResource> iterator;
                    final /* synthetic */ Iterable val$poms;

                    Itr() {
                        this.val$poms = iterable;
                        this.iterator = this.val$poms.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Model next() {
                        StringDataResource next = this.iterator.next();
                        try {
                            return MvnServiceDefault.this.loadPomString(next.readAll());
                        }
                        catch (Exception e) {
                            X_Log.error((Object[])new Object[]{"Unable to load resouce " + next.getResourceName(), e});
                            throw X_Util.rethrow((Throwable)e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(MvnServiceDefault.this, poms);
            }
        };
    }

    private final class ResourceMap
    extends AbstractMultiInitMap<Integer, ClasspathResourceMap, ClassLoader> {
        public ResourceMap() {
            super(TO_STRING);
        }

        protected ClasspathResourceMap initialize(Integer key, ClassLoader params) {
            return X_Scanner.scanClassloader((ClassLoader)params);
        }
    }
}

