/*
 * Decompiled with CFR 0.152.
 */
package xapi.mvn;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import xapi.bytecode.impl.BytecodeAdapterService;
import xapi.dev.X_Dev;
import xapi.dev.scanner.X_Scanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.inject.X_Inject;
import xapi.inject.impl.SingletonProvider;
import xapi.log.X_Log;
import xapi.mvn.service.MvnService;
import xapi.util.X_Debug;
import xapi.util.X_Runtime;
import xapi.util.X_String;

public class X_Maven {
    private static final MvnService service = (MvnService)X_Inject.singleton(MvnService.class);

    public static Model loadPom(String fileLocation) {
        try {
            return service.loadPomFile(fileLocation);
        }
        catch (Exception e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    public static Model loadPomString(String pomString) {
        try {
            return service.loadPomString(pomString);
        }
        catch (Exception e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    public static List<RemoteRepository> remoteRepos() {
        return service.remoteRepos();
    }

    public static MvnService getMavenService() {
        return service;
    }

    public static ArtifactResult loadArtifact(String groupId, String artifactId, String version) {
        return X_Maven.loadArtifact(groupId, artifactId, "jar", version);
    }

    public static ArtifactResult loadArtifact(String groupId, String artifactId, String extension, String version) {
        return X_Maven.loadArtifact(groupId, artifactId, "", extension, version);
    }

    public static ArtifactResult loadArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        return service.loadArtifact(groupId, artifactId, classifier, extension, version);
    }

    public static LocalArtifactResult loadLocalArtifact(String groupId, String artifactId, String version) {
        return X_Maven.loadLocalArtifact(groupId, artifactId, "jar", version);
    }

    public static LocalArtifactResult loadLocalArtifact(String groupId, String artifactId, String extension, String version) {
        return X_Maven.loadLocalArtifact(groupId, artifactId, "", extension, version);
    }

    public static LocalArtifactResult loadLocalArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        return service.loadLocalArtifact(groupId, artifactId, classifier, extension, version);
    }

    public static String toDescriptor(Model model, boolean verbose) {
        String artifactId = model.getArtifactId();
        assert (artifactId != null) : "Null artifactId for " + model;
        String version = model.getVersion();
        if (version == null) {
            version = model.getParent().getVersion();
        }
        assert (version != null) : "No version for " + model;
        if (verbose) {
            String groupId = model.getGroupId();
            if (groupId == null) {
                groupId = model.getParent().getGroupId();
            }
            assert (groupId != null) : "Null groupId for " + model.getArtifactId();
            return groupId + ":" + artifactId + ":" + version;
        }
        return artifactId + ":" + version;
    }

    public static ClasspathResourceMap compileScopeScanner(MavenProject project, MavenSession session) {
        URL[] urls = X_Maven.compileScopeUrls(project, session);
        X_Log.trace((Object[])new Object[]{X_Maven.class, "Compile scope URLS", urls});
        return X_Scanner.scanClassloader((ClassLoader)URLClassLoader.newInstance(urls));
    }

    public static URL[] compileScopeUrls(MavenProject project, MavenSession session) {
        try {
            List compile = project.getCompileClasspathElements();
            X_Log.info((Object[])new Object[]{X_Maven.class, "Compile classpath", compile});
            X_Log.info((Object[])new Object[]{X_Maven.class, "Runtime classpath", project.getRuntimeClasspathElements()});
            if (project.hasLifecyclePhase("test-classes")) {
                List testElements = project.getTestClasspathElements();
                testElements.addAll(compile);
                compile = testElements;
            }
            URL[] urls = new URL[compile.size()];
            int i = compile.size();
            while (i-- > 0) {
                urls[i] = X_Dev.toUrl((String)((String)compile.get(i)));
            }
            return urls;
        }
        catch (DependencyResolutionRequiredException e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    public static BytecodeAdapterService compileScopeAdapter(MavenProject project, MavenSession session) {
        return new CompileScopeBytecodeAdapter(project, session);
    }

    private static class CompileScopeBytecodeAdapter
    extends BytecodeAdapterService {
        private final URL[] urls;
        private final SingletonProvider<ClassLoader> cl = new SingletonProvider<ClassLoader>(){

            protected ClassLoader initialValue() {
                if (X_Runtime.isDebug()) {
                    X_Log.info((Object[])new Object[]{"Maven compile scope: " + X_String.joinObjects((Object[])CompileScopeBytecodeAdapter.this.urls)});
                }
                return new URLClassLoader(CompileScopeBytecodeAdapter.this.urls, X_Maven.class.getClassLoader());
            }
        };

        public CompileScopeBytecodeAdapter(MavenProject project, MavenSession session) {
            this.urls = X_Maven.compileScopeUrls(project, session);
        }

        protected URL[] getScanUrls() {
            return this.urls;
        }

        protected ClassLoader getClassLoader() {
            return (ClassLoader)this.cl.get();
        }
    }
}

