/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    String name;

    SimpleLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void log(LogLevel level, String message, Throwable t) {
        if (!X_Log.loggable((LogLevel)level)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        long millis = System.currentTimeMillis();
        buf.append(millis - startTime);
        buf.append(" [");
        buf.append(level);
        buf.append("] ");
        buf.append(" {");
        buf.append(Thread.currentThread().getName());
        buf.append("} ");
        buf.append(level);
        buf.append(" ");
        buf.append(this.name);
        buf.append(" - ");
        buf.append(message);
        buf.append(LINE_SEPARATOR);
        System.err.print(buf.toString());
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.flush();
    }

    private void formatAndLog(LogLevel level, String format, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.log(level, message, null);
    }

    private void formatAndLog(LogLevel level, String format, Object[] argArray) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.log(level, message, null);
    }

    public boolean isDebugEnabled() {
        return X_Log.loggable((LogLevel)LogLevel.DEBUG);
    }

    public void debug(String msg) {
        this.log(LogLevel.INFO, msg, null);
    }

    public void debug(String format, Object arg) {
        this.formatAndLog(LogLevel.DEBUG, format, arg, null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.formatAndLog(LogLevel.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.formatAndLog(LogLevel.DEBUG, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(LogLevel.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return X_Log.loggable((LogLevel)LogLevel.INFO);
    }

    public void info(String msg) {
        this.log(LogLevel.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(LogLevel.INFO, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(LogLevel.INFO, format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.formatAndLog(LogLevel.INFO, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(LogLevel.INFO, msg, t);
    }

    public boolean isTraceEnabled() {
        return X_Log.loggable((LogLevel)LogLevel.TRACE);
    }

    public void trace(String msg) {
        this.log(LogLevel.TRACE, msg, null);
    }

    public void trace(String format, Object arg) {
        this.formatAndLog(LogLevel.TRACE, format, arg, null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.formatAndLog(LogLevel.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.formatAndLog(LogLevel.TRACE, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(LogLevel.TRACE, msg, t);
    }

    public boolean isWarnEnabled() {
        return X_Log.loggable((LogLevel)LogLevel.WARN);
    }

    public void warn(String msg) {
        this.log(LogLevel.WARN, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(LogLevel.WARN, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(LogLevel.WARN, format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.formatAndLog(LogLevel.WARN, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(LogLevel.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return X_Log.loggable((LogLevel)LogLevel.ERROR);
    }

    public void error(String msg) {
        this.log(LogLevel.ERROR, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(LogLevel.ERROR, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(LogLevel.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.formatAndLog(LogLevel.ERROR, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(LogLevel.ERROR, msg, t);
    }
}

