/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import xapi.bytecode.ConstPool;
import xapi.bytecode.Descriptor;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.util.X_Byte;

public class LocalVariableAttribute
extends AttributeInfo {
    public static final String tag = "LocalVariableTable";
    public static final String typeTag = "LocalVariableTypeTable";

    public LocalVariableAttribute(ConstPool cp) {
        super(cp, tag, new byte[2]);
        X_Byte.write16bit((int)0, (byte[])this.info, (int)0);
    }

    @Deprecated
    public LocalVariableAttribute(ConstPool cp, String name) {
        super(cp, name, new byte[2]);
        X_Byte.write16bit((int)0, (byte[])this.info, (int)0);
    }

    LocalVariableAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    LocalVariableAttribute(ConstPool cp, String name, byte[] i) {
        super(cp, name, i);
    }

    public void addEntry(int startPc, int length, int nameIndex, int descriptorIndex, int index) {
        int size = this.info.length;
        byte[] newInfo = new byte[size + 10];
        X_Byte.write16bit((int)(this.tableLength() + 1), (byte[])newInfo, (int)0);
        for (int i = 2; i < size; ++i) {
            newInfo[i] = this.info[i];
        }
        X_Byte.write16bit((int)startPc, (byte[])newInfo, (int)size);
        X_Byte.write16bit((int)length, (byte[])newInfo, (int)(size + 2));
        X_Byte.write16bit((int)nameIndex, (byte[])newInfo, (int)(size + 4));
        X_Byte.write16bit((int)descriptorIndex, (byte[])newInfo, (int)(size + 6));
        X_Byte.write16bit((int)index, (byte[])newInfo, (int)(size + 8));
        this.info = newInfo;
    }

    @Override
    void renameClass(String oldname, String newname) {
        ConstPool cp = this.getConstPool();
        int n = this.tableLength();
        for (int i = 0; i < n; ++i) {
            int pos = i * 10 + 2;
            int index = X_Byte.readU16bit((byte[])this.info, (int)(pos + 6));
            if (index == 0) continue;
            String desc = cp.getUtf8Info(index);
            desc = this.renameEntry(desc, oldname, newname);
            X_Byte.write16bit((int)cp.addUtf8Info(desc), (byte[])this.info, (int)(pos + 6));
        }
    }

    String renameEntry(String desc, String oldname, String newname) {
        return Descriptor.rename(desc, oldname, newname);
    }

    @Override
    void renameClass(Map<?, ?> classnames) {
        ConstPool cp = this.getConstPool();
        int n = this.tableLength();
        for (int i = 0; i < n; ++i) {
            int pos = i * 10 + 2;
            int index = X_Byte.readU16bit((byte[])this.info, (int)(pos + 6));
            if (index == 0) continue;
            String desc = cp.getUtf8Info(index);
            desc = this.renameEntry(desc, classnames);
            X_Byte.write16bit((int)cp.addUtf8Info(desc), (byte[])this.info, (int)(pos + 6));
        }
    }

    String renameEntry(String desc, Map<?, ?> classnames) {
        return Descriptor.rename(desc, classnames);
    }

    public void shiftIndex(int lessThan, int delta) {
        int size = this.info.length;
        for (int i = 2; i < size; i += 10) {
            int org = X_Byte.readU16bit((byte[])this.info, (int)(i + 8));
            if (org < lessThan) continue;
            X_Byte.write16bit((int)(org + delta), (byte[])this.info, (int)(i + 8));
        }
    }

    public int tableLength() {
        return X_Byte.readU16bit((byte[])this.info, (int)0);
    }

    public int startPc(int i) {
        return X_Byte.readU16bit((byte[])this.info, (int)(i * 10 + 2));
    }

    public int codeLength(int i) {
        return X_Byte.readU16bit((byte[])this.info, (int)(i * 10 + 4));
    }

    public void shiftPc(int where, int gapLength, boolean exclusive) {
        int n = this.tableLength();
        for (int i = 0; i < n; ++i) {
            int pos = i * 10 + 2;
            int pc = X_Byte.readU16bit((byte[])this.info, (int)pos);
            int len = X_Byte.readU16bit((byte[])this.info, (int)(pos + 2));
            if (pc > where || exclusive && pc == where && pc != 0) {
                X_Byte.write16bit((int)(pc + gapLength), (byte[])this.info, (int)pos);
                continue;
            }
            if (pc + len <= where && (!exclusive || pc + len != where)) continue;
            X_Byte.write16bit((int)(len + gapLength), (byte[])this.info, (int)(pos + 2));
        }
    }

    public int nameIndex(int i) {
        return X_Byte.readU16bit((byte[])this.info, (int)(i * 10 + 6));
    }

    public String variableName(int i) {
        return this.getConstPool().getUtf8Info(this.nameIndex(i));
    }

    public int descriptorIndex(int i) {
        return X_Byte.readU16bit((byte[])this.info, (int)(i * 10 + 8));
    }

    public int signatureIndex(int i) {
        return this.descriptorIndex(i);
    }

    public String descriptor(int i) {
        return this.getConstPool().getUtf8Info(this.descriptorIndex(i));
    }

    public String signature(int i) {
        return this.descriptor(i);
    }

    public int index(int i) {
        return X_Byte.readU16bit((byte[])this.info, (int)(i * 10 + 10));
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<?, ?> classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        LocalVariableAttribute attr = this.makeThisAttr(newCp, dest);
        int n = X_Byte.readU16bit((byte[])src, (int)0);
        X_Byte.write16bit((int)n, (byte[])dest, (int)0);
        int j = 2;
        for (int i = 0; i < n; ++i) {
            int start = X_Byte.readU16bit((byte[])src, (int)j);
            int len = X_Byte.readU16bit((byte[])src, (int)(j + 2));
            int name = X_Byte.readU16bit((byte[])src, (int)(j + 4));
            int type = X_Byte.readU16bit((byte[])src, (int)(j + 6));
            int index = X_Byte.readU16bit((byte[])src, (int)(j + 8));
            X_Byte.write16bit((int)start, (byte[])dest, (int)j);
            X_Byte.write16bit((int)len, (byte[])dest, (int)(j + 2));
            if (name != 0) {
                name = cp.copy(name, newCp, null);
            }
            X_Byte.write16bit((int)name, (byte[])dest, (int)(j + 4));
            if (type != 0) {
                String sig = cp.getUtf8Info(type);
                sig = Descriptor.rename(sig, classnames);
                type = newCp.addUtf8Info(sig);
            }
            X_Byte.write16bit((int)type, (byte[])dest, (int)(j + 6));
            X_Byte.write16bit((int)index, (byte[])dest, (int)(j + 8));
            j += 10;
        }
        return attr;
    }

    LocalVariableAttribute makeThisAttr(ConstPool cp, byte[] dest) {
        return new LocalVariableAttribute(cp, tag, dest);
    }
}

