/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.attributes;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import xapi.bytecode.ConstPool;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.util.X_Byte;

public class ExceptionsAttribute
extends AttributeInfo {
    public static final String tag = "Exceptions";

    ExceptionsAttribute(ConstPool cp, int n, DataInput in) throws IOException {
        super(cp, n, in);
    }

    private ExceptionsAttribute(ConstPool cp, ExceptionsAttribute src, Map<?, ?> classnames) {
        super(cp, tag);
        this.copyFrom(src, classnames);
    }

    public ExceptionsAttribute(ConstPool cp) {
        super(cp, tag);
        byte[] data = new byte[2];
        data[1] = 0;
        data[0] = 0;
        this.info = data;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<?, ?> classnames) {
        return new ExceptionsAttribute(newCp, this, classnames);
    }

    private void copyFrom(ExceptionsAttribute srcAttr, Map<?, ?> classnames) {
        ConstPool srcCp = srcAttr.constPool;
        ConstPool destCp = this.constPool;
        byte[] src = srcAttr.info;
        int num = src.length;
        byte[] dest = new byte[num];
        dest[0] = src[0];
        dest[1] = src[1];
        for (int i = 2; i < num; i += 2) {
            int index = X_Byte.readU16bit((byte[])src, (int)i);
            X_Byte.write16bit((int)srcCp.copy(index, destCp, classnames), (byte[])dest, (int)i);
        }
        this.info = dest;
    }

    public int[] getExceptionIndexes() {
        byte[] blist = this.info;
        int n = blist.length;
        if (n <= 2) {
            return null;
        }
        int[] elist = new int[n / 2 - 1];
        int k = 0;
        for (int j = 2; j < n; j += 2) {
            elist[k++] = (blist[j] & 0xFF) << 8 | blist[j + 1] & 0xFF;
        }
        return elist;
    }

    public String[] getExceptions() {
        byte[] blist = this.info;
        int n = blist.length;
        if (n <= 2) {
            return null;
        }
        String[] elist = new String[n / 2 - 1];
        int k = 0;
        for (int j = 2; j < n; j += 2) {
            int index = (blist[j] & 0xFF) << 8 | blist[j + 1] & 0xFF;
            elist[k++] = this.constPool.getClassInfo(index);
        }
        return elist;
    }

    public void setExceptionIndexes(int[] elist) {
        int n = elist.length;
        byte[] blist = new byte[n * 2 + 2];
        X_Byte.write16bit((int)n, (byte[])blist, (int)0);
        for (int i = 0; i < n; ++i) {
            X_Byte.write16bit((int)elist[i], (byte[])blist, (int)(i * 2 + 2));
        }
        this.info = blist;
    }

    public void setExceptions(String[] elist) {
        int n = elist.length;
        byte[] blist = new byte[n * 2 + 2];
        X_Byte.write16bit((int)n, (byte[])blist, (int)0);
        for (int i = 0; i < n; ++i) {
            X_Byte.write16bit((int)this.constPool.addClassInfo(elist[i]), (byte[])blist, (int)(i * 2 + 2));
        }
        this.info = blist;
    }

    public int tableLength() {
        return this.info.length / 2 - 1;
    }

    public int getException(int nth) {
        int index = nth * 2 + 2;
        return (this.info[index] & 0xFF) << 8 | this.info[index + 1] & 0xFF;
    }
}

