/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import xapi.bytecode.ClassPool;
import xapi.bytecode.ConstPool;
import xapi.bytecode.annotation.AnnotationsWriter;
import xapi.bytecode.annotation.MemberValue;
import xapi.bytecode.annotation.MemberValueVisitor;

public class ByteMemberValue
extends MemberValue {
    int valueIndex;

    public ByteMemberValue(int index, ConstPool cp) {
        super('B', cp);
        this.valueIndex = index;
    }

    public ByteMemberValue(byte b, ConstPool cp) {
        super('B', cp);
        this.setValue(b);
    }

    public ByteMemberValue(ConstPool cp) {
        super('B', cp);
        this.setValue((byte)0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Byte(this.getValue());
    }

    @Override
    public Class<?> getType(ClassLoader cl) {
        return Byte.TYPE;
    }

    public byte getValue() {
        return (byte)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(byte newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Byte.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitByteMemberValue(this);
    }
}

