/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.annotation;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import xapi.bytecode.ConstPool;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.AnnotationMemberValue;
import xapi.bytecode.annotation.AnnotationsWriter;
import xapi.bytecode.annotation.ArrayMemberValue;
import xapi.bytecode.annotation.BooleanMemberValue;
import xapi.bytecode.annotation.ByteMemberValue;
import xapi.bytecode.annotation.CharMemberValue;
import xapi.bytecode.annotation.ClassMemberValue;
import xapi.bytecode.annotation.DoubleMemberValue;
import xapi.bytecode.annotation.EnumMemberValue;
import xapi.bytecode.annotation.FloatMemberValue;
import xapi.bytecode.annotation.IntegerMemberValue;
import xapi.bytecode.annotation.LongMemberValue;
import xapi.bytecode.annotation.MemberValue;
import xapi.bytecode.annotation.ShortMemberValue;
import xapi.bytecode.annotation.StringMemberValue;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.util.X_Byte;

public class AnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleAnnotations";

    public AnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super(cp, attrname, info);
    }

    public AnnotationsAttribute(ConstPool cp, String attrname) {
        this(cp, attrname, new byte[]{0, 0});
    }

    public AnnotationsAttribute(ConstPool cp, int n, DataInput in) throws IOException {
        super(cp, n, in);
    }

    public int numAnnotations() {
        return X_Byte.readU16bit((byte[])this.info, (int)0);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<?, ?> classnames) {
        Copier copier = new Copier(this.info, this.constPool, newCp, classnames);
        try {
            copier.annotationArray();
            return new AnnotationsAttribute(newCp, this.getName(), copier.close());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Annotation getAnnotation(String type) {
        Annotation[] annotations = this.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].getTypeName().equals(type)) continue;
            return annotations[i];
        }
        return null;
    }

    public void addAnnotation(Annotation annotation) {
        String type = annotation.getTypeName();
        Annotation[] annotations = this.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].getTypeName().equals(type)) continue;
            annotations[i] = annotation;
            this.setAnnotations(annotations);
            return;
        }
        Annotation[] newlist = new Annotation[annotations.length + 1];
        System.arraycopy(annotations, 0, newlist, 0, annotations.length);
        newlist[annotations.length] = annotation;
        this.setAnnotations(newlist);
    }

    public Annotation[] getAnnotations() {
        try {
            return new Parser(this.info, this.constPool).parseAnnotations();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setAnnotations(Annotation[] annotations) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer = new AnnotationsWriter(output, this.constPool);
        try {
            int n = annotations.length;
            writer.numAnnotations(n);
            for (int i = 0; i < n; ++i) {
                annotations[i].write(writer);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.set(output.toByteArray());
    }

    public void setAnnotation(Annotation annotation) {
        this.setAnnotations(new Annotation[]{annotation});
    }

    public String toString() {
        Annotation[] a = this.getAnnotations();
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < a.length) {
            sbuf.append(a[i++].toString());
            if (i == a.length) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    public static class Parser
    extends Walker {
        ConstPool pool;
        Annotation[][] allParams;
        Annotation[] allAnno;
        Annotation currentAnno;
        MemberValue currentMember;

        public Parser(byte[] info, ConstPool cp) {
            super(info);
            this.pool = cp;
        }

        public Annotation[][] parseParameters() throws Exception {
            this.parameters();
            return this.allParams;
        }

        public Annotation[] parseAnnotations() throws Exception {
            this.annotationArray();
            return this.allAnno;
        }

        public MemberValue parseMemberValue() throws Exception {
            this.memberValue(0);
            return this.currentMember;
        }

        @Override
        public void parameters(int numParam, int pos) throws Exception {
            Annotation[][] params = new Annotation[numParam][];
            for (int i = 0; i < numParam; ++i) {
                pos = this.annotationArray(pos);
                params[i] = this.allAnno;
            }
            this.allParams = params;
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            Annotation[] array = new Annotation[num];
            for (int i = 0; i < num; ++i) {
                pos = this.annotation(pos);
                array[i] = this.currentAnno;
            }
            this.allAnno = array;
            return pos;
        }

        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            this.currentAnno = new Annotation(type, this.pool);
            return super.annotation(pos, type, numPairs);
        }

        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            pos = super.memberValuePair(pos, nameIndex);
            this.currentAnno.addMemberValue(nameIndex, this.currentMember);
            return pos;
        }

        @Override
        void constValueMember(int tag, int index) throws Exception {
            MemberValue m;
            ConstPool cp = this.pool;
            switch (tag) {
                case 66: {
                    m = new ByteMemberValue(index, cp);
                    break;
                }
                case 67: {
                    m = new CharMemberValue(index, cp);
                    break;
                }
                case 68: {
                    m = new DoubleMemberValue(index, cp);
                    break;
                }
                case 70: {
                    m = new FloatMemberValue(index, cp);
                    break;
                }
                case 73: {
                    m = new IntegerMemberValue(index, cp);
                    break;
                }
                case 74: {
                    m = new LongMemberValue(index, cp);
                    break;
                }
                case 83: {
                    m = new ShortMemberValue(index, cp);
                    break;
                }
                case 90: {
                    m = new BooleanMemberValue(index, cp);
                    break;
                }
                case 115: {
                    m = new StringMemberValue(index, cp);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown tag:" + tag);
                }
            }
            this.currentMember = m;
            super.constValueMember(tag, index);
        }

        @Override
        void enumMemberValue(int typeNameIndex, int constNameIndex) throws Exception {
            this.currentMember = new EnumMemberValue(typeNameIndex, constNameIndex, this.pool);
            super.enumMemberValue(typeNameIndex, constNameIndex);
        }

        @Override
        void classMemberValue(int index) throws Exception {
            this.currentMember = new ClassMemberValue(index, this.pool);
            super.classMemberValue(index);
        }

        @Override
        int annotationMemberValue(int pos) throws Exception {
            Annotation anno = this.currentAnno;
            pos = super.annotationMemberValue(pos);
            this.currentMember = new AnnotationMemberValue(this.currentAnno, this.pool);
            this.currentAnno = anno;
            return pos;
        }

        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            ArrayMemberValue amv = new ArrayMemberValue(this.pool);
            MemberValue[] elements = new MemberValue[num];
            for (int i = 0; i < num; ++i) {
                pos = this.memberValue(pos);
                elements[i] = this.currentMember;
            }
            amv.setValue(elements);
            this.currentMember = amv;
            return pos;
        }
    }

    public static class Copier
    extends Walker {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer;
        ConstPool srcPool;
        ConstPool destPool;
        Map<?, ?> classnames;

        public Copier(byte[] info, ConstPool src, ConstPool dest, Map<?, ?> map) {
            super(info);
            this.writer = new AnnotationsWriter(this.output, dest);
            this.srcPool = src;
            this.destPool = dest;
            this.classnames = map;
        }

        public byte[] close() throws IOException {
            this.writer.close();
            return this.output.toByteArray();
        }

        @Override
        public void parameters(int numParam, int pos) throws Exception {
            this.writer.numParameters(numParam);
            super.parameters(numParam, pos);
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            this.writer.numAnnotations(num);
            return super.annotationArray(pos, num);
        }

        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            this.writer.annotation(this.copy(type), numPairs);
            return super.annotation(pos, type, numPairs);
        }

        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            this.writer.memberValuePair(this.copy(nameIndex));
            return super.memberValuePair(pos, nameIndex);
        }

        @Override
        void constValueMember(int tag, int index) throws Exception {
            this.writer.constValueIndex(tag, this.copy(index));
            super.constValueMember(tag, index);
        }

        @Override
        void enumMemberValue(int typeNameIndex, int constNameIndex) throws Exception {
            this.writer.enumConstValue(this.copy(typeNameIndex), this.copy(constNameIndex));
            super.enumMemberValue(typeNameIndex, constNameIndex);
        }

        @Override
        void classMemberValue(int index) throws Exception {
            this.writer.classInfoIndex(this.copy(index));
            super.classMemberValue(index);
        }

        @Override
        int annotationMemberValue(int pos) throws Exception {
            this.writer.annotationValue();
            return super.annotationMemberValue(pos);
        }

        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            this.writer.arrayValue(num);
            return super.arrayMemberValue(pos, num);
        }

        int copy(int srcIndex) {
            return this.srcPool.copy(srcIndex, this.destPool, this.classnames);
        }
    }

    public static class Walker {
        byte[] info;

        Walker(byte[] attrInfo) {
            this.info = attrInfo;
        }

        public final void parameters() throws Exception {
            int numParam = this.info[0] & 0xFF;
            this.parameters(numParam, 1);
        }

        public void parameters(int numParam, int pos) throws Exception {
            for (int i = 0; i < numParam; ++i) {
                pos = this.annotationArray(pos);
            }
        }

        public final void annotationArray() throws Exception {
            this.annotationArray(0);
        }

        final int annotationArray(int pos) throws Exception {
            int num = X_Byte.readU16bit((byte[])this.info, (int)pos);
            return this.annotationArray(pos + 2, num);
        }

        int annotationArray(int pos, int num) throws Exception {
            for (int i = 0; i < num; ++i) {
                pos = this.annotation(pos);
            }
            return pos;
        }

        final int annotation(int pos) throws Exception {
            int type = X_Byte.readU16bit((byte[])this.info, (int)pos);
            int numPairs = X_Byte.readU16bit((byte[])this.info, (int)(pos + 2));
            return this.annotation(pos + 4, type, numPairs);
        }

        int annotation(int pos, int type, int numPairs) throws Exception {
            for (int j = 0; j < numPairs; ++j) {
                pos = this.memberValuePair(pos);
            }
            return pos;
        }

        final int memberValuePair(int pos) throws Exception {
            int nameIndex = X_Byte.readU16bit((byte[])this.info, (int)pos);
            return this.memberValuePair(pos + 2, nameIndex);
        }

        int memberValuePair(int pos, int nameIndex) throws Exception {
            return this.memberValue(pos);
        }

        final int memberValue(int pos) throws Exception {
            int tag = this.info[pos] & 0xFF;
            if (tag == 101) {
                int typeNameIndex = X_Byte.readU16bit((byte[])this.info, (int)(pos + 1));
                int constNameIndex = X_Byte.readU16bit((byte[])this.info, (int)(pos + 3));
                this.enumMemberValue(typeNameIndex, constNameIndex);
                return pos + 5;
            }
            if (tag == 99) {
                int index = X_Byte.readU16bit((byte[])this.info, (int)(pos + 1));
                this.classMemberValue(index);
                return pos + 3;
            }
            if (tag == 64) {
                return this.annotationMemberValue(pos + 1);
            }
            if (tag == 91) {
                int num = X_Byte.readU16bit((byte[])this.info, (int)(pos + 1));
                return this.arrayMemberValue(pos + 3, num);
            }
            int index = X_Byte.readU16bit((byte[])this.info, (int)(pos + 1));
            this.constValueMember(tag, index);
            return pos + 3;
        }

        void constValueMember(int tag, int index) throws Exception {
        }

        void enumMemberValue(int typeNameIndex, int constNameIndex) throws Exception {
        }

        void classMemberValue(int index) throws Exception {
        }

        int annotationMemberValue(int pos) throws Exception {
            return this.annotation(pos);
        }

        int arrayMemberValue(int pos, int num) throws Exception {
            for (int i = 0; i < num; ++i) {
                pos = this.memberValue(pos);
            }
            return pos;
        }
    }
}

