/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;
import xapi.bytecode.Descriptor;

class MethodTypeInfo
extends ConstInfo {
    static final int tag = 16;
    int descriptor;

    public MethodTypeInfo(DataInput in, int index) throws IOException {
        this.descriptor = in.readUnsignedShort();
    }

    public MethodTypeInfo(int desc, int index) {
        this.descriptor = desc;
    }

    public int copy(ConstPool src, ConstPool dest, Map map) {
        String desc = src.getUtf8Info(this.descriptor);
        desc = Descriptor.rename(desc, map);
        return dest.addMethodTypeInfo(dest.addUtf8Info(desc));
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodTypeInfo) {
            return ((MethodTypeInfo)obj).descriptor == this.descriptor;
        }
        return false;
    }

    @Override
    public int getTag() {
        return 16;
    }

    public int hashCode() {
        return this.descriptor;
    }

    @Override
    public void print(PrintWriter out) {
        out.print("MethodType #");
        out.println(this.descriptor);
    }

    public void renameClass(ConstPool cp, Map map, HashMap cache) {
        String desc2;
        String desc = cp.getUtf8Info(this.descriptor);
        if (desc != (desc2 = Descriptor.rename(desc, map))) {
            if (cache == null) {
                this.descriptor = cp.addUtf8Info(desc2);
            } else {
                cache.remove(this);
                this.descriptor = cp.addUtf8Info(desc2);
                cache.put(this, this);
            }
        }
    }

    public void renameClass(ConstPool cp, String oldName, String newName, HashMap cache) {
        String desc2;
        String desc = cp.getUtf8Info(this.descriptor);
        if (desc != (desc2 = Descriptor.rename(desc, oldName, newName))) {
            if (cache == null) {
                this.descriptor = cp.addUtf8Info(desc2);
            } else {
                cache.remove(this);
                this.descriptor = cp.addUtf8Info(desc2);
                cache.put(this, this);
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(16);
        out.writeShort(this.descriptor);
    }
}

