/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

public class FloatInfo
extends ConstInfo {
    static final int tag = 4;
    float value;

    public FloatInfo(float f) {
        this.value = f;
    }

    public FloatInfo(DataInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public int getTag() {
        return 4;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addFloatInfo(this.value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(4);
        out.writeFloat(this.value);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Float ");
        out.println(this.value);
    }
}

