/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;
import xapi.bytecode.Descriptor;

public class ClassInfo
extends ConstInfo {
    static final int tag = 7;
    int name;
    int index;

    public ClassInfo(int className, int i) {
        this.name = className;
        this.index = i;
    }

    public ClassInfo(DataInput in, int i) throws IOException {
        this.name = in.readUnsignedShort();
        this.index = i;
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public String getClassName(ConstPool cp) {
        return cp.getUtf8Info(this.name);
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName) {
        String nameStr2;
        String nameStr = cp.getUtf8Info(this.name);
        if (nameStr.equals(oldName)) {
            this.name = cp.addUtf8Info(newName);
        } else if (nameStr.charAt(0) == '[' && nameStr != (nameStr2 = Descriptor.rename(nameStr, oldName, newName))) {
            this.name = cp.addUtf8Info(nameStr2);
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<?, ?> map) {
        String oldName = cp.getUtf8Info(this.name);
        if (oldName.charAt(0) == '[') {
            String newName = Descriptor.rename(oldName, map);
            if (oldName != newName) {
                this.name = cp.addUtf8Info(newName);
            }
        } else {
            String newName = (String)map.get(oldName);
            if (newName != null && !newName.equals(oldName)) {
                this.name = cp.addUtf8Info(newName);
            }
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        String newname;
        String classname = src.getUtf8Info(this.name);
        if (map != null && (newname = (String)map.get(classname)) != null) {
            classname = newname;
        }
        return dest.addClassInfo(classname);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(7);
        out.writeShort(this.name);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Class #");
        out.println(this.name);
    }

    @Override
    void makeHashtable(ConstPool cp) {
        String name = Descriptor.toJavaName(this.getClassName(cp));
        cp.classes.put(name, this);
    }
}

