/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import xapi.bytecode.Annotated;
import xapi.bytecode.ClassPool;
import xapi.bytecode.ConstPool;
import xapi.bytecode.Descriptor;
import xapi.bytecode.FieldInfo;
import xapi.bytecode.MethodInfo;
import xapi.bytecode.NoSuchClassError;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.AnnotationsAttribute;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.bytecode.attributes.InnerClassesAttribute;
import xapi.bytecode.attributes.SourceFileAttribute;
import xapi.bytecode.impl.BytecodeUtil;
import xapi.source.X_Modifier;
import xapi.source.X_Source;
import xapi.util.X_Util;

public final class ClassFile
implements Annotated {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    ArrayList<FieldInfo> fields;
    ArrayList<MethodInfo> methods;
    ArrayList<AttributeInfo> attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_1 = 45;
    public static final int JAVA_2 = 46;
    public static final int JAVA_3 = 47;
    public static final int JAVA_4 = 48;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static final int JAVA_7 = 51;
    public static int MAJOR_VERSION = 47;

    public ClassFile(DataInput in) throws IOException {
        this.read(in);
    }

    public ClassFile(boolean isInterface, String classname, String superclass) {
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(classname);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = isInterface ? 1536 : 32;
        this.initSuperclass(superclass);
        this.interfaces = null;
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        this.thisclassname = classname;
        this.attributes = new ArrayList();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String superclass) {
        if (superclass != null) {
            this.superClass = this.constPool.addClassInfo(superclass);
            this.cachedSuperclass = superclass;
        } else {
            this.superClass = this.constPool.addClassInfo("java.lang.Object");
            this.cachedSuperclass = "java.lang.Object";
        }
    }

    private static String getSourcefileName(String qname) {
        int index = qname.lastIndexOf(46);
        if (index >= 0) {
            qname = qname.substring(index + 1);
        }
        return qname + ".java";
    }

    public void compact() {
        int i;
        ConstPool cp = this.compact0();
        int n = this.methods.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            minfo.compact(cp);
        }
        n = this.fields.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = this.fields.get(i);
            finfo.compact(cp);
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, cp);
        this.constPool = cp;
    }

    private ConstPool compact0() {
        ConstPool cp = new ConstPool(this.thisclassname);
        this.thisClass = cp.getThisClassInfo();
        String sc = this.getSuperclass();
        if (sc != null) {
            this.superClass = cp.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            int n = this.interfaces.length;
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = cp.addClassInfo(this.constPool.getClassInfo(this.interfaces[i]));
            }
        }
        return cp;
    }

    public void prune() {
        int i;
        AttributeInfo signature;
        AttributeInfo visibleAnnotations;
        ConstPool cp = this.compact0();
        ArrayList<AttributeInfo> newAttributes = new ArrayList<AttributeInfo>();
        AttributeInfo invisibleAnnotations = this.getAttribute("RuntimeInvisibleAnnotations");
        if (invisibleAnnotations != null) {
            invisibleAnnotations = invisibleAnnotations.copy(cp, null);
            newAttributes.add(invisibleAnnotations);
        }
        if ((visibleAnnotations = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            visibleAnnotations = visibleAnnotations.copy(cp, null);
            newAttributes.add(visibleAnnotations);
        }
        if ((signature = this.getAttribute("Signature")) != null) {
            signature = signature.copy(cp, null);
            newAttributes.add(signature);
        }
        int n = this.methods.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            minfo.prune(cp);
        }
        n = this.fields.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = this.fields.get(i);
            finfo.prune(cp);
        }
        this.attributes = newAttributes;
        this.constPool = cp;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int acc) {
        if ((acc & 0x200) == 0) {
            acc |= 0x20;
        }
        this.accessFlags = acc;
    }

    public int getInnerAccessFlags() {
        InnerClassesAttribute ica = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (ica == null) {
            return -1;
        }
        String name = this.getName();
        int n = ica.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(ica.innerClass(i))) continue;
            return ica.accessFlags(i);
        }
        return -1;
    }

    public int getThisClassIndex() {
        return this.thisClass;
    }

    public String getName() {
        return this.thisclassname;
    }

    public void setName(String name) {
        this.renameClass(this.thisclassname, name);
    }

    public String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public int getSuperclassId() {
        return this.superClass;
    }

    public void setSuperclass(String superclass) {
        if (superclass == null) {
            superclass = "java.lang.Object";
        }
        this.superClass = this.constPool.addClassInfo(superclass);
        this.cachedSuperclass = superclass;
    }

    public final void renameClass(String oldname, String newname) {
        String desc;
        int i;
        if (oldname.equals(newname)) {
            return;
        }
        if (oldname.equals(this.thisclassname)) {
            this.thisclassname = newname;
        }
        oldname = Descriptor.toJvmName(oldname);
        newname = Descriptor.toJvmName(newname);
        this.constPool.renameClass(oldname, newname);
        AttributeInfo.renameClass(this.attributes, oldname, newname);
        int n = this.methods.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            AttributeInfo.renameClass(minfo.getAttributes(), oldname, newname);
        }
        n = this.fields.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = this.fields.get(i);
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            AttributeInfo.renameClass(finfo.getAttributes(), oldname, newname);
        }
    }

    public final void renameClass(Map<?, ?> classnames) {
        String desc;
        int i;
        String jvmNewThisName = (String)classnames.get(Descriptor.toJvmName(this.thisclassname));
        if (jvmNewThisName != null) {
            this.thisclassname = Descriptor.toJavaName(jvmNewThisName);
        }
        this.constPool.renameClass(classnames);
        AttributeInfo.renameClass(this.attributes, classnames);
        int n = this.methods.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, classnames));
            AttributeInfo.renameClass(minfo.getAttributes(), classnames);
        }
        n = this.fields.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = this.fields.get(i);
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, classnames));
            AttributeInfo.renameClass(finfo.getAttributes(), classnames);
        }
    }

    public String[] getInterfaces() {
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        String[] rtn = null;
        if (this.interfaces == null) {
            rtn = new String[]{};
        } else {
            int n = this.interfaces.length;
            String[] list = new String[n];
            for (int i = 0; i < n; ++i) {
                list[i] = this.constPool.getClassInfo(this.interfaces[i]);
            }
            rtn = list;
        }
        this.cachedInterfaces = rtn;
        return rtn;
    }

    public void setInterfaces(String[] nameList) {
        this.cachedInterfaces = null;
        if (nameList != null) {
            int n = nameList.length;
            this.interfaces = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = this.constPool.addClassInfo(nameList[i]);
            }
        }
    }

    public void addInterface(String name) {
        this.cachedInterfaces = null;
        int info = this.constPool.addClassInfo(name);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = info;
        } else {
            int n = this.interfaces.length;
            int[] newarray = new int[n + 1];
            System.arraycopy(this.interfaces, 0, newarray, 0, n);
            newarray[n] = info;
            this.interfaces = newarray;
        }
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public void addField(FieldInfo finfo) {
        this.fields.add(finfo);
    }

    public List<MethodInfo> getMethods() {
        return this.methods;
    }

    public MethodInfo getMethod(String name) {
        int n = this.methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            if (!minfo.getName().equals(name)) continue;
            return minfo;
        }
        return null;
    }

    public final void addMethod(MethodInfo minfo) {
        this.methods.add(minfo);
    }

    public List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        ArrayList<AttributeInfo> list = this.attributes;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo ai = list.get(i);
            if (!ai.getName().equals(name)) continue;
            return ai;
        }
        return null;
    }

    public void addAttribute(AttributeInfo info) {
        AttributeInfo.remove(this.attributes, info.getName());
        this.attributes.add(info);
    }

    public String getSourceFile() {
        SourceFileAttribute sf = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sf == null) {
            return null;
        }
        return sf.getFileName();
    }

    private void read(DataInput in) throws IOException {
        int i;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("bad magic number: " + Integer.toHexString(magic));
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        this.constPool = new ConstPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisClass = in.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = in.readUnsignedShort();
        int n = in.readUnsignedShort();
        if (n == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n];
            for (i = 0; i < n; ++i) {
                this.interfaces[i] = in.readUnsignedShort();
            }
        }
        ConstPool cp = this.constPool;
        n = in.readUnsignedShort();
        this.fields = new ArrayList();
        for (i = 0; i < n; ++i) {
            this.addField(new FieldInfo(cp, in));
        }
        n = in.readUnsignedShort();
        this.methods = new ArrayList();
        for (i = 0; i < n; ++i) {
            this.addMethod(new MethodInfo(cp, in));
        }
        this.attributes = new ArrayList();
        n = in.readUnsignedShort();
        for (i = 0; i < n; ++i) {
            this.addAttribute(AttributeInfo.read(cp, in));
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public void write(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(-889275714);
        out.writeShort(this.minor);
        out.writeShort(this.major);
        this.constPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        int n = this.interfaces == null ? 0 : this.interfaces.length;
        out.writeShort(n);
        for (i = 0; i < n; ++i) {
            out.writeShort(this.interfaces[i]);
        }
        n = this.fields.size();
        out.writeShort(n);
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = this.fields.get(i);
            finfo.write(out);
        }
        n = this.methods.size();
        out.writeShort(n);
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = this.methods.get(i);
            minfo.write(out);
        }
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public void setMajorVersion(int major) {
        this.major = major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int minor) {
        this.minor = minor;
    }

    public void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }

    @Override
    public Annotation getAnnotation(String name) {
        Annotation anno;
        AttributeInfo attr = this.getAttribute("RuntimeVisibleAnnotations");
        if (attr != null && (anno = ((AnnotationsAttribute)attr).getAnnotation(name)) != null) {
            return anno;
        }
        attr = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attr == null) {
            return null;
        }
        return ((AnnotationsAttribute)attr).getAnnotation(name);
    }

    public Annotation getAnnotation(Class<?> annoClass) {
        Annotation anno = this.getAnnotation(annoClass.getName());
        if (anno == null) {
            return null;
        }
        return anno;
    }

    public boolean hasAnnotation(Class<?> annoClass) {
        Annotation anno = this.getAnnotation(annoClass.getName());
        return anno != null;
    }

    public <T extends java.lang.annotation.Annotation> T getAnnotation(Class<T> annoClass, ClassLoader loader) throws ClassNotFoundException, NoSuchClassError {
        Annotation anno = this.getAnnotation(annoClass);
        if (anno != null) {
            return (T)((java.lang.annotation.Annotation)anno.toAnnotationType(loader, new ClassPool()));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        AttributeInfo vis = this.getAttribute("RuntimeVisibleAnnotations");
        AttributeInfo invis = this.getAttribute("RuntimeInvisibleAnnotations");
        return BytecodeUtil.extractAnnotations((AnnotationsAttribute)vis, (AnnotationsAttribute)invis);
    }

    public Annotation getRuntimeAnnotation(String name) {
        AttributeInfo attr = this.getAttribute("RuntimeVisibleAnnotations");
        if (attr == null) {
            return null;
        }
        return ((AnnotationsAttribute)attr).getAnnotation(name);
    }

    public Annotation getCompileAnnotation(String name) {
        AttributeInfo attr;
        if (name.charAt(0) != '@') {
            name = '@' + name;
        }
        if ((attr = this.getAttribute("RuntimeInvisibleAnnotations")) == null) {
            return null;
        }
        return ((AnnotationsAttribute)attr).getAnnotation(name);
    }

    public String getPackage() {
        return X_Modifier.sourceNameToPackage((String)this.constPool.getClassName());
    }

    public String getEnclosedName() {
        return X_Modifier.sourceNameToEnclosed((String)this.constPool.getClassName());
    }

    public String getSimpleName() {
        String enclosed = this.getEnclosedName();
        int last = enclosed.lastIndexOf(46);
        return last == -1 ? enclosed : enclosed.substring(last + 1);
    }

    public String getQualifiedName() {
        return X_Source.qualifiedName((String)this.getPackage(), (String)this.getEnclosedName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassFile)) {
            return false;
        }
        ClassFile other = (ClassFile)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return X_Util.equal((Object)this.getSourceFile(), (Object)other.getSourceFile());
    }

    public String toString() {
        return X_Modifier.classModifiers((int)this.getAccessFlags()) + this.getName();
    }

    public String getResourceName() {
        return this.getPackage().replace('.', File.separatorChar) + File.separatorChar + this.getSourceFile();
    }

    public boolean isClass(String pkg, String enclosed) {
        return this.getPackage().equals(pkg) && this.getEnclosedName().equals(enclosed);
    }

    public boolean hasSuperClass(String superClass) {
        return this.getSuperclass().equals(superClass);
    }

    static {
        try {
            Class.forName("java.lang.StringBuilder");
            MAJOR_VERSION = 49;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

