/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.autoui.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import xapi.annotation.inject.InstanceOverride;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.platform.GwtDevPlatform;
import xapi.platform.JrePlatform;
import xapi.ui.autoui.api.BeanValueProvider;
import xapi.ui.autoui.api.DoNotIndex;
import xapi.ui.autoui.api.UiOptions;
import xapi.ui.autoui.api.UiRendererOptions;
import xapi.ui.autoui.api.UiRenderingContext;
import xapi.ui.autoui.api.UserInterfaceFactory;
import xapi.ui.autoui.impl.AbstractUserInterfaceFactory;
import xapi.util.X_Debug;
import xapi.util.api.ConvertsValue;

@JrePlatform
@GwtDevPlatform
@InstanceOverride(implFor=UserInterfaceFactory.class, priority=1)
public class UserInterfaceFactoryDefault
extends AbstractUserInterfaceFactory {
    private static final int MAX_DEPTH = 10;

    @Override
    protected UiRenderingContext[] getOptions(Class<?> type) {
        UiOptions opts;
        ArrayList<UiRenderingContext> options = new ArrayList<UiRenderingContext>();
        BeanValueProvider values = this.getBeanProvider(type);
        Package pkg = type.getPackage();
        if (pkg != null && pkg.isAnnotationPresent(UiOptions.class)) {
            options.addAll(this.extractRenderingContext(pkg.getAnnotation(UiOptions.class), values));
        }
        if (type.isAnnotationPresent(UiOptions.class) && (opts = type.getAnnotation(UiOptions.class)).fields().length > 0) {
            values.setChildKeys(opts.fields());
        }
        for (Class<?> check = type; check != null; check = check.getEnclosingClass()) {
            this.addAllRendererContexts(options, check, values);
        }
        for (Method m : type.getMethods()) {
            this.addAllRendererContexts(options, m, values);
        }
        return options.toArray(new UiRenderingContext[options.size()]);
    }

    protected void addAllRendererContexts(List<UiRenderingContext> options, AnnotatedElement element, BeanValueProvider values) {
        if (element.isAnnotationPresent(UiOptions.class)) {
            options.addAll(this.extractRenderingContext(element.getAnnotation(UiOptions.class), values));
        }
        if (element.isAnnotationPresent(UiRendererOptions.class)) {
            options.addAll(this.extractRenderingContext(element.getAnnotation(UiRendererOptions.class), values, element instanceof Method ? this.getNameFromMethod((Method)element) : null));
        }
    }

    @Override
    protected void recursiveAddBeanValues(BeanValueProvider bean, Class<?> cls, final ConvertsValue<Object, Object> converter, String prefix, int depth) {
        if (depth > 10) {
            X_Log.warn((Object[])new Object[]{this.getClass(), "Recursion sickness detected in " + cls + " from " + prefix + "; depth reached " + 10});
            if (X_Log.loggable((LogLevel)LogLevel.TRACE)) {
                X_Log.trace((Object[])new Object[]{"Consider using the @DoNotIndex annotation in the recursion chain produced by " + prefix});
            }
            return;
        }
        for (Method m : cls.getMethods()) {
            DoNotIndex noIndex;
            if (m.getParameterTypes().length != 0 || m.getDeclaringClass() == Object.class || m.getReturnType() == Void.TYPE || (noIndex = m.getAnnotation(DoNotIndex.class)) != null && noIndex.unlessDepthLessThan() >= depth) continue;
            String name = this.getNameFromMethod(m);
            String key = prefix.length() == 0 ? name : prefix + "." + name;
            final Method rootMethod = this.getRootMethod(m);
            ConvertsValue<Object, Object> valueConverter = new ConvertsValue<Object, Object>(){

                public Object convert(Object from) {
                    Object parent = converter.convert(from);
                    try {
                        return rootMethod.invoke(parent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw X_Debug.rethrow((Throwable)e);
                    }
                }
            };
            bean.addProvider(key, name, valueConverter);
            if (!this.isNotPrimitive(m.getReturnType())) continue;
            this.recursiveAddBeanValues(bean, m.getReturnType(), valueConverter, key, depth + 1);
        }
    }

    protected Method getRootMethod(Method m) {
        if (m.getDeclaringClass().isInterface()) {
            Method winner = m;
            for (Class<?> c : m.getDeclaringClass().getInterfaces()) {
                try {
                    Method method = c.getMethod(m.getName(), m.getParameterTypes());
                    if (!method.getDeclaringClass().isAssignableFrom(winner.getDeclaringClass())) continue;
                    winner = method;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return winner;
        }
        return m;
    }

    protected boolean isNotPrimitive(Class<?> cls) {
        return !cls.isPrimitive() && cls != String.class && (!cls.getPackage().getName().equals("java.lang") || cls != Boolean.class && cls != Byte.class && cls != Character.class && cls != Short.class && cls != Integer.class && cls != Long.class && cls != Float.class && cls != Double.class);
    }
}

