/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.autoui.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import xapi.log.X_Log;
import xapi.source.write.MappedTemplate;
import xapi.ui.autoui.api.BeanValueProvider;
import xapi.ui.autoui.api.UiOptions;
import xapi.ui.autoui.api.UiRenderer;
import xapi.ui.autoui.api.UiRendererOptions;
import xapi.ui.autoui.api.UiRendererSelector;
import xapi.ui.autoui.api.UiRenderingContext;
import xapi.ui.autoui.api.UserInterface;
import xapi.ui.autoui.api.UserInterfaceFactory;
import xapi.ui.autoui.api.Validator;
import xapi.util.X_Debug;
import xapi.util.X_Util;
import xapi.util.api.ConvertsValue;

public abstract class AbstractUserInterfaceFactory
implements UserInterfaceFactory {
    @Override
    public <T, U extends UserInterface<T>> U createUi(Class<? extends T> type, Class<? super U> uiType) {
        UiRenderingContext[] options = this.getOptions(type);
        ArrayList<UiRenderingContext> head = new ArrayList<UiRenderingContext>();
        ArrayList body = new ArrayList();
        ArrayList tail = new ArrayList();
        for (UiRenderingContext ctx : options) {
            (ctx.isHead() ? head : (ctx.isTail() ? tail : body)).add(ctx);
        }
        return this.instantiateUi(type, uiType, options);
    }

    protected abstract UiRenderingContext[] getOptions(Class<?> var1);

    protected UiRenderingContext createContext(Class<? extends UiRenderer> renderer, UiRendererOptions rendererOptions) {
        UiRenderingContext ctx = new UiRenderingContext(this.create(renderer));
        this.applyOptions(ctx, rendererOptions);
        return ctx;
    }

    protected void applyOptions(UiRenderingContext ctx, UiRendererOptions rendererOptions) {
        if (rendererOptions.isHead()) {
            ctx.setHead(true);
        } else if (rendererOptions.isTail()) {
            ctx.setTail(true);
        }
        if (rendererOptions.isWrapper()) {
            ctx.setWrapper(true);
        }
        ctx.setSelector(this.getSelector(ctx, rendererOptions));
        ctx.setValidators(this.getValidators(ctx, rendererOptions));
    }

    protected Collection<UiRenderingContext> extractRenderingContext(UiOptions annotation, BeanValueProvider bean) {
        ArrayList<UiRenderingContext> ctxes = new ArrayList<UiRenderingContext>();
        for (UiRendererOptions rendererOption : annotation.renderers()) {
            ctxes.addAll(this.extractRenderingContext(rendererOption, bean, null));
        }
        return ctxes;
    }

    protected Collection<UiRenderingContext> extractRenderingContext(UiRendererOptions rendererOption, BeanValueProvider bean, String methodName) {
        ArrayList<UiRenderingContext> ctxes = new ArrayList<UiRenderingContext>();
        for (Class<? extends UiRenderer> renderer : rendererOption.renderers()) {
            UiRenderingContext ctx = this.createContext(renderer, rendererOption);
            ctxes.add(ctx);
            BeanValueProvider ctxBean = methodName == null ? (rendererOption.isWrapper() ? bean.rebaseAll() : bean) : bean.rebase(methodName);
            ctx.setBeanProvider(ctxBean);
            String t = rendererOption.template();
            if (t.length() <= 0) continue;
            ArrayList<String> replaceables = new ArrayList<String>();
            for (String key : rendererOption.templatekeys()) {
                if (!t.contains(key)) continue;
                replaceables.add(key);
            }
            for (String key : ctxBean.getChildKeys()) {
                if (t.contains("${" + key + "}")) {
                    replaceables.add("${" + key + "}");
                }
                if (!t.contains("${" + key + ".name()}")) continue;
                replaceables.add("${" + key + ".name()}");
            }
            ctx.setTemplate(new MappedTemplate(t, replaceables.toArray(new String[replaceables.size()])));
        }
        return ctxes;
    }

    protected Validator[] getValidators(UiRenderingContext ctx, UiRendererOptions rendererOptions) {
        return null;
    }

    protected UiRendererSelector getSelector(UiRenderingContext ctx, UiRendererOptions rendererOptions) {
        return this.create(rendererOptions.selector());
    }

    protected <X> X create(Class<? extends X> renderer) {
        try {
            return renderer.newInstance();
        }
        catch (InstantiationException e) {
            throw X_Debug.rethrow((Throwable)(e.getCause() == null ? e : e.getCause()));
        }
        catch (IllegalAccessException e) {
            throw X_Util.rethrow((Throwable)e);
        }
    }

    @Override
    public BeanValueProvider getBeanProvider(Class<?> cls) {
        BeanValueProvider bean = new BeanValueProvider();
        ConvertsValue<Object, Object> valueConverter = new ConvertsValue<Object, Object>(){

            public Object convert(Object from) {
                return from;
            }
        };
        bean.addProvider("this", this.getName(cls), valueConverter);
        this.recursiveAddBeanValues(bean, cls, valueConverter, "", 0);
        return bean;
    }

    protected abstract void recursiveAddBeanValues(BeanValueProvider var1, Class<?> var2, ConvertsValue<Object, Object> var3, String var4, int var5);

    protected String getNameFromMethod(Method from) {
        if (from.isAnnotationPresent(Named.class)) {
            return from.getAnnotation(Named.class).value();
        }
        String name = from.getName();
        if (name.startsWith("get") || name.startsWith("has")) {
            if (name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                name = Character.toLowerCase(name.charAt(3)) + (name.length() > 4 ? name.substring(4) : "");
            }
        } else if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            name = Character.toLowerCase(name.charAt(2)) + (name.length() > 3 ? name.substring(3) : "");
        }
        return name;
    }

    protected String getName(Class<?> from) {
        if (from.isAnnotationPresent(Named.class)) {
            return from.getAnnotation(Named.class).value();
        }
        return from.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T, U extends UserInterface<T>> U instantiateUi(Class<? extends T> type, Class<? super U> uiType, UiRenderingContext[] head) {
        U ui = this.newUi(type, uiType);
        try {
            U u = ui;
            return u;
        }
        finally {
            ui.setRenderers(head);
        }
    }

    protected <T, U extends UserInterface<T>> U newUi(Class<? extends T> type, Class<? super U> uiType) {
        if (uiType == null) {
            throw new NullPointerException("Must specify UI type for " + type);
        }
        try {
            return (U)((UserInterface)uiType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            X_Log.error((Object[])new Object[]{this.getClass(), "Unable to instantiate", uiType, e});
            throw X_Debug.rethrow((Throwable)e);
        }
    }
}

