/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.autoui.impl;

import xapi.ui.autoui.api.UiRenderer;
import xapi.ui.autoui.api.UiRendererSelector;
import xapi.ui.autoui.api.UiRenderingContext;
import xapi.ui.autoui.api.UserInterface;
import xapi.util.X_Debug;

public abstract class AbstractUserInterface<T>
implements UserInterface<T> {
    private UiRenderingContext[] renderers;
    private int[] head;
    private int[] body;
    private int[] tail;

    @Override
    public final UserInterface<T> setRenderers(UiRenderingContext[] renderers) {
        this.renderers = renderers;
        this.head = new int[renderers.length];
        this.body = new int[renderers.length];
        this.tail = new int[renderers.length];
        int h = 0;
        int b = 0;
        int t = 0;
        int m = renderers.length;
        for (int i = 0; i < m; ++i) {
            UiRenderingContext ctx = renderers[i];
            if (ctx.isHead()) {
                this.head[h++] = i;
                continue;
            }
            if (ctx.isTail()) {
                this.tail[t++] = i;
                continue;
            }
            this.body[b++] = i;
        }
        this.head = AbstractUserInterface.copyOf(this.head, h);
        this.body = AbstractUserInterface.copyOf(this.body, b);
        this.tail = AbstractUserInterface.copyOf(this.tail, t);
        return this;
    }

    private static int[] copyOf(int[] arr, int len) {
        if (len == arr.length) {
            return arr;
        }
        int[] copy = new int[len];
        System.arraycopy(arr, 0, copy, 0, len);
        return copy;
    }

    @Override
    public final UserInterface<T> renderUi(T model) {
        for (int i : this.head) {
            this.doRender(this.renderers[i], model);
        }
        for (int i : this.body) {
            this.doRender(this.renderers[i], model);
        }
        for (int i : this.tail) {
            this.doRender(this.renderers[i], model);
        }
        return this;
    }

    protected abstract void doRender(UiRenderingContext var1, T var2);

    protected void recursiveRender(UiRenderingContext ctx, UiRenderer renderer, T model) {
        UiRendererSelector selector = ctx.getSelector();
        if (ctx.isWrapper()) {
            for (String key : ctx.getBeanValueProvider().getChildKeys()) {
                try {
                    if (!selector.useRenderer(this, renderer, key, model)) continue;
                    renderer.renderInto(this, ctx, key, model);
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    throw X_Debug.rethrow((Throwable)e);
                }
            }
        } else if (selector.useRenderer(this, renderer, ctx.getName(), model)) {
            renderer.renderInto(this, ctx, ctx.getName(), model);
        }
    }
}

