/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.autoui.api;

import java.util.ArrayList;
import javax.inject.Provider;
import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.source.write.MappedTemplate;
import xapi.ui.autoui.api.BeanValueProvider;
import xapi.ui.autoui.api.UiRenderer;
import xapi.ui.autoui.api.UiRendererSelector;
import xapi.ui.autoui.api.Validator;
import xapi.util.impl.ImmutableProvider;

public class UiRenderingContext {
    private static final MappedTemplate DEFAULT_TEMPLATE = new MappedTemplate("", new String[0]);
    private static final Validator[] DEFAULT_VALIDATORS = new Validator[0];
    private static final Object[] EMPTY_MESSAGES = new Object[0];
    private boolean head = false;
    private final Provider<UiRenderer<?>> renderProvider;
    private UiRendererSelector selector = UiRendererSelector.ALWAYS_TRUE;
    private boolean tail = false;
    private MappedTemplate template = DEFAULT_TEMPLATE;
    private Validator[] validators = DEFAULT_VALIDATORS;
    private boolean wrapper = false;
    private BeanValueProvider valueProvider;
    private String name = "";

    public UiRenderingContext(Provider<UiRenderer<?>> renderProvider) {
        this.renderProvider = renderProvider;
    }

    public UiRenderingContext(UiRenderer<?> renderer) {
        this((Provider<UiRenderer<?>>)new ImmutableProvider(renderer));
    }

    public String getName() {
        return this.name;
    }

    public final UiRenderer getRenderer() {
        return (UiRenderer)this.renderProvider.get();
    }

    public UiRendererSelector getSelector() {
        return this.selector;
    }

    public MappedTemplate getTemplate() {
        return this.template;
    }

    public String applyTemplate(String name, Object val) {
        StringTo map = X_Collect.newStringMap(Object.class);
        BeanValueProvider bean = this.getBeanValueProvider();
        MappedTemplate template = this.getTemplate();
        bean.fillMap(name, template, map, val);
        return template.applyMap(map.entries());
    }

    public Validator[] getValidators() {
        return this.validators;
    }

    public boolean isHead() {
        return this.head;
    }

    public boolean isTail() {
        return this.tail;
    }

    public boolean isTemplateSet() {
        return this.template != DEFAULT_TEMPLATE;
    }

    public boolean isValid(Object o) {
        if (this.validators.length == 0) {
            return true;
        }
        for (Validator validator : this.validators) {
            Object error = validator.isValid(o);
            if (Boolean.TRUE.equals(error) || error == null) continue;
            return false;
        }
        return true;
    }

    public boolean isWrapper() {
        return this.wrapper;
    }

    public UiRenderingContext setHead(boolean head) {
        this.head = head;
        return this;
    }

    public UiRenderingContext setName(String name) {
        this.name = name;
        return this;
    }

    public UiRenderingContext setSelector(UiRendererSelector selector) {
        assert (selector != null) : "You must supply a valid UiRendererSelector; Use UiRendererSelector.AlwaysTrue instead of null";
        this.selector = selector;
        return this;
    }

    public UiRenderingContext setTail(boolean tail) {
        this.tail = tail;
        return this;
    }

    public UiRenderingContext setTemplate(MappedTemplate template) {
        this.template = template;
        return this;
    }

    public UiRenderingContext setValidators(Validator[] validators) {
        this.validators = validators;
        return this;
    }

    public UiRenderingContext setWrapper(boolean wrapper) {
        this.wrapper = wrapper;
        return this;
    }

    public Object[] validate(Object o) {
        if (this.validators.length == 0) {
            return EMPTY_MESSAGES;
        }
        ArrayList errors = new ArrayList();
        for (Validator validator : this.validators) {
            Object error = validator.isValid(o);
            if (Boolean.TRUE.equals(error) || error == null) continue;
            errors.add(error);
        }
        return errors.toArray(new Object[errors.size()]);
    }

    public void setBeanProvider(BeanValueProvider bean) {
        this.valueProvider = bean;
    }

    public BeanValueProvider getBeanValueProvider() {
        return this.valueProvider;
    }
}

