/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.autoui.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import xapi.collect.api.StringTo;
import xapi.collect.impl.ArrayIterable;
import xapi.source.write.MappedTemplate;
import xapi.ui.autoui.api.HasName;
import xapi.util.api.ConvertsValue;

public class BeanValueProvider {
    private Map<String, ConvertsValue<Object, Object>> map = new LinkedHashMap<String, ConvertsValue<Object, Object>>();
    private String[] childKeys;

    private static Object getValue(String name, Object object, Map<String, ConvertsValue<Object, Object>> map) {
        if (!map.containsKey(name)) {
            BeanValueProvider.illegalArg(name);
        }
        return map.get(name).convert(object);
    }

    protected static Object illegalArg(String name) {
        throw new IllegalArgumentException("Value for field named " + name + " not found");
    }

    public void addProvider(String key, final String name, ConvertsValue<Object, Object> provider) {
        this.map.put(key, provider);
        ConvertsValue<Object, Object> namer = new ConvertsValue<Object, Object>(){

            public Object convert(Object from) {
                return from instanceof HasName ? ((HasName)from).getName() : name;
            }
        };
        this.map.put(key + ".name()", namer);
        if ("this".equals(key)) {
            this.map.put("$name", namer);
            this.map.put("$value", provider);
        }
    }

    protected Object valueOf(String name, Object object) {
        return BeanValueProvider.getValue(name, object, this.map);
    }

    protected String[] getKeys(Map<String, ConvertsValue<Object, Object>> map) {
        String[] keys = map.keySet().toArray(new String[map.size()]);
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = "${" + keys[i] + "}";
        }
        return keys;
    }

    protected String[] childKeys() {
        if (this.childKeys == null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<String, ConvertsValue<Object, Object>> entry : this.map.entrySet()) {
                String key = entry.getKey();
                if (key.indexOf(46) != -1 || "this".equals(key)) continue;
                keys.add(key);
            }
            this.childKeys = keys.toArray(new String[keys.size()]);
        }
        return this.childKeys;
    }

    public void setChildKeys(String[] keys) {
        this.childKeys = keys;
    }

    public Object getValue(String name, String context, Object object) {
        return this.valueOf(name, object);
    }

    public BeanValueProvider rebase(String methodName) {
        RebasedBeanValueProvider bean = new RebasedBeanValueProvider(methodName, new Converter());
        bean.childKeys = this.childKeys;
        bean.map = this.map;
        return bean;
    }

    public BeanValueProvider rebaseAll() {
        RebaseAllBeanValueProvider bean = new RebaseAllBeanValueProvider(new Converter());
        bean.childKeys = this.childKeys;
        bean.map = this.map;
        return bean;
    }

    public Iterable<String> getChildKeys() {
        return new ArrayIterable((Object[])this.childKeys());
    }

    public void fillMap(String name, MappedTemplate template, StringTo map, Object val) {
        if ("".equals(name)) {
            for (String key : this.childKeys()) {
                String k;
                String string = k = key.startsWith("$") ? key : "${" + key + "}";
                if (template.hasKey(k)) {
                    map.put(k, this.getValue(key, "", val));
                }
                if (!template.hasKey(k = "${" + key + ".name()}")) continue;
                map.put(k, (Object)key);
            }
        } else {
            val = this.getValue(name, "", val);
            map.put("$value", val);
            map.put("$name", (Object)name);
            map.put("${" + name + "}", val);
            map.put("${" + name + ".name()}", (Object)name);
        }
    }

    private class RebaseAllBeanValueProvider
    extends BeanValueProvider {
        private final Converter converter;

        private RebaseAllBeanValueProvider(Converter converter) {
            this.converter = converter;
        }

        @Override
        public Object getValue(String name, String context, Object object) {
            if ("$name".equals(name) || "this.name()".equals(name)) {
                return context;
            }
            if ("$value".equals(name) || "this".equals(name)) {
                return object;
            }
            if (context.length() > 0) {
                context = context + ".";
            }
            return this.converter.valueOf(context + name, object);
        }
    }

    private class RebasedBeanValueProvider
    extends BeanValueProvider {
        private final String name;
        private final Converter converter;

        public RebasedBeanValueProvider(String name, Converter converter) {
            this.name = name;
            this.converter = converter;
        }

        @Override
        public Object getValue(String name, String context, Object object) {
            if ("$name".equals(name) || "this.name()".equals(name) || (this.name + ".name()").equals(name)) {
                return this.name;
            }
            if ("$value".equals(name) || "this".equals(name) || this.name.equals(name)) {
                return this.converter.valueOf(this.name, object);
            }
            return this.converter.valueOf(this.name + "." + name, object);
        }
    }

    private class Converter {
        private Converter() {
        }

        protected Object valueOf(String name, Object object) {
            return BeanValueProvider.this.valueOf(name, object);
        }
    }
}

