/*
 * Decompiled with CFR 0.152.
 */
package xapi.process.impl;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import xapi.process.X_Process;
import xapi.process.api.AsyncLock;
import xapi.reflect.X_Reflect;
import xapi.util.api.SuccessHandler;

public abstract class ProcessQueueAbstract<T>
extends AbstractQueue<T> {
    private final int size;
    private int writeIndex;
    private int readIndex;
    private final T[] all;
    private final AsyncLock lock;

    public ProcessQueueAbstract(int knownSize) {
        this.size = knownSize;
        Class<T> cls = this.typeClass();
        this.all = X_Reflect.newArray(cls, (int)knownSize);
        this.lock = X_Process.newLock();
    }

    protected abstract Class<T> typeClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(final T e) {
        if (this.lock.tryLock()) {
            try {
                this.doPut(e);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.lock.lock(new SuccessHandler<AsyncLock>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(AsyncLock t) {
                    try {
                        ProcessQueueAbstract.this.doPut(e);
                    }
                    finally {
                        t.unlock();
                    }
                }
            });
        }
        return true;
    }

    private void doPut(T e) {
        if (this.writeIndex < this.size) {
            this.all[this.writeIndex++] = e;
        }
    }

    void unlock() {
        this.lock.unlock();
    }

    @Override
    public T poll() {
        if (this.readIndex == this.size) {
            throw new NoSuchElementException();
        }
        return this.all[this.readIndex++];
    }

    @Override
    public T peek() {
        return this.all[this.readIndex];
    }

    @Override
    public Iterator<T> iterator() {
        return null;
    }

    @Override
    public int size() {
        return this.writeIndex - this.readIndex;
    }
}

