/*
 * Decompiled with CFR 0.152.
 */
package xapi.process.impl;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import xapi.collect.impl.AbstractMultiInitMap;
import xapi.log.X_Log;
import xapi.process.api.ConcurrentEnvironment;
import xapi.process.api.Process;
import xapi.process.api.ProcessController;
import xapi.process.service.ConcurrencyService;
import xapi.util.X_Debug;
import xapi.util.X_Runtime;
import xapi.util.X_Util;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ReceivesValue;

public abstract class ConcurrencyServiceAbstract
implements ConcurrencyService {
    private final EnviroMap environments = this.initMap();
    private AtomicInteger threadCount = new AtomicInteger();

    protected abstract ConcurrentEnvironment initializeEnvironment(Thread var1, Thread.UncaughtExceptionHandler var2);

    protected int threadFlushTime() {
        return 2000;
    }

    @Override
    public Thread newThread(Runnable cmd) {
        WrappedRunnable wrapped = this.wrap(cmd);
        Thread childThread = new Thread(wrapped);
        childThread.setName(cmd.getClass().getName() + "_" + this.threadCount.incrementAndGet());
        Thread running = Thread.currentThread();
        ConcurrentEnvironment enviro = (ConcurrentEnvironment)this.environments.get(running, running.getUncaughtExceptionHandler());
        enviro.pushThread(childThread);
        return childThread;
    }

    protected WrappedRunnable wrap(Runnable cmd) {
        if (cmd instanceof WrappedRunnable) {
            return (WrappedRunnable)cmd;
        }
        return new WrappedRunnable(cmd);
    }

    protected ConcurrentEnvironment currentEnvironment() {
        Thread running = Thread.currentThread();
        return (ConcurrentEnvironment)this.environments.get(running, running.getUncaughtExceptionHandler());
    }

    protected EnviroMap initMap() {
        return new EnviroMap();
    }

    @Override
    public <T> ProcessController<T> newProcess(Process<T> process) {
        return new ProcessController<T>(process);
    }

    @Override
    public <T> void resolve(final Future<T> future, final ReceivesValue<T> receiver) {
        if (future.isDone()) {
            this.callback(future, receiver);
            return;
        }
        Thread otherThread = this.getFuturesThread();
        ConcurrentEnvironment enviro = (ConcurrentEnvironment)this.environments.get(otherThread, otherThread.getUncaughtExceptionHandler());
        enviro.monitor(ConcurrentEnvironment.Priority.Low, new Provider<Boolean>(){

            public Boolean get() {
                return future.isDone();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ConcurrencyServiceAbstract.this.callback(future, receiver);
            }
        });
    }

    protected Thread getFuturesThread() {
        return Thread.currentThread();
    }

    protected <T> void callback(Future<T> future, ReceivesValue<T> receiver) {
        try {
            receiver.set(future.get());
            return;
        }
        catch (InterruptedException e) {
            X_Debug.debug((Throwable)e);
            Thread.interrupted();
        }
        catch (ExecutionException e) {
            X_Debug.debug((Throwable)e);
            throw X_Util.rethrow((Throwable)X_Util.unwrap((Throwable)e));
        }
    }

    @Override
    public boolean kill(Thread thread, int timeout) {
        if (this.destroy(thread, timeout)) {
            return true;
        }
        try {
            thread.interrupt();
            return false;
        }
        catch (Exception e) {
            thread.stop();
            return false;
        }
    }

    private boolean destroy(Thread thread, int timeout) {
        if (this.environments.hasValue(thread.getName())) {
            ConcurrentEnvironment enviro = (ConcurrentEnvironment)this.environments.get(thread, thread.getUncaughtExceptionHandler());
            boolean success = enviro.destroy(timeout);
            this.environments.removeValue(thread.getName());
            return success;
        }
        return true;
    }

    @Override
    public boolean trySleep(float millis) {
        if (Thread.interrupted()) {
            return false;
        }
        float leftover = millis - (float)((int)millis);
        try {
            Thread.sleep((long)millis, (int)(leftover * 1000000.0f));
            return true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush(Thread thread, int timeout) {
        ConcurrentEnvironment enviro = (ConcurrentEnvironment)this.environments.getValue(thread.getName());
        if (thread == Thread.currentThread()) {
            if (enviro == null) {
                return true;
            }
            long deadline = System.currentTimeMillis() + (long)timeout;
            while (enviro.flush((int)(deadline - System.currentTimeMillis()))) {
                int timeLeft = (int)(deadline - System.currentTimeMillis());
                if (timeLeft < 1) {
                    return false;
                }
                Iterator<Thread> iter = enviro.getThreads().iterator();
                try {
                    Thread next;
                    ConcurrentEnvironment concurrentEnvironment = enviro;
                    synchronized (concurrentEnvironment) {
                        if (!iter.hasNext()) {
                            return true;
                        }
                        next = iter.next();
                        iter.remove();
                    }
                    if (next != null) {
                        next.join(timeLeft);
                    }
                }
                catch (InterruptedException e) {
                    this.destroy(Thread.currentThread(), timeLeft);
                    Thread.currentThread().interrupt();
                }
                if (System.currentTimeMillis() <= deadline) continue;
                return false;
            }
            return true;
        }
        if (enviro != null) {
            enviro.scheduleFlush(timeout);
        }
        return false;
    }

    @Override
    public double now() {
        return System.currentTimeMillis();
    }

    @Override
    public double threadStartTime(Thread thread) {
        return ((ConcurrentEnvironment)this.environments.get(thread, thread.getUncaughtExceptionHandler())).startTime();
    }

    public boolean isMultiThreaded() {
        return X_Runtime.isMultithreaded();
    }

    @Override
    public void runDeferred(Runnable cmd) {
        ConcurrentEnvironment enviro = this.currentEnvironment();
        enviro.pushDeferred(cmd);
    }

    @Override
    public void runEventually(Runnable cmd) {
        ConcurrentEnvironment enviro = this.currentEnvironment();
        enviro.pushEventually(cmd);
    }

    @Override
    public void runFinally(Runnable cmd) {
        ConcurrentEnvironment enviro = this.currentEnvironment();
        enviro.pushFinally(cmd);
    }

    protected class EnviroMap
    extends AbstractMultiInitMap<Thread, ConcurrentEnvironment, Thread.UncaughtExceptionHandler> {
        public EnviroMap() {
            super((ConvertsValue)new ConvertsValue<Thread, String>(){

                public String convert(Thread from) {
                    return from.getName();
                }
            });
        }

        protected ConcurrentEnvironment initialize(Thread key, Thread.UncaughtExceptionHandler params) {
            if (key.getState() == Thread.State.TERMINATED) {
                params.uncaughtException(key, new ThreadDeath());
            }
            if (key.isInterrupted()) {
                params.uncaughtException(key, new InterruptedException());
            }
            X_Log.debug((Object[])new Object[]{"Initializing Concurrent Environment", key});
            return ConcurrencyServiceAbstract.this.initializeEnvironment(key, params);
        }

        protected Thread.UncaughtExceptionHandler defaultParams() {
            return Thread.currentThread().getUncaughtExceptionHandler();
        }
    }

    protected class WrappedRunnable
    implements Runnable {
        private Runnable core;

        public WrappedRunnable(Runnable core) {
            this.core = core;
        }

        @Override
        public void run() {
            this.core.run();
            ConcurrencyServiceAbstract.this.destroy(Thread.currentThread(), ConcurrencyServiceAbstract.this.threadFlushTime());
        }
    }
}

