/*
 * Decompiled with CFR 0.152.
 */
package xapi.process.api;

import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import javax.inject.Provider;
import xapi.log.X_Log;
import xapi.process.X_Process;
import xapi.util.X_Debug;

public abstract class ConcurrentEnvironment {
    private final Object synchro = new Object();
    private static final double start = X_Process.now();

    public void monitor(Priority priority, Provider<Boolean> gate, Runnable job) {
    }

    public boolean hasFinalies() {
        return this.getFinally().iterator().hasNext();
    }

    public boolean hasDefers() {
        return this.getDeferred().iterator().hasNext();
    }

    public boolean isEmpty() {
        return !this.hasFinalies() && this.hasDefers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(int timeout) {
        if (this.isEmpty()) {
            return true;
        }
        double max = X_Process.now() + (double)timeout;
        try {
            do {
                if (this.hasFinalies()) {
                    System.out.println("run finallies");
                    this.runFinalies(max);
                }
                System.out.println("check timeout");
                this.checkTimeouts(max);
                Iterator<Runnable> iter = this.getDeferred().iterator();
                while (iter.hasNext()) {
                    Runnable next;
                    System.out.println("iterating job");
                    Object object = this.synchro;
                    synchronized (object) {
                        next = iter.next();
                        iter.remove();
                    }
                    next.run();
                    System.out.println("check finalies again");
                    if (this.hasFinalies()) {
                        System.out.println("has finalies");
                        this.runFinalies(max);
                    }
                    System.out.println("check timeout");
                    this.checkTimeouts(max);
                }
            } while (!this.isEmpty());
        }
        catch (TimeoutException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                if (X_Debug.isBenchmark()) {
                    X_Log.info((Object[])new Object[]{"Spent " + (X_Process.now() - (max - (double)timeout)) + " millis flushing environment"});
                }
                throw throwable;
            }
            if (X_Debug.isBenchmark()) {
                X_Log.info((Object[])new Object[]{"Spent " + (X_Process.now() - (max - (double)timeout)) + " millis flushing environment"});
            }
            return bl;
        }
        if (X_Debug.isBenchmark()) {
            X_Log.info((Object[])new Object[]{"Spent " + (X_Process.now() - (max - (double)timeout)) + " millis flushing environment"});
        }
        return false;
    }

    protected void checkTimeouts(double max) throws TimeoutException {
        if (X_Process.now() > max) {
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFinalies(double max) throws TimeoutException {
        Iterator<Runnable> iter = this.getFinally().iterator();
        while (iter.hasNext()) {
            Runnable next;
            Object object = this.synchro;
            synchronized (object) {
                next = iter.next();
                iter.remove();
            }
            next.run();
            if (!(X_Process.now() > max)) continue;
            throw new TimeoutException();
        }
    }

    public void scheduleFlush(int timeout) {
    }

    public boolean destroy(int timeout) {
        double max = X_Process.now() + (double)timeout;
        while (!this.isEmpty()) {
            int left = (int)(max - X_Process.now());
            if (left < 1) {
                return true;
            }
            this.flush(left);
        }
        return false;
    }

    public double startTime() {
        return start;
    }

    public abstract Iterable<Runnable> getDeferred();

    public abstract Iterable<Runnable> getFinally();

    public abstract Iterable<Thread> getThreads();

    public abstract void pushDeferred(Runnable var1);

    public abstract void pushEventually(Runnable var1);

    public abstract void pushFinally(Runnable var1);

    public abstract void pushThread(Thread var1);

    public static enum Strategy {
        Block,
        FixedPeriod,
        DecayingPeriod,
        Recycle;

    }

    public static enum Priority {
        High,
        Medium,
        Low;

    }
}

