/*
 * Decompiled with CFR 0.152.
 */
package xapi.process;

import java.util.concurrent.Future;
import javax.inject.Provider;
import xapi.inject.X_Inject;
import xapi.process.api.AsyncLock;
import xapi.process.api.Process;
import xapi.process.api.ProcessController;
import xapi.process.service.ConcurrencyService;
import xapi.util.api.ReceivesValue;

public class X_Process {
    private static final Provider<ConcurrencyService> service = X_Inject.singletonLazy(ConcurrencyService.class);

    public static <T> void block(Future<T> future, ReceivesValue<T> receiver) {
        ((ConcurrencyService)service.get()).resolve(future, receiver);
    }

    public static void runDeferred(Runnable cmd) {
        ((ConcurrencyService)service.get()).runDeferred(cmd);
    }

    public static void runEventually(Runnable cmd) {
        ((ConcurrencyService)service.get()).runEventually(cmd);
    }

    public static void runFinally(Runnable cmd) {
        ((ConcurrencyService)service.get()).runFinally(cmd);
    }

    public static void runTimeout(Runnable cmd, int milliDelay) {
        ((ConcurrencyService)service.get()).runTimeout(cmd, milliDelay);
    }

    public static Thread newThread(Runnable cmd) {
        return ((ConcurrencyService)service.get()).newThread(cmd);
    }

    public static <T> ProcessController<T> newProcess(Process<T> process) {
        return ((ConcurrencyService)service.get()).newProcess(process);
    }

    public static boolean flush(int timeout) {
        return X_Process.flush(Thread.currentThread(), timeout);
    }

    public static boolean flush(Thread thread, int timeout) {
        return ((ConcurrencyService)service.get()).flush(thread, timeout);
    }

    public static boolean trySleep(int millis) {
        return ((ConcurrencyService)service.get()).trySleep(millis);
    }

    public static void kill(Thread thread, int timeout) {
        ((ConcurrencyService)service.get()).kill(thread, timeout);
    }

    public static double threadStartTime() {
        return ((ConcurrencyService)service.get()).threadStartTime(Thread.currentThread());
    }

    public static double now() {
        return ((ConcurrencyService)service.get()).now();
    }

    public static AsyncLock newLock() {
        return ((ConcurrencyService)service.get()).newLock();
    }
}

