/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import xapi.annotation.model.DeleterFor;
import xapi.annotation.model.GetterFor;
import xapi.annotation.model.IsModel;
import xapi.annotation.model.SetterFor;
import xapi.annotation.reflect.Fluent;
import xapi.except.NotConfiguredCorrectly;
import xapi.model.api.Model;
import xapi.model.api.ModelManifest;

public class ModelUtil {
    public static ModelManifest createManifest(Class<? extends Model> cls) {
        ModelManifest manifest = new ModelManifest(cls);
        LinkedHashSet allTypes = new LinkedHashSet();
        ModelUtil.collectAllTypes(allTypes, cls);
        for (Class clazz : allTypes) {
            if (clazz == Model.class) continue;
            for (Method method : clazz.getMethods()) {
                if (method.getDeclaringClass() == Model.class || manifest.hasSeenMethod(method.getName())) continue;
                ModelManifest.MethodData property = manifest.addProperty(method.getName(), method.getAnnotation(GetterFor.class), method.getAnnotation(SetterFor.class), method.getAnnotation(DeleterFor.class));
                Class<Object> dataType = property.isGetter(method.getName()) ? method.getReturnType() : (method.getParameterTypes().length > 0 ? method.getParameterTypes()[0] : null);
                if (dataType != null) {
                    Class<?> oldType = property.getType();
                    if (oldType != null && oldType != dataType) {
                        throw new NotConfiguredCorrectly("Field " + property.getName() + " for " + cls + " has data type " + "disagreement; already saw type " + oldType + " but now saw " + dataType + ". Get/set/remove methods " + "must have identical type information");
                    }
                    property.setType(dataType);
                }
                property.addAnnotations(method.getAnnotations());
            }
        }
        return manifest;
    }

    private static void collectAllTypes(Collection<Class<?>> into, Class<?> cls) {
        into.add(cls);
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null && superCls != Object.class) {
            ModelUtil.collectAllTypes(into, cls);
        }
        ModelUtil.collectInterfaces(into, cls);
    }

    private static void collectInterfaces(Collection<Class<?>> into, Class<?> cls) {
        for (Class<?> iface : cls.getInterfaces()) {
            if (!into.add(iface)) continue;
            ModelUtil.collectInterfaces(into, iface);
        }
    }

    public static boolean isFluent(Method method) {
        Class<?> methodType = method.getDeclaringClass();
        Class<?> returnType = method.getReturnType();
        if (returnType == null || returnType == Void.TYPE) {
            return false;
        }
        if (ModelUtil.areAssignable(methodType, returnType)) {
            Fluent fluent = method.getAnnotation(Fluent.class);
            if (fluent != null) {
                return fluent.value();
            }
            if (method.getParameterTypes().length > 0 && ModelUtil.areAssignable(methodType, method.getParameterTypes()[0])) {
                throw new NotConfiguredCorrectly("Method " + method.toGenericString() + " in " + methodType + " has ambiguous return type; cannot tell if this method is Fluent. Please annotate " + "this method with @Fluent(true) if the method is supposed to `return this;` or " + "use @Fluent(false) if this method is supposed to return the first parameter.");
            }
            return true;
        }
        return false;
    }

    public static boolean areAssignable(Class<?> type1, Class<?> type2) {
        return type1.isAssignableFrom(type2) || type2.isAssignableFrom(type1);
    }

    public static String guessModelType(Class<? extends Model> cls) {
        IsModel isModel = cls.getAnnotation(IsModel.class);
        if (isModel == null) {
            return ModelUtil.guessModelType(cls.getSimpleName());
        }
        return isModel.modelType();
    }

    public static String guessModelType(String simpleName) {
        String type = simpleName.replace("Model", "");
        assert (type.length() > 0) : "Cannot have a model class named Model!";
        return Character.toLowerCase(type.charAt(0)) + type.substring(1);
    }
}

