/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.dev.source.CharBuffer;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.impl.DelegatingPrimitiveSerializer;
import xapi.source.api.CharIterator;

public class ClusteringPrimitiveSerializer
extends DelegatingPrimitiveSerializer {
    private final CharBuffer out;
    private final StringTo<Integer> strings;
    private final CharBuffer size = new CharBuffer();

    public ClusteringPrimitiveSerializer(PrimitiveSerializer primitives, CharBuffer out) {
        super(primitives);
        this.out = new CharBuffer();
        out.addToEnd(this.size);
        out.addToEnd(this.out);
        this.strings = X_Collect.newStringMap(Integer.class);
    }

    @Override
    public <C> Class<C> deserializeClass(CharIterator c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String deserializeString(CharIterator s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String serializeString(String s) {
        if (s == null) {
            return super.serializeInt(-1);
        }
        Integer position = (Integer)this.strings.get(s);
        if (position == null) {
            position = this.strings.size();
            this.strings.put(s, (Object)position);
            this.out.append(super.serializeString(s));
            this.size.clear();
            this.size.append(this.serializeInt(position + 1));
        }
        return super.serializeInt(position);
    }

    @Override
    public String serializeClass(Class<?> c) {
        if (c == null) {
            return super.serializeInt(-1);
        }
        return this.serializeString(c.getName());
    }
}

